<?php

/**
 * @author Shiva <shiva.dharana@univariety.com>
 * @package application.models
 *
 * BaseStudentIdealList is autogenerate by UniModel generator
 *
 * This is the model class for table "student_ideal_list".
 *
 * The followings are the available columns in table 'student_ideal_list':
 * @property string $student_ideal_list_id
 * @property string $user_ref_id
 * @property integer $department_ref_id
 * @property string $type
 * @property string $status
 * @property string $added_on
 * @property string $conclude_date
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LookupDepartment $departmentRef
 * @property StudentIdealListCollege[] $studentIdealListColleges
 */
class BaseStudentIdealList extends CActiveRecord
{
    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return StudentIdealList the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'student_ideal_list';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
        array('user_ref_id, department_ref_id, added_on', 'required'),
        array('department_ref_id', 'numerical', 'integerOnly'=>true),
        array('user_ref_id', 'length', 'max'=>10),
        array('type', 'length', 'max'=>12),
        array('status', 'length', 'max'=>9),
        array('conclude_date', 'safe'),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array('student_ideal_list_id, user_ref_id, department_ref_id, type, status, added_on, conclude_date', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
			'studentIdealListColleges' => array(self::HAS_MANY, 'StudentIdealListCollege', 'student_ideal_list_ref_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
			'student_ideal_list_id' => 'Student Ideal List',
			'user_ref_id' => 'User Ref',
			'department_ref_id' => 'Department Ref',
			'type' => 'Type',
			'status' => 'Status',
			'added_on' => 'Added On',
			'conclude_date' => 'Conclude Date',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('student_ideal_list_id',$this->student_ideal_list_id,true);
        $criteria->compare('user_ref_id',$this->user_ref_id,true);
        $criteria->compare('department_ref_id',$this->department_ref_id);
        $criteria->compare('type',$this->type,true);
        $criteria->compare('status',$this->status,true);
        $criteria->compare('added_on',$this->added_on,true);
        $criteria->compare('conclude_date',$this->conclude_date,true);

        return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
        ));
    }
}