<?php

class MilestoneController extends Controller
{

    public $layout = '//layouts/sms';

    public function filters(){
        return array(
        	'rights',
        );
    }

    public function allowedActions(){
        //put common actions like ajax suggestion lists etc.,
        return 'milestone61, Milestone61,
        		getStudentDepartmentUniversities, GetStudentDepartmentUniversities,
        		departmentSuggest, DepartmentSuggest,
        		universitySuggest, UniversitySuggest,
        		country, Country,
        		acceptUniversity, AcceptUniversity,
        		collegeListSuggest, CollegeListSuggest,
        		confirmList, ConfirmList,
        		deleteUniversty, DeleteUniversty,
        		departmentSuggest, DepartmentSuggest,
        		entranceExamSuggest, EntranceExamSuggest,
        		getStudentDepartmentUniversities, GetStudentDepartmentUniversities,
        		getVendors, GetVendors,
        		invalidateMilestone, InvalidateMilestone,
        		deleteEntranceExam,DeleteEntranceExam
        		rejectUniversity, RejectUniversity,
        		requestMilestoneChange, RequestMilestoneChange,
        		reviewUniversity, ReviewUniversity,
        		saveUniversityOrder, SaveUniversityOrder,
        		unidoneList, UnidoneList,
        		applyingUniversity,
        		milestone63,
        		CitySuggest,
        		test
        		';

    }

    public function actionMilestone1()
    {
        $userId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];
        $user = TblUserMaster::model()->findByPk($userId);

        if(isset($_POST['countryids'])){

            $careerids = array();
            $countryids = array();
            extract($_POST);
            foreach($courseids as $id)
            {
                if(empty($id))    continue;
                $course = explode('|', $id);
                $list[$course[2]]['main_dept_ref_id'] = $course[1];
                $list[$course[2]]['sub_dept_ref_id'] = $course[0];
            }
            $list1 = array();
            foreach($careerids as $id)
            {
                if(empty($id))    continue;
                $career = explode('|', $id);
                if($career[2])
                {
                    $list1[$career[2]]['main_dept_ref_id'] = $career[1];
                    $list1[$career[2]]['sub_dept_ref_id'] = $career[0];
                }
            }
            $i = 0;
            $countryList = array();
            foreach($countryids as $countryid)
            {
                if(!empty($countryid))
                {
                    $countryList[$i] = $countryid;
                }
                $i++;
            }
            $date = date('Y-m-d H:i:s');    // to maintain consistancy for saved records.
            $loggedFor = 'MS0-' . $date;
            $result = $user->setPreferredCourses($list, $loggedFor);
            $result1 = $user->setPreferredCareers($list1);
            $result1 = $user->setPreferredCountries($countryList, $loggedFor);
            


            UserMilestone::confirmMilestone($user->user_id, 1, $date);


        }
        $user->refresh();
        $this->render('milestone1', array('user' => $user));
    }

    public function actionMilestone2(){
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);

        if(isset($_POST['country']) && isset($_POST['course'])){

            if(!UserMilestone::isConfirmed($user->user_id, 1)) {
                UserMilestone::confirmMilestone($user->user_id, 1, $date);
            }
            //flip country ids from form checkboxes.
            $countries = array();//$array_flip($_POST['country']);
            foreach($_POST['country'] as $countryId => $v)
            $countries[] = $countryId;

            // form user preference order to save into usermaster
            $courses = array();
            foreach($_POST['course'] as $mainId => $subIds)
            foreach($subIds as $subId => $v)
            $courses[] = array('main_dept_ref_id' => $mainId, 'sub_dept_ref_id' => $subId);


            //Save the records.
            $date = date('Y-m-d H:i:s');    // to maintain consistancy for saved records.
            $loggedFor = 'MS1-' . $date;
            $user->setPreferredCourses($courses, $loggedFor);
            $user->setPreferredCountries($countries, $loggedFor);
            

            // Save to student milestone table for future reference.
            UserMilestone::confirmMilestone($userId, 2, $date);


            Yii::app()->user->setFlash('milestoneMessage', 'Your preferences saved successfully.');
            $this->redirect(Yii::app()->createUrl('sms/milestone/milestone2'));
        }


        $this->render('milestone2', array('user' => $user));
    }

    // auto complete action for country
    public function actionCountry(){
         
        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        if ($term)
        {
            $term = mysql_escape_string($term);
            $sql = 'SELECT country_id AS id, `country_name` AS "value"
							 FROM 
							 	`tbl_country_master` where LCASE(`country_name`)
			 				LIKE :country_name  ORDER BY (CASE WHEN `country_name` LIKE "' . $term . '%" THEN 0 ELSE 1 END ), `country_name` limit 0,10' ;
            $cmd = Yii::app()->db->createCommand($sql);
            $cmd->bindValue(":country_name","%".strtolower($term)."%", PDO::PARAM_STR);
            $res = $cmd->queryAll();
        }		
        echo CJSON::encode($res);
        Yii::app()->end();
    }

    public function actionMilestone4(){

        $studentId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];

        $data['student'] = TblUserMaster::model()->findByPk($studentId);

        if(empty($_GET['departmentId'])){
            $result = StudentPreferredDepartment::model()->findByAttributes(array('user_ref_id' => $studentId));
            if($result){
                $departmentId = $result->sub_dept_ref_id;
            }else{
                //throw new CHttpException(404, 'Found no courses');
                // course not found, must not have finished ms2.
                $this->render('milestone4', $data);
                return;
            }
        }else{
            $departmentId = $_GET['departmentId'];
        }

        $aspiration = StudentIdealList::getRecord($studentId, $departmentId, StudentIdealList::TYPE_ASPIRATIONAL);
        $bestFit = StudentIdealList::getRecord($studentId, $departmentId, StudentIdealList::TYPE_BEST_FIT);

        /**
         * A university is being added to college list
         * Here by student
         */
        if(isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 'add-university'){
            $universityId = $_REQUEST['universityId'];
            $type = $_REQUEST['type'];
            switch($type){
                case StudentIdealList::TYPE_ASPIRATIONAL: $studentIdealList = $aspiration; break;
                case StudentIdealList::TYPE_BEST_FIT: $studentIdealList = $bestFit; break;
            }

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $studentIdealListCollege = new StudentIdealListCollege;
            $studentIdealListCollege->uni_ref_id = $universityId;
            $studentIdealListCollege->suggest_type = StudentIdealListCollege::SUGGEST_TYPE_STUDENT;

            $bl = $studentIdealListCollege->addUniversity($studentIdealList);
            if($bl){
                $ajaxOp['html'] = $this->renderPartial('_ms4CollegeRow', array(
                    'university' => $studentIdealListCollege,
                	'idealType' => $type,
                    'hideRecord' => false,
                ), true, true);
                $ajaxOp['disableInput'] = ($studentIdealList->studentAddedCount >= 8);
                $ajaxOp['enableSubmit'] = $studentIdealList->isReadyToConfirm();
            }else{
                $ajaxOp['status'] = 'failed';
                $ajaxOp['error'] = array_values($studentIdealListCollege->getErrors());
            }

            echo CJSON::encode($ajaxOp);
            Yii::app()->end();
        }

        $data['type'][StudentIdealList::TYPE_ASPIRATIONAL] = $aspiration;
        $data['type'][StudentIdealList::TYPE_BEST_FIT] = $bestFit;

        $data['departmentId'] = $departmentId;
        $this->render('milestone4', $data);

    }

    /**
     * This action will return the university suggestion as per student department and country preferences.
     * @param string $term
     * @param int $student
     * @param int $department
     * @return outputs json encoded data
     */
    public function actionCollegeListSuggest($term, $student, $department){
        $results = TblUniversityMaster::getSuggestionListForStudent($student, $department, $term, 10);

        // Form json to serve to autosuggest.
        $op = array();
        foreach($results as $result){
            $op[] = array(
            			'id' => $result->uni_id,
            			'value' => $result->uni_name,
                        'url' => $result->website_url,
            );
        }

        echo  CJSON::encode($op);
    }

    public function actionAcceptUniversity(){
        if(isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 'accept-university'){
            // Pick a view to load based on page.
            $isBackend = (isset($_REQUEST['view']) && $_REQUEST['view'] == 'backend');
            $view = $isBackend?'_ms4HelperCollegeRow' : '_ms4CollegeRow';
            $collegeId = $_REQUEST['list'];

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $studentIdealListCollege = StudentIdealListCollege::model()->findByPk($collegeId);
            if(is_null($studentIdealListCollege)){
                throw new CHttpException(404,'The specified student list college cannot be found.');
            }
            $studentIdealListCollege->status = StudentIdealListCollege::STATUS_ACCEPTED;
            $bl = $studentIdealListCollege->save();

            $studentIdealListCollege->refresh();
            if($bl){
                $studentIdealList = StudentIdealList::model()->findByPk($studentIdealListCollege->student_ideal_list_ref_id);
                $ajaxOp['html'] = $this->renderPartial($view, array(
                    'university' => $studentIdealListCollege,
                    'idealType' => $studentIdealList->type,
                ), true, true);
                $roleAddedCount = $isBackend ? 'advisorAddedCount' : 'studentAddedCount';
                $ajaxOp['disableInput'] = ($studentIdealList->$roleAddedCount > 8);
                $ajaxOp['enableSubmit'] = $studentIdealList->isReadyToConfirm();
                


            }else{
                $ajaxOp['status'] = 'failed';
                $ajaxOp['error'] = array_values($studentIdealListCollege->getErrors());
            }

            echo CJSON::encode($ajaxOp);
            Yii::app()->end();

        }
    }

    public function actionRejectUniversity(){

        if(isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 'reject-university'){
            $isBackend = (isset($_REQUEST['view']) && $_REQUEST['view'] == 'backend');
            $collegeId = $_REQUEST['list'];

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $studentIdealListCollege = StudentIdealListCollege::model()->findByPk($collegeId);
            if(is_null($studentIdealListCollege)){
                throw new CHttpException(404,'The specified student list college cannot be found.');
            }
            $listId = $studentIdealListCollege->student_ideal_list_ref_id;
            $studentIdealListCollege->status = StudentIdealListCollege::STATUS_REJECTED;
            $bl = $studentIdealListCollege->save();
            //delete the rejected university.
            // For logging purpose, save it as rejected, and then delete it.
            $studentIdealListCollege->delete();

            if($bl){
                $studentIdealList = StudentIdealList::model()->findByPk($listId);
                $roleAddedCount = $isBackend ? 'advisorAddedCount' : 'studentAddedCount';
                $ajaxOp['disableInput'] = ($studentIdealList->$roleAddedCount > 8);
                $ajaxOp['enableSubmit'] = $studentIdealList->isReadyToConfirm();
            }else{
                $ajaxOp['status'] = 'failed';
                $ajaxOp['error'] = array_values($studentIdealListCollege->getErrors());
            }

            echo CJSON::encode($ajaxOp);
        }
    }


    public function actionConfirmList(){
        if(isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 'confirm-list'){
            $listId = $_REQUEST['list'];
            $studentId = Yii::app()->user->sub_id;

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';


            $studentIdealList = StudentIdealList::model()->findByPk($listId);
            if(is_null($studentIdealList) || $studentIdealList->user_ref_id != $studentId){
                throw new CHttpException(404, 'Invalid Request');
            }
            $studentIdealList->scenario = 'confirm';
            $studentIdealList->status = StudentIdealList::STATUS_CONFIRMED;
            $studentIdealList->conclude_date = date('Y-m-d H:i:s');
            $bl = $studentIdealList->save();

            if($bl){
                // Confirm ms4
                if(UserMilestone::areMs4ListsConfirmed($studentIdealList->user_ref_id)){
                    UserMilestone::confirmMilestone($studentIdealList->user_ref_id, 4);
                    $ajaxOp['reload'] = true;
                }
                $ajaxOp['html'] = $this->renderPartial('_idealList', array(
                    'studentIdealList' => $studentIdealList,
                    'idealType' => $studentIdealList->type,
                ), true, true);
            }else{
                $ajaxOp['status'] = 'failed';
                $ajaxOp['error'] = array_values($studentIdealList->getErrors());
            }
            echo CJSON::encode($ajaxOp);
        }
    }

    public function actionMs4Helper(){

        $studentId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];
        $type = empty($_GET['type']) ? StudentIdealList::TYPE_ASPIRATIONAL : $_GET['type'];
        if(empty($_GET['departmentId'])){
            $result = StudentPreferredDepartment::model()->findByAttributes(array('user_ref_id' => $studentId));
            if($result){
                $departmentId = $result->sub_dept_ref_id;
            }else{
                throw new CHttpException(404, 'Found no courses');
            }
        }else{
            $departmentId = $_GET['departmentId'];
        }


        $studentIdealList = StudentIdealList::getRecord($studentId, $departmentId, $type);

        /**
         * A university is being added to college list
         * Here by student
         */
        if(isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 'add-university'){
            $universityId = $_REQUEST['universityId'];
            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $studentIdealListCollege = new StudentIdealListCollege;
            $studentIdealListCollege->uni_ref_id = $universityId;
            $studentIdealListCollege->suggest_type = StudentIdealListCollege::SUGGEST_TYPE_ADVISOR;

            $bl = $studentIdealListCollege->addUniversity($studentIdealList);
            if($bl){
                $ajaxOp['html'] = $this->renderPartial('_ms4HelperCollegeRow', array(
                    'university' => $studentIdealListCollege,
                	'idealType' => $type,
                    'hideRecord' => false,
                ), true, true);
                $ajaxOp['disableInput'] = ($studentIdealList->advisorAddedCount >= 8);
            }else{
                $ajaxOp['status'] = 'failed';
                $ajaxOp['error'] = array_values($studentIdealListCollege->getErrors());
            }
            echo CJSON::encode($ajaxOp);
            Yii::app()->end();
        }

        $data['studentIdealList'] = $studentIdealList;
        $data['idealType'] = $type;
        $data['departmentId'] = $departmentId;
        $data['student'] = TblUserMaster::model()->findByPk($studentId);
        $this->render('milestone4Backend', $data);

    }

    public function actionDeleteUniversity(){

        if(isset($_POST['ajax']) && $_POST['ajax'] == 'delete-university'){
            $isBackend = (isset($_REQUEST['view']) && $_REQUEST['view'] == 'backend');
            $collegeId = $_POST['list'];

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $studentIdealListCollege = StudentIdealListCollege::model()->findByPk($collegeId);
            if(is_null($studentIdealListCollege)){
                throw new CHttpException(404,'The specified student list college cannot be found.');
            }
            $listId = $studentIdealListCollege->student_ideal_list_ref_id;
            $bl = $studentIdealListCollege->delete();

            if($bl){

                $studentIdealList = StudentIdealList::model()->findByPk($listId);
                $roleAddedCount = $isBackend ? 'advisorAddedCount' : 'studentAddedCount';
                $ajaxOp['disableInput'] = ($studentIdealList->$roleAddedCount > 8);

            }else{
                $ajaxOp['status'] = 'failed';
                $ajaxOp['error'] = array_values($studentIdealListCollege->getErrors());
            }

            echo CJSON::encode($ajaxOp);
            Yii::app()->end();
        }
    }

    /**
     * This action will mark a ideal list as unidone.
     */
    public function actionUnidoneList(){
        if(isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 'unidone-list'){
            $listId = $_REQUEST['list'];

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $studentIdealList = StudentIdealList::model()->findByPk($listId);
            if(is_null($studentIdealList)){
                throw new CHttpException(404, 'Invalid Request');
            }
            $studentIdealList->status = StudentIdealList::STATUS_UNIDONE;
            $bl = $studentIdealList->save();

            /*if($studentIdealList->type = StudentIdealList::TYPE_SAFE){
             if(UserMilestone::areMs5ListsDone($studentIdealList->user_ref_id)){
             UserMilestone::confirmMilestone($studentIdealList->user_ref_id, 5);
             }
             }*/

            if(!$bl){
                $ajaxOp['status'] = 'failed';
                $ajaxOp['error'] = array_values($studentIdealList->getErrors());
            }
            echo CJSON::encode($ajaxOp);
        }
    }

    public function actionReviewUniversity(){
        if(isset($_POST['StudentIdealListCollege'])){
            $isBackend = true;

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $studentIdealListCollege = StudentIdealListCollege::model()->findByPk($_POST['StudentIdealListCollege']['student_ideal_list_college_id']);
            $studentIdealListCollege->attributes = $_POST['StudentIdealListCollege'];
            $studentIdealListCollege->comment_by = Yii::app()->user->id;
            $studentIdealListCollege->review_date = date('Y-m-d H:i:s');
            $studentIdealListCollege->status = StudentIdealListCollege::STATUS_REVIEWED;

            $bl = $studentIdealListCollege->save();
            $studentIdealListCollege->refresh();
            $studentIdealList = StudentIdealList::model()->findByPk($studentIdealListCollege->student_ideal_list_ref_id);
            if(!$bl){
                $ajaxOp['status'] = 'failed';
                $ajaxOp['error'] = array_values($studentIdealListCollege->getErrors());
            }else{

                $ajaxOp['html'] = $this->renderPartial('_ms4HelperCollegeRow', array(
                    'university' => $studentIdealListCollege,
                    'idealType' => $studentIdealList->type,
                ), true, true);

            }
            echo CJSON::encode($ajaxOp);
        }
    }

    public function actionSaveUniversityOrder(){
        if(isset($_POST['ajax']) && $_POST['ajax'] == 'save-order'){
            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $preferences = $_POST['preference'];

            for($i = 0, $cnt = count($preferences); $i < $cnt; ++$i){
                $studentIdealListCollege = StudentIdealListCollege::model()->findByPk($preferences[$i]);
                $studentIdealListCollege->preference_order = $i + 1;
                if(!$studentIdealListCollege->save()){
                    $failed = true;
                    break;
                }
            }
            echo CJSON::encode($ajaxOp);
        }
    }

    public function actionMilestone5(){

        $studentId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];
        $student = TblUserMaster::model()->findByPk($studentId);
        $data['student'] = $student;

        if(empty($_GET['departmentId'])){
            $result = StudentPreferredDepartment::model()->findByAttributes(array('user_ref_id' => $studentId));
            if($result){
                $departmentId = $result->sub_dept_ref_id;
            }else{
                // throw new CHttpException(404, 'Found no courses');
                // course not found, must not have finished ms2.
                $this->render('milestone5', $data);
                return;
            }
        }else{
            $departmentId = $_GET['departmentId'];
        }

        if(isset($_POST['axn']) && $_POST['axn'] == 'confirmMilestone'){
            if(StudentIdealListCollege::getApplyingListCount($student, $departmentId) > 0){
                $list = StudentIdealList::getRecord($student->user_id, $departmentId, StudentIdealList::TYPE_SAFE);
                $list->status = StudentIdealList::STATUS_CONFIRMED;
                $list->save();
                if(UserMilestone::areMs5ListsConfirmed($student)){
                    UserMilestone::confirmMilestone($studentId, 5);
                }
            }else{
                $data['errorMessage'] = 'Please mark atleast one college as "Applying"';
            }
        }

        $aspirational = StudentIdealList::getRecord($studentId, $departmentId, StudentIdealList::TYPE_ASPIRATIONAL);
        $bestfit = StudentIdealList::getRecord($studentId, $departmentId, StudentIdealList::TYPE_BEST_FIT);
        $safe = StudentIdealList::getRecord($studentId, $departmentId, StudentIdealList::TYPE_SAFE);

        /**
         * A university is being added to college list
         * Here by student
         */
        if(isset($_POST['ajax']) && $_POST['ajax'] == 'add-university'){
            $universityId = $_POST['universityId'];

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';
            $studentIdealList = $safe;

            $studentIdealListCollege = new StudentIdealListCollege;
            $studentIdealListCollege->uni_ref_id = $universityId;
            $studentIdealListCollege->suggest_type = StudentIdealListCollege::SUGGEST_TYPE_STUDENT;
            $studentIdealListCollege->is_applying = StudentIdealListCollege::APPLYING;


            $bl = $studentIdealListCollege->addUniversity($studentIdealList);
            if($bl){
                $ajaxOp['html'] = $this->renderPartial('_ms5CollegeRow', array(
                    'university' => $studentIdealListCollege,
                	'idealType' => $type,
                    'hideRecord' => false,
                ), true, true);
                $ajaxOp['disableInput'] = ($studentIdealList->acceptedCount >= 8);
                $ajaxOp['enableSubmit'] = true;
            }else{
                $ajaxOp['status'] = 'failed';
                $ajaxOp['error'] = array_values($studentIdealListCollege->getErrors());
            }

            echo CJSON::encode($ajaxOp);
            Yii::app()->end();
        }



        $data['type'][StudentIdealList::TYPE_ASPIRATIONAL] = $aspirational;
        $data['type'][StudentIdealList::TYPE_BEST_FIT] = $bestfit;
        $data['type'][StudentIdealList::TYPE_SAFE] = $safe;

        $data['departmentId'] = $departmentId;
        $this->render('milestone5', $data);

    }

    /**
     * Dashboard page for milestone 1
     */
    public function actionMs1Helper(){
        $studentId = @$_GET['studentId'];
        $student = TblUserMaster::model()->findByPk($studentId);
        if(empty($student)){
            throw new CHttpException(404, 'Invalid Student');
        }
        $data = array();

        $data['student'] = $student;
        $this->render('ms1Helper', $data);
    }

    /**
     * Dashboard page for milestone 2
     */
    public function actionMs2Helper(){
        $studentId = @$_GET['studentId'];
        $student = TblUserMaster::model()->findByPk($studentId);
        if(empty($student)){
            throw new CHttpException(404, 'Invalid Student');
        }
        $data = array();

        $data['student'] = $student;
        $this->render('ms2Helper', $data);
    }

    public function actionInvalidateMilestone(){
        if(isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 'invalidate-milestone'){
            $id = $_REQUEST['id'];

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $milestone = UserMilestone::model()->findByPk($id);

            $bl = $milestone->invalidateMilestone();

            if($bl){
                //
            }else{
                $ajaxOp['status'] = 'failed';
            }
            echo CJSON::encode($ajaxOp);
        }
    }

    public function actionMilestone3(){
        $studentId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];

        $data['student'] = TblUserMaster::model()->findByPk($studentId);

        if(empty($_GET['departmentId'])){
            $result = StudentPreferredDepartment::model()->findByAttributes(array('user_ref_id' => $studentId));
            if($result){
                $departmentId = $result->sub_dept_ref_id;
            }else{
                //throw new CHttpException(404, 'Found no courses');
                // course not found, must not have finished ms2.
                $this->render('milestone3', $data);
                return;
            }
        }else{
            $departmentId = $_GET['departmentId'];
        }

        if (!empty($_POST)) {
            if(isset($_POST['StudentEntranceExamVendorBranch'])){

                $studentChosenBranches = $_POST['StudentEntranceExamVendorBranch'];
                $notSure = isset($studentChosenBranches['notSure']);
                $valid = true;

                // if student chooses to pick not sure
                if($notSure){
                    $valid = StudentEntranceExamVendorBranch::markAsNotSure($studentId, $departmentId);
                }else{
                    // remove old records,
                    StudentEntranceExamVendorBranch::model()->deleteAllByAttributes( array('user_ref_id' => $studentId, 'sub_dept_ref_id' => $departmentId) );
                    $vendorBranchCount = 0;
                    foreach($studentChosenBranches as $i => $chosenBranch){
                        if(empty($chosenBranch['vendor_branch_ref_id']))    continue;
                        $studentEntranceExamVendorBranch = new StudentEntranceExamVendorBranch();
                        $studentEntranceExamVendorBranch->attributes = $chosenBranch;
                        $studentEntranceExamVendorBranch->sub_dept_ref_id = $departmentId;
                        $studentEntranceExamVendorBranch->user_ref_id = $studentId;
                        $valid = $studentEntranceExamVendorBranch->save(false) && $valid;
                        $vendorBranchCount++;
                    }

                }

                if($vendorBranchCount == 0 && !$notSure){
                    $data['errorMessage'] = 'Please select atleast one vendor.';
                } else {
                    if(UserMilestone::areMs3ListsConfirmed($studentId)){
                        UserMilestone::confirmMilestone($studentId, 3);
                    }
                }
            } else {
                foreach ($_POST as $key=>$value) {
                    if ((strpos($key, 'ac-') !== false) && ($value != '')) {
                        $entrance_id = EntranceExam::getTestIdByAttribute('entrance_short_name', $value);
                        if (in_array($entrance_id, $_POST['exclude'])) {
                            if (!UserEntranceExam::fetchUserEnteredExam($studentId, 'entrance_exam_ref_id', $entrance_id)) {
                                $student_entrance_exam = new UserEntranceExam();
                                $student_entrance_exam->user_ref_id = $studentId;
                                $student_entrance_exam->entrance_exam_ref_id = $entrance_id;
                                $student_entrance_exam->exam_status = 'Planned';
                                $student_entrance_exam->added_by = Yii::app()->user->id;
                                $student_entrance_exam->save(false);
                            }
                        } else {
                            if (!UserEntranceExam::fetchUserEnteredExam($studentId, 'user_entered_entrance', $value)) {
                                $student_entrance_exam = new UserEntranceExam();
                                $student_entrance_exam->user_ref_id = $studentId;
                                $student_entrance_exam->user_entered_entrance = $value;
                                $student_entrance_exam->exam_status = 'Planned';
                                $student_entrance_exam->added_by = Yii::app()->user->id;
                                $student_entrance_exam->save(false);
                            }

                        }
                    }
                }
                UserMilestone::confirmMilestone($studentId, 3);
            }
        }

        $data['student'] = TblUserMaster::model()->findByPk($studentId);
        $data['departmentId'] = $departmentId;
        $this->render('milestone3', $data);
    }

    /**
     * This action will return the university suggestion as per student department and country preferences.
     * @param string $term
     * @param int $department
     * @return outputs json encoded data
     */
    public function actionEntranceExamSuggest($term, $department){

        $exclude = isset($_GET['exclude']) ?$_GET['exclude'] : array();
        $results = EntranceExamApplicableDepartment::getEntranceExamSuggestionListForDepartment($term, 0, $department, 10, $exclude);
        // Form json to serve to autosuggest.

        echo  CJSON::encode($results);
    }

    public function actionGetVendors(){
         
        if(isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 'get-vendors'){
            $entranceExamId = $_REQUEST['entranceExamId'];
            $cityId = $_REQUEST['city'];

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $partnerVendors = Vendor::getVendorsForEntranceExamInCity($entranceExamId, $cityId, true);
            $vendors =        Vendor::getVendorsForEntranceExamInCity($entranceExamId, $cityId, false);

            $ajaxOp['html'] =  $this->renderPartial('_vendorList', array('vendors' => $partnerVendors, 'cityId' => $cityId, 'entranceExamId' => $entranceExamId, 'partner' => true), true);

            $ajaxOp['html'] .= $this->renderPartial('_vendorList', array('vendors' => $vendors, 'cityId' => $cityId, 'entranceExamId' => $entranceExamId, 'partner' => false), true);

            echo CJSON::encode($ajaxOp);

        }
    }

    public function actionRequestMilestoneChange(){
        $op['status'] = 'failed';
        if(isset($_POST['userId']) && isset($_POST['milestoneId'])){
            $student = TblUserMaster::model()->findByPk($_POST['userId']);
            $milestoneId = $_POST['milestoneId'];

            //send umail to advisor
            UmailHelper::sendMilestoneChangeRequest($student, $milestoneId);

            $op['status'] = 'success';
            $op['html'] = 'We have received your request and a advisor will contact you soon.';

        }
        echo CJSON::encode($op);
    }

    public function actionTest(){
        $subdomain = CommonUtils::getSubdomain();
        echo "<br />" . $subdomain;
        //UmailHelper::sendQuestion(355, 'Question 1');
        //UmailHelper::sendQuestion(1, 'Question 2');
        /*
         $userMilestone = UserMilestone::model()->findByAttributes(array(
         'user_ref_id' => Yii::app()->user->sub_id,
         'milestone_id' => 2,
         ));
         $userMilestone->invalidateMileStone4();
         //var_dump($userMilestone);
         */
        //$x = UserMilestone::isStudentWorkshopCompleted(355, 1);

        //$x = UserMilestone::areMs4ListsConfirmed(355);
        //var_dump($x);



    }

    /**
     * Controller to give city suggestion for auto complete
     * @param string $term
     * @return string, json string for auto complete
     */
    public function actionCitySuggest($term){
         
        $results = TblCityMaster::getSuggestionList($term);
         
        // Form json to serve to autosuggest.
        $op = array();
        foreach($results as $result){
            $val = empty($result->country->country_name)? $result->city_name : $result->city_name . ', ' . $result->country->country_name;
            $op[] = array(
            			'id' => $result->city_id,
            			'value' => $val,
            			'country'=> $result->country->country_name
            );
        }

        echo  CJSON::encode($op);
    }

    /**
     * Dashboard page for milestone 3
     */
    public function actionMs3Helper(){
        $studentId = @$_GET['studentId'];
        $student = TblUserMaster::model()->findByPk($studentId);
        if(empty($student)){
            throw new CHttpException(404, 'Invalid Student');
        }
        $data = array();

        // restructuring for display based on entrance exam.
        $studentChosenBranches = $student->studentEntranceExamVendorBranches();
        $entranceExams = array();
        foreach($studentChosenBranches as $entranceBranch){
            $entranceExams[$entranceBranch->entrance_exam_ref_id][] = $entranceBranch;
        }

        $data['entranceExams'] = $entranceExams;
        unset($studentChosenBranches);

        $data['student'] = $student;
        $this->render('ms3Helper', $data);
    }

    public function actionMilestone61(){

        $studentId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];
         
        $data = array();
        $student = TblUserMaster::model()->findByPk($studentId);
        $data['studentOutplacementSubdepartment'] = new StudentOutplacementSubdepartment;

        if(isset($_POST['StudentOutplacementSubdepartment'])){
            

            if($_POST['StudentOutplacementSubdepartment']['sub_dept_name'] == $_POST['title']['sub_dept_name'])    $_POST['StudentOutplacementSubdepartment']['sub_dept_name'] = null;
            $data['inputPost'] = $_POST;

            if($_POST['StudentOutplacementSubdepartment']['sub_dept_ref_id'] > 0)    $_POST['StudentOutplacementSubdepartment']['sub_dept_name'] = null;
            if(!empty($_POST['StudentOutplacementSubdepartment']['sub_dept_name']))    $_POST['StudentOutplacementSubdepartment']['sub_dept_ref_id'] = null;

            $valid = true;
            $uniCount = 0;


            // Delete existing records, if exists.
            StudentOutplacementSubdepartment::model()->deleteAllByAttributes(array('user_ref_id' => $studentId));
            $studentOutplacementSubdepartment = new StudentOutplacementSubdepartment();
            $studentOutplacementSubdepartment->attributes = $_POST['StudentOutplacementSubdepartment'];
            $studentOutplacementSubdepartment->user_ref_id = $studentId;
            $studentOutplacementSubdepartment->added_by = $studentId;



            $valid = $studentOutplacementSubdepartment->save();
            // Delete existing records, if exists.
            StudentOutplacementUniversity::model()->deleteAllByAttributes(array('user_ref_id' => $studentId));
            if(isset($_POST['StudentOutplacementUniversity'])){
            foreach($_POST['StudentOutplacementUniversity'] as $id => $university){
                if(empty($university['uni_ref_id']) && empty($university['uni_name'])){
                    continue;
                }
                $uniCount++;
                $studentOutplacementUniversity = new StudentOutplacementUniversity;
                $studentOutplacementUniversity->attributes = $university;
                $studentOutplacementUniversity->user_ref_id = $studentId;
                $studentOutplacementUniversity->uni_type = StudentOutplacementUniversity::TYPE_APPLIED;
                $valid = $studentOutplacementUniversity->save() && $valid;
            }
            }

            if($valid && $uniCount > 0){
                UserMilestone::confirmMilestone($studentId, 61);
                // redirect to ms62
            }else{
                // show error
                $data['studentOutplacementSubdepartment'] = $studentOutplacementSubdepartment;
                $data['universityError'] = $uniCount == 0 ? 'Please select atleast one university' : '';
                //$data['errors'] = $studentOutplacementUniversity->getErrors();
            }

        }
         
        $data['student'] = $student;
        $this->render('milestone61', $data);
    }

    public function actionMilestone62(){

        $studentId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];
         
        $data = array();
        $student = TblUserMaster::model()->findByPk($studentId);
        //var_dump($_POST);
        $uniCount = 0;
        if(isset($_POST['StudentOutplacementUniversity']) || isset($_POST['university-suggest'])){
            $saved = true;
            $inputStudentOutplacementUniversity = empty($_POST['StudentOutplacementUniversity']) ? array() : $_POST['StudentOutplacementUniversity'];

            foreach($inputStudentOutplacementUniversity as $id => $university){

                if(is_numeric($id))
                $studentOutplacementUniversity = StudentOutplacementUniversity::model()->findByPk($id);
                else
                $studentOutplacementUniversity = new StudentOutplacementUniversity;
                $studentOutplacementUniversity->attributes = $university;
                $studentOutplacementUniversity->user_ref_id = $studentId;
                $studentOutplacementUniversity->uni_type = StudentOutplacementUniversity::TYPE_RECEIVED_ADMISSION;
                $saved = $saved && $studentOutplacementUniversity->save();
                $uniCount++;
            }

            if($saved && $uniCount > 0){
                UserMilestone::confirmMilestone($studentId, 62);
                // redirect to ms62
            }else{
                // show error
                $data['universityError'] = $uniCount == 0 ? 'Please select atleast one university' : '';
            }

        }
         
        $data['student'] = $student;
        $this->render('milestone62', $data);
    }

    public function actionGetStudentDepartmentUniversities(){
        if(isset($_GET['ajax']) && $_GET['ajax'] == 'get-universities'){
            $studentId = $_GET['studentId'];
            $departmentId = $_GET['departmentId'];

            $student = TblUserMaster::model()->findByPk($studentId);
            $ajaxOp['status'] = 'success';

            $ajaxOp['html'] = $this->renderPartial('_ms61CollgeList', array(
    	        'student' => $student,
    	        'departmentId' => $departmentId,
                'existingDepartment' => true,
            ), true);
             
            echo CJSON::encode($ajaxOp);
            Yii::app()->end();

        }
    }

    /**
     * This action will return the department suggestion
     * @param string $term
     * @param int $student
     * @param int $department
     * @return outputs json encoded data
     */
    public function actionDepartmentSuggest($term){
        $results = LookupDepartment::getSuggestionList($term);

        // Form json to serve to autosuggest.
        $op = array();
        foreach($results as $result){
            $op[] = array(
    			'id' => $result->department_id,
    			'value' => $result->department_name,
            );
        }
        echo  CJSON::encode($op);
    }

    /**
     * This action will return the university suggestion as per department, if passed
     * @param string $term
     * @param int $department
     * @return outputs json encoded data
     */
    public function actionUniversitySuggest($term, $department = 0){

        $results = TblUniversityMaster::getSuggestionList($term, $department, 10);

        // Form json to serve to autosuggest.
        $op = array();
        foreach($results as $result){
            $op[] = array(
            			'id' => $result->uni_id,
            			'value' => $result->uni_name,
                        'url' => $result->website_url,
            );
        }

        echo  CJSON::encode($op);
    }

    public function actionApplyingUniversity(){
        if(isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 'apply-university'){
            $collegeId = $_REQUEST['list'];
            $action = $_REQUEST['action'] == 'applying' ? StudentIdealListCollege::APPLYING: StudentIdealListCollege::NOT_APPLYING;

            $ajaxOp = array();
            $ajaxOp['status'] = 'success';

            $studentIdealListCollege = StudentIdealListCollege::model()->findByPk($collegeId);
            if(is_null($studentIdealListCollege)){
                throw new CHttpException(404,'The specified student list college cannot be found.');
            }
            $studentIdealListCollege->is_applying = $action;
            $bl = $studentIdealListCollege->save();

            $studentIdealListCollege->refresh();
            if($bl){
                $studentIdealList = StudentIdealList::model()->findByPk($studentIdealListCollege->student_ideal_list_ref_id);
                $ajaxOp['html'] = $this->renderPartial('_ms5CollegeRow', array(
                    'university' => $studentIdealListCollege,
                    'idealType' => $studentIdealList->type,
                ), true, true);
                $ajaxOp['enableSubmit'] = true;

            }else{
                $ajaxOp['status'] = 'failed';
                $ajaxOp['error'] = array_values($studentIdealListCollege->getErrors());
            }

            echo CJSON::encode($ajaxOp);
            Yii::app()->end();

        }
    }

    public function actionMs5Helper(){

        $studentId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];
        $type = empty($_GET['type']) ? StudentIdealList::TYPE_ASPIRATIONAL : $_GET['type'];
        if(empty($_GET['departmentId'])){
            $result = StudentPreferredDepartment::model()->findByAttributes(array('user_ref_id' => $studentId));
            if($result){
                $departmentId = $result->sub_dept_ref_id;
            }else{
                throw new CHttpException(404, 'Found no courses');
            }
        }else{
            $departmentId = $_GET['departmentId'];
        }
        $studentIdealList = StudentIdealList::getRecord($studentId, $departmentId, $type);
        $data['studentIdealList'] = $studentIdealList;
        $data['idealType'] = $type;
        $data['departmentId'] = $departmentId;
        $data['student'] = TblUserMaster::model()->findByPk($studentId);
        $this->render('ms5Helper', $data);

    }

    public function actionMilestone63(){

        $studentId = empty($_GET['studentId'])?Yii::app()->user->sub_id:$_GET['studentId'];
         
        $data = array();
        $student = TblUserMaster::model()->findByPk($studentId);
        $data['model'] = new StudentOutplacementUniversity;

        if(isset($_POST['StudentOutplacementUniversity'])){
            $data['inputPost'] = $_POST;
            

            // Update existing records to received admission.
            StudentOutplacementUniversity::model()->updateAll(array(
                'uni_type' => StudentOutplacementUniversity::TYPE_RECEIVED_ADMISSION,
            ),
                'user_ref_id = :user_id and uni_type = :uni_type',
            array(
                    ':user_id' => $student->user_id,
                    ':uni_type' => StudentOutplacementUniversity::TYPE_JOINED
            )
            );

            if($_POST['StudentOutplacementUniversity']['student_outplacement_university_id'] > 0){
                $studentOutplacementUniversity = StudentOutplacementUniversity::model()->findByPk($_POST['StudentOutplacementUniversity']['student_outplacement_university_id']);
                unset($_POST['StudentOutplacementUniversity']['uni_ref_id']);
                unset($_POST['StudentOutplacementUniversity']['uni_name']);
            }else{
                $studentOutplacementUniversity = new StudentOutplacementUniversity();
            }
            $studentOutplacementUniversity->scenario = 'add-joined';
            $studentOutplacementUniversity->attributes = $_POST['StudentOutplacementUniversity'];
            $studentOutplacementUniversity->user_ref_id = $studentId;
            $studentOutplacementUniversity->uni_type = StudentOutplacementUniversity::TYPE_JOINED;
            //$studentOutplacementUniversity->has_loan = 1;
            $valid = $studentOutplacementUniversity->save();
            
            $data['model'] = $studentOutplacementUniversity;

            

            //$studentOutplacementUniversity->refresh();
            $scholarships = array();

            if(isset($_POST['StudentOutplacementUniversityScholarship']) && $studentOutplacementUniversity->has_scholarship == 1){

                foreach($_POST['StudentOutplacementUniversityScholarship'] as $id => $inputScholarship){
                    //ignore uncheced list.
                    if(empty($inputScholarship['scholarship_type_check'])){
                        $scholarship = new StudentOutplacementUniversityScholarship();
                        $scholarship->attributes = $inputScholarship;
                        $scholarships[$id] = $scholarship;
                        continue;
                    }
                    unset($inputScholarship['scholarship_type_check']);
                    if($id > 0){
                        $scholarship = StudentOutplacementUniversityScholarship::model()->findByPk($id);
                    }else{
                        $scholarship = new StudentOutplacementUniversityScholarship();
                    }


                    $scholarship->attributes = $inputScholarship;
                    $scholarship->added_by = $studentId;
                    if($valid){
                        $scholarship->student_outplacement_university_ref_id = $studentOutplacementUniversity->getPrimaryKey();
                        $valid = $scholarship->save() && $valid;
                        
                    }else{
                        $valid = $scholarship->validate() && $valid;
                    }
                    $scholarships[$id] = $scholarship;

                }
            }
            $data['scholarships'] = $scholarships;
            if(empty($studentOutplacementUniversity->has_scholarship)){
                // remove all scholarship records.
                StudentOutplacementUniversityScholarship::model()->deleteAllByAttributes(array(
                    'student_outplacement_university_ref_id' => $studentOutplacementUniversity->getPrimaryKey(),
                ));
            }


            if($valid){
                //re load
                UserMilestone::confirmMilestone($studentId, 63);
                UserMilestone::confirmMilestone($studentId, 6);
            }
        }
         
        $data['student'] = $student;
        $this->render('milestone63', $data);
    }

    /**
     * Dashboard page for milestone 61
     */
    public function actionMs61Helper(){
        $studentId = @$_GET['studentId'];
        $student = TblUserMaster::model()->findByPk($studentId);
        if(empty($student)){
            throw new CHttpException(404, 'Invalid Student');
        }
        $data = array();

        $data['student'] = $student;
        $this->render('ms61Helper', $data);
    }

    /**
     * Dashboard page for milestone 62
     */
    public function actionMs62Helper(){
        $studentId = @$_GET['studentId'];
        $student = TblUserMaster::model()->findByPk($studentId);
        if(empty($student)){
            throw new CHttpException(404, 'Invalid Student');
        }
        $data = array();

        $data['student'] = $student;
        $this->render('ms62Helper', $data);
    }

    /**
     * Dashboard page for milestone 62
     */
    public function actionMs63Helper(){
        $studentId = @$_GET['studentId'];
        $student = TblUserMaster::model()->findByPk($studentId);
        if(empty($student)){
            throw new CHttpException(404, 'Invalid Student');
        }
        $data = array();

        $data['student'] = $student;
        $this->render('ms63Helper', $data);
    }

    public function actionDeleteEntranceExam() {
        if (!empty($_POST) && ($_POST['ajax'] == 'remove-entrance-exam')) {
            $user_entrance_exam = UserEntranceExam::model()->findByPk($_POST['id']);
            $ajaxOp = array();
            if ($user_entrance_exam->delete()) {
                $ajaxOp['status'] = 'success';
            } else{
                $ajaxOp['status'] = 'failed';
            }
            echo CJSON::encode($ajaxOp);
        }
    }


}