<?php
class ScholarshipsearchController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */

    public $cacheTime = '0';
    public $userId, $loginRefId;
    public $activeMenuLink;

    public function init() {
        parent::init();
        Yii::app()->theme = 'new_grid_theme';


        //getting user information from session
        if (Yii::app()->session->itemAt('sUserUnivariety') != '') {
            $this->getUserSessionInfo();
        }

        if( Yii::app()->session->get('user_type_ref_id') == 2 ) {
            Yii::app()->theme = 'uni_avada';
            $this->layout = "//layouts/css_track_inner";
        }
        else{
            $this->layout = "//layouts/new_grid_inner";
        }
    }

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'rights', // perform access control for CRUD operations
        );
    }
    public function getUserSessionInfo()
    {
        $userSession = @unserialize(Yii::app()->session->get('sUserUnivariety'));
        $this->userId = $userSession['UserId'];
        $this->loginRefId = Yii::app()->session->get('loginID');
    }

    public function __unsetSession()
    {
        unset(Yii::app()->session['scholarshipIds']);
    }

    public function actionIndex() {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        $this->cacheTime = Yii::app()->params['scholarshipCacheTime'];
        $preview = Yii::app()->request->getParam('preview');
        if($preview){
            $this->cacheTime = 0;
        }
        $scholarshipId = Yii::app()->request->getParam('scholarshipId');
        $seoText = Yii::app()->request->getParam('seoText');

        $scholarshipUrldata = Scholarship::getScholarshipIdFromHash($scholarshipId);
        $url = UniversityHelper::getScholarshipUrl($scholarshipUrldata['scholarship_id']);
        $currenturl =  Yii::app()->request->url;
        $this->canonicalUrl = 'https://www.univariety.com'.$url;
        $seoTextScholarship = UniversityHelper::removeUrlJunkChar(html_entity_decode($scholarshipUrldata['scholarship_name'])); // replace special character 

        if ($scholarshipUrldata['scholarship_id'] == '') { // if scholarship not found
            throw new CHttpException(404, 'The specified scholarship cannot be found.');
        } elseif ($currenturl != $url) { // if slug name did not match then redirect on correct url
            //$url = UniversityHelper::getScholarshipUrl($scholarshipUrldata['scholarship_id']);
            $this->redirect($url);
        } elseif ($scholarshipUrldata['is_active'] == false || $scholarshipUrldata['is_active'] == null) { // if scholarship in inactive state   
            throw new CHttpException(404, 'The specified scholarship cannot be found.');
        }

        $pageTitle = $scholarshipUrldata['scholarship_name'];

        $this->pageTitle = Yii::app()->name .' - '.$pageTitle;
        $this->breadcrumbs=array(
            'Home'=>array('/home'),
            $scholarshipUrldata['scholarship_name'],
        );

        $this->render("index", array('scholarshipId' => $scholarshipUrldata['scholarship_id'], 'scholarshipName' => $scholarshipUrldata['scholarship_name']));
    }

    public function getUniversityName($uniId) {
        $name = TblUniversityMaster::model()->getUniversityName($uniId);
        return $name;
    }

    public function actionScholarshipRedirectUrl() {
        $scholarshipId = $_POST['scholarship_id'];
        $url = UniversityHelper::getScholarshipUrl($scholarshipId);
        echo $url;
    }

    public function actionGetList(){
        $res = array();

        if (isset($_GET['term'])) {
            $listdata = Scholarship::getScholarshipAutoCompleteList($_GET['term'], 10, '1');
            foreach ($listdata as $key => $value) {
                $res[] = array(
                    'id' => $value->scholarship_id,
                    'label' => html_entity_decode($value->scholarship_name),
                );
            }
        }

        echo CJSON::encode($res);
        Yii::app()->end();
    }

    public function actionSearch() {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->canonicalUrl = 'https://www.univariety.com/online-scholarship-search';
        $this->metaDesc = 'Online scholarship search website-scholarship for Indian & foreign students. Search from list of 1000+ prestigious scholarships matching your preferences!';
        $this->metaKeyword = 'Scholarship, scholarships, scholarship online, scholarship search, online scholarship search';
        $this->pageTitle = 'Scholarship Search Online-Scholarship for Indian/Foreign Students';

        unset(Yii::app()->session['s_gender']);
        unset(Yii::app()->session['s_cId']);
        $baseScriptUrl=Yii::app()->clientScript->getCoreScriptUrl();
        Yii::app()->clientScript->registerScriptFile($baseScriptUrl.'/jquery.ba-bbq.js',0);
        $pagerUrl=Yii::app()->getAssetManager()->publish(Yii::getPathOfAlias('system.web.widgets.pagers'));
        Yii::app()->clientScript->registerCssFile($pagerUrl.'/pager.css');

        $widgetsScriptUrl=Yii::app()->getAssetManager()->publish(Yii::getPathOfAlias('zii.widgets.assets'));
        Yii::app()->clientScript->registerCssFile($widgetsScriptUrl.'/listview/styles.css');
        Yii::app()->clientScript->registerScriptFile($widgetsScriptUrl.'/listview/jquery.yiilistview.js',0);


        $scholarshipModel = new Scholarship();
        $mainDepartmentsList = LookupDepartment::getMainDepartmentList();
        foreach($mainDepartmentsList as $dept_id=>$dept_name){
            $subDeptList = LookupDepartment::getSubDepartmentsPopularCourses($dept_id, $dept_name);
            $deptList[$dept_id]['name'] = $dept_name;
            $deptList[$dept_id]['sub_dept'] = $subDeptList['courses']['fullName'];
        }
        $sourceList = ScholarshipDestinationCountry::getScholarshipSourceCountryList();

        $destinationList = ScholarshipHostInstitute::getDestinationInstitute();

        $ethnicityList = LookupScholarshipTargetGroup::getEthnicityList();
        $method="";
        if (isset($_GET) && !empty($_GET)) {
            $params = array();
            $studyLevel = Yii::app()->request->getParam('study_level');
            if($studyLevel !=''){
                $params['study_level'] = $studyLevel;
            }
            $mainDept = Yii::app()->request->getParam('main_dept');
            if($mainDept !=''){
                $params['main_dept'] = $mainDept;
            }
            $providerType = Yii::app()->request->getParam('type');
            if($providerType !=''){
                $params['provider_type'] = $providerType;
            }
            $sourceInstitute = Yii::app()->request->getParam('source_institute');
            if($sourceInstitute !=''){
                $params['source_institute'] = $sourceInstitute;
            }
            $destinationInstitute = Yii::app()->request->getParam('destination_institute');
            if($destinationInstitute !=''){
                $params['destination_institute'] = $destinationInstitute;
            }
            $gender = Yii::app()->request->getParam('gender');
            if($gender !=''){
                $params['gender'] = $gender;
            }

            $university1 = Yii::app()->request->getParam('uni1');
            if ($university1 > 0) {
                $params['university']['1'] = $university1;
                $params['country']['1'] = TblUniversityMaster::getUniCountryName($university1);
            }
            $university2 = Yii::app()->request->getParam('uni2');
            if ($university2 > 0) {
                $params['university']['2'] = $university2;
                $params['country']['2'] = TblUniversityMaster::getUniCountryName($university2);
            }
            $university3 = Yii::app()->request->getParam('uni3');
            if ($university3 > 0) {
                $params['university']['3'] = $university3;
                $params['country']['3'] = TblUniversityMaster::getUniCountryName($university3);
            }
            if(count($params)){
                $method="get";
                if(count($params['university'])<1){
                    $params['university'] = array();
                }
                try {
                    $limit =5;
                    $offset = 0;
                    $limit = isset($_GET['limit']) ? $_GET['limit'] : $limit;
                    $offset = isset($_GET['offset']) ? $_GET['offset'] : $offset;
                    $gridData = Scholarship::model()->getScholarshipSearchList($params,true,$limit,$offset);
                    $gridDataTotal = Scholarship::model()->getScholarshipSearchList($params);
                }catch(Exception $e){
                    throw new CHttpException(404, 'The specified scholarship cannot be found.');
                }
            }
        }
        $sectionflag = Yii::app()->request->getParam('sectionFlag');

        if($sectionflag){
            $params = array();
            $params['type'] = Yii::app()->request->getParam('type');
            $params['countryId'] = Yii::app()->request->getParam('countryId');
            $limit =5;
            $offset = 0;
            $limit = isset($_GET['limit']) ? $_GET['limit'] : $limit;
            $offset = isset($_GET['offset']) ? $_GET['offset'] : $offset;
            $gridData = Scholarship::getScholarshipLists($params,$limit,$offset);
            $gridDataTotal = Scholarship::getScholarshipLists($params);
        }
        $modelData = new ChanceData('checkChances');
        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($modelData);
            Yii::app()->end();
        }
        $countryList = TblCountryMaster::getCountryList();
        $boardList = LookupBoardEquivalent::getBoardCategoryByClass(12,'',true);
        $this->breadcrumbs=array(
            'Home'=>array('/home'),
            'Scholarship Search',
        );

        $this->render("search", array('scholarshipModel' => $scholarshipModel, 'mainDepartmentsList' => $deptList, 'sourceList' => $sourceList, 'destinationList' => $destinationList,'ethnicityList'=>$ethnicityList,'gridData'=>$gridData,'params'=>$params,'method'=>$method,'gridDataTotal'=>$gridDataTotal,'sectionFlag'=>$sectionflag,'model'=>$modelData, 'countryList' => $countryList,'boards'=>$boardList));
    }

    public function actionGetChildMajor() {
        $deptId = Yii::app()->request->getParam('id');
        $returnArray = LookupDepartment::getSubDepartmentsPopularCourses($deptId);
        $this->renderPartial("_childmajor", array('childMajorArray' => $returnArray));
    }

    public function actionScholarshipCount() {
        $paramString = Yii::app()->request->getPost('js');
        $buttonName = Yii::app()->request->getPost('click');
        parse_str($paramString, $params);
        if ($params['main_dept'] != '') {
            $mainDeptName = LookupDepartment::model()->getDepartmentDetailsById($params['main_dept'], array('department_name'));
            $mainDeptName = $mainDeptName->department_name;
        }if ($params['sub_dept'] != '') {
            $subDeptName = LookupDepartment::model()->getDepartmentDetailsById($params['sub_dept'], array('department_name'));
            $subDeptName = $subDeptName->department_name;
        }
        if ($buttonName == 'study_level') {
            $newParams['study_level'] = $params['study_level'];
            $studyCount = Scholarship::model()->getScholarshipCount($newParams);
            $msg = $this->getMsgText($newParams, $studyCount, $mainDeptName, $subDeptName);
            $count['studyCount'] = '<label style="color:blue;"><b><i><u>' . $msg . '</u></i></b></label>';
        } elseif ($buttonName == 'main_dept' || $buttonName == 'sub_dept' || $buttonName == 'source_institute') {
            $newParams['study_level'] = $params['study_level'];
            $newParams['main_dept'] = $params['main_dept'];
            $newParams['sub_dept'] = $params['sub_dept'];
            $newParams['source_institute'] = $params['source_institute'];
            if ($params['source_institute'] != '') {
                $originCount = Scholarship::model()->getScholarshipCount($newParams);
                $msg = $this->getMsgText($newParams, $originCount, $mainDeptName, $subDeptName);
                $count['originCount'] = '<label style="color:blue;"><b><i><u>' . $msg . '</u></i></b></label>';
            }if ($params['destination_institute'] != '') {
                $newParams['destination_institute'] = $params['destination_institute'];
                $destCount = Scholarship::model()->getScholarshipCount($newParams);
                $msg = $this->getMsgText($newParams, $destCount, $mainDeptName, $subDeptName);
                $count['destCount'] = '<label style="color:blue;"><b><i><u>' . $msg . '</u></i></b></label>';
            }if ($params['gender'] != '') {
                $newParams['destination_institute'] = $params['destination_institute'];
                $newParams['gender'] = $params['gender'];
                $genderCount = Scholarship::model()->getScholarshipCount($newParams);
                $msg = $this->getMsgText($newParams, $genderCount, $mainDeptName, $subDeptName);
                $count['genderCount'] = '<label style="color:blue;"><b><i><u>' . $msg . '</u></i></b></label>';
            }
        } elseif ($buttonName == 'destination_institute') {
            $newParams['study_level'] = $params['study_level'];
            $newParams['main_dept'] = $params['main_dept'];
            $newParams['sub_dept'] = $params['sub_dept'];
            $newParams['source_institute'] = $params['source_institute'];
            $newParams['destination_institute'] = $params['destination_institute'];
            $destCount = Scholarship::model()->getScholarshipCount($newParams);
            $msg = $this->getMsgText($newParams, $destCount, $mainDeptName, $subDeptName);
            $count['destCount'] = '<label style="color:blue;"><b><i><u>' . $msg . '</u></i></b></label>';
            if ($params['gender'] != '') {
                $newParams['gender'] = $params['gender'];
                $genderCount = Scholarship::model()->getScholarshipCount($newParams);
                $msg = $this->getMsgText($newParams, $genderCount, $mainDeptName, $subDeptName);
                $count['genderCount'] = '<label style="color:blue;"><b><i><u>' . $msg . '</u></i></b></label>';
            }
        } elseif ($buttonName == 'gender') {
            $newParams = $params;
            $genderCount = Scholarship::model()->getScholarshipCount($newParams);
            $msg = $this->getMsgText($newParams, $genderCount, $mainDeptName, $subDeptName);
            $count['genderCount'] = '<label style="color:blue;"><b><i><u>' . $msg . '</u></i></b></label>';
        }
        echo json_encode($count);
        // echo '<label style="color:blue;"><b><i><u>' . $count . ' Scholarships Found</u></i></b></label>';
    }

    public function getMsgText($newParams, $count, $mainDeptName, $subDeptName) {
        $msg = ' found';
        if ($newParams['study_level'] != '') {
            if ($newParams['study_level'] == 6) {
                $name = 'UG';
            } else {
                $name = 'PG';
            }
        }
        if ($newParams['gender'] != '') {
            $msg = ' for ' . $newParams['gender'] . $msg;
        }
        if ($newParams['sub_dept'] != '') {
            $tmpText = ' for ' . $subDeptName;
            $msg = $tmpText . $msg;
        }
        if ($newParams['main_dept'] != '') {
            $tmpText = ' in ' . $mainDeptName;
            $msg = $tmpText . $msg;
        }
        if ($newParams['study_level'] != '') {
            if ($count > 0) {
                $msg = $name . ' Scholarships ' . $msg;
            } else {
                $msg = $name . ' Scholarships ' . $msg;
            }
        } else {
            if ($count > 0) {
                $msg = 'Scholarships ' . $msg;
            } else {
                $msg = 'Scholarship ' . $msg;
            }
        }
        if ($count > 0) {
            $msg = $count . ' ' . $msg;
        } else {
            $msg = 'No ' . $msg;
        }
        return $msg;
    }

    public function actionAddUniversity() {
        if (isset($_POST) && !empty($_POST)) {
            $data = array();
            $data['study_level'] = Yii::app()->request->getPost('study_level');
            $data['main_dept'] = Yii::app()->request->getPost('main_dept');
            $data['sub_dept'] = Yii::app()->request->getPost('sub_dept');
            $data['source_institute'] = Yii::app()->request->getPost('source_institute');
            $data['destination_institute'] = Yii::app()->request->getPost('destination_institute');
            $data['gender'] = Yii::app()->request->getPost('gender');
            $universityList = TblUniversityMaster::model()->getUniversityNameList();
            foreach ($universityList as $key => $value) {
                $universityListArray[] = array(
                    'id' => $key,
                    'label' => $value,
                );
            }

            $this->render('university_search', array('universityList' => $universityListArray, 'data' => $data));
        } else {
            $this->redirect(Yii::app()->createUrl('/../online-scholarship-search'));
        }
    }

    public function actionSearchResult() {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        if (isset($_GET) && !empty($_GET)) {
            $params = array();
            $params['ScholarshipSort'] = Yii::app()->request->getParam('Scholarship_sort');

            $studyLevel = Yii::app()->request->getParam('study_level');
            if($studyLevel !=''){
                $params['study_level'] = $studyLevel;
            }
            $mainDept = Yii::app()->request->getParam('main_dept');
            if($mainDept !=''){
                $params['main_dept'] = $mainDept;
            }
            $sourceInstitute = Yii::app()->request->getParam('source_institute');
            if($sourceInstitute !=''){
                $params['source_institute'] = $sourceInstitute;
            }
            $destinationInstitute = Yii::app()->request->getParam('destination_institute');
            if($destinationInstitute !=''){
                $params['destination_institute'] = $destinationInstitute;
            }
            $gender = Yii::app()->request->getParam('gender');
            if($gender !=''){
                $params['gender'] = $gender;
            }
//            $ethnicity = Yii::app()->request->getParam('ethnicity');
//            if($ethnicity !=''){
//                $params['ethnicity'] = $ethnicity;
//            }
            $university1 = Yii::app()->request->getParam('uni1');
            if ($university1 > 0) {
                $params['university']['1'] = $university1;
                $params['country']['1'] = TblUniversityMaster::getUniCountryName($university1);
            }
            $university2 = Yii::app()->request->getParam('uni2');
            if ($university2 > 0) {
                $params['university']['2'] = $university2;
                $params['country']['2'] = TblUniversityMaster::getUniCountryName($university2);
            }
            $university3 = Yii::app()->request->getParam('uni3');
            if ($university3 > 0) {
                $params['university']['3'] = $university3;
                $params['country']['3'] = TblUniversityMaster::getUniCountryName($university3);
            }
            //$gridData = array();
            if(count($params) && !$_GET['sectionFlag']){
                if(count($params['university'])<1){
                    $params['university'] = array();

                }
                try {
                    $limit =5;
                    $offset = 0;
                    $limit = isset($_GET['limit']) ? $_GET['limit'] : $limit;
                    $offset = isset($_GET['offset']) ? $_GET['offset'] : $offset;
                    $gridData = Scholarship::model()->getScholarshipSearchList($params,true,$limit,$offset);
                    $gridDataTotal = Scholarship::model()->getScholarshipSearchList($params);
                    //$gridData = Scholarship::model()->getScholarshipSearchList($params);
                }catch(Exception $e){
                    throw new CHttpException(404, 'The specified scholarship cannot be found.');
                }
            }

            $modelData = new ChanceData('checkChances');
            if (isset($_POST['ajax'])) {
                echo CActiveForm::validate($modelData);
                Yii::app()->end();
            }
            $countryList = TblCountryMaster::getCountryList();
            /*$boardLookup12 = LookupBoardEquivalent::GetSchoolBoardList('12');
            $boardList = CHtml::listData($boardLookup12, 'board_equivalent_id', 'board_desc');*/
            $boardList = LookupBoardEquivalent::getBoardCategoryByClass('12','',true);
            // $this->renderPartial('_searchResultView', array('gridData' => $gridData, 'params' => $params));
            /*if( !Yii::app()->user->isGuest && Yii::app()->user->user_type_ref_id == 2 && Yii::app()->user->sub_id != '' ) { // for css login check
                $this->renderPartial('css/_searchResultView', array('gridData' => $gridData, 'params' => $params));
            } else {*/
            // $sectionflag = Yii::app()->request->getParam('sectionFlag');
            if($_GET['sectionFlag']){

                $params = array();
                $params['type'] = Yii::app()->request->getParam('type');
                $params['countryId'] = Yii::app()->request->getParam('countryId');
                $limit =5;
                $offset = 0;
                $limit = isset($_GET['limit']) ? $_GET['limit'] : $limit;
                $offset = isset($_GET['offset']) ? $_GET['offset'] : $offset;
                $gridData = Scholarship::getScholarshipLists($params,$limit,$offset);
                $gridDataTotal = Scholarship::getScholarshipLists($params);

                $modelData = new ChanceData('checkChances');
                // var_dump($modelData);exit;
                if (isset($_POST['ajax'])) {
                    echo CActiveForm::validate($modelData);
                    Yii::app()->end();
                }
                $countryList = TblCountryMaster::getCountryList();
                /*$boardLookup12 = LookupBoardEquivalent::GetSchoolBoardList('12');
                $boardList = CHtml::listData($boardLookup12, 'board_equivalent_id', 'board_desc');*/
                $boardList = LookupBoardEquivalent::getBoardCategoryByClass('12','',true);
            }

            if(isset($_GET['limit'])){
                $this->renderPartial('_searchResultPartialView', array('gridData' => $gridData, 'params' => $params,'gridDataTotal'=>$gridDataTotal));
            }
            else{
                $this->renderPartial('_searchResultView', array('gridData' => $gridData, 'params' => $params,'gridDataTotal'=>$gridDataTotal,'model'=>$modelData,'countryList' => $countryList,'boards'=>$boardList));
            }

            //}

        } else {
            $this->redirect(Yii::app()->createUrl('/../online-scholarship-search'));
        }
    }


    public function actionUniversityList(){
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $scholarshipId = Yii::app()->request->getParam('id');
        $data = array();
        $data = Scholarship::getApplicableUniversityList($scholarshipId);

        $objShortList = new ShortListEngine();
        $shortListCollege = $objShortList->getShortList();
        /*if( !Yii::app()->user->isGuest && Yii::app()->user->user_type_ref_id == 2 && Yii::app()->user->sub_id != '' ) { // for css login check
            $this->renderPartial('css/_getUniversitylist', array('data' => $data, 'scholarshipId' => $scholarshipId, 'shortList' => $shortListCollege));
        } else {*/
        $this->renderPartial('_getUniversitylist', array('data' => $data, 'scholarshipId' => $scholarshipId, 'shortList' => $shortListCollege));
        //}
    }

    public function actionError() {
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'add-university') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }
    public function actionAddUserScholarship()
    {
        $scholarshipId  = $_POST['scholarshipId'];
        $userRefId      = $_POST['userRefId'];
        $loginRefId     = $_POST['loginRefId'];

        UserScholarship::addUserScholarshipList($userRefId,$scholarshipId,$loginRefId);
        echo "success";
    }
    public function actionDeleteUserScholarship()
    {
        $scholarshipId  = $_POST['scholarshipId'];
        $userRefId      = $_POST['userRefId'];
        $loginRefId     = $_POST['loginRefId'];

        UserScholarship::deleteUserScholarshipList($userRefId,$scholarshipId,$loginRefId);
        echo "success";
    }
    public function actionAddUserScholarshipToSessions()
    {
        //$myIDs = preg_replace("/(^$removeID,|,$removeID$|,$removeID(?=,))/", '', $myIDs);
        $scholarshipIds = $_POST['scholarshipId'];

        Yii::app()->session['scholarshipIds'] .= ','.$scholarshipIds;


        if(!empty($_POST['removedScholarshipId']))
        {
            $removeID = $_POST['removedScholarshipId'];
            Yii::app()->session['scholarshipIds'] = preg_replace("/(^$removeID,|,$removeID$|,$removeID(?=,))/", '', Yii::app()->session['scholarshipIds']);
            Yii::app()->session['scholarshipIds'] = substr(Yii::app()->session['scholarshipIds'],0,-1);
        }
        if (substr(Yii::app()->session['scholarshipIds'],0,1) == ",")
        {
            Yii::app()->session['scholarshipIds'] = substr(Yii::app()->session['scholarshipIds'], 1);
        }

        print_r(Yii::app()->session['scholarshipIds']);
    }

    public function actionScholarshipList($userId) {
        if ($userId) {
            $result = UserScholarship::userAllScholarshipList($userId, $scholarshipIds = '');
        } else if (!empty(Yii::app()->session['scholarshipIds'])) {
            $sessionResult = Scholarship::getScholarshipSearchLists($userId = '', Yii::app()->session['scholarshipIds']);
        }

        $this->renderPartial('scholarshipList', array('result' => $result, 'sessionResult' => $sessionResult));
    }

    public function actionMain() {
        $this->pageTitle = Yii::app()->name . ' - Scholarships';
        $this->render('scholarshipMain');
    }

    public function actionAddToShortList() {

        $uniId = Yii::app()->request->getParam('uniId');
        $status = Yii::app()->request->getParam('status');
        if(is_numeric($status)) {
            $status = $status ? "MightApply" : "Reject";
        }

        $obj = new ShortListEngine();
        $obj->saveToShortList($uniId, $status);
    }

    public function actionAjaxRedirecting() {
        $scholarshipId = Yii::app()->request->getParam('scholarship_id');
        $hashed = Yii::app()->request->getParam('hashed') ? Yii::app()->request->getParam('hashed') : 0;
        echo UniversityHelper::getScholarshipUrl($scholarshipId, $hashed);
    }

    public function actionRedirecting() {
        $scholarshipId = Yii::app()->request->getParam('scholarship_id');
        $hashed = Yii::app()->request->getParam('hashed') ? Yii::app()->request->getParam('hashed') : 0;
        $this->redirect(UniversityHelper::getScholarshipUrl($scholarshipId, $hashed));
    }
    public function actionAddUserScholarshipGetMethod()
    {
        $scholarshipId  = $_GET['scholarshipId'];
        $userRefId      = $_GET['userRefId'];
        $loginRefId     = $_GET['loginRefId'];

        UserScholarship::addUserScholarshipList($userRefId,$scholarshipId,$loginRefId);
        echo "success";
    }
    public function actionDeleteUserScholarshipGetMethod()
    {
        $scholarshipId  = $_GET['scholarshipId'];
        $userRefId      = $_GET['userRefId'];
        $loginRefId     = $_GET['loginRefId'];

        UserScholarship::deleteUserScholarshipList($userRefId,$scholarshipId,$loginRefId);
        echo "success";
    }
    public function actionAddUserScholarshipToSessionsGetMethod()
    {
        $scholarshipIds = $_GET['scholarshipId'];
        Yii::app()->session['scholarshipIds'] .= ','.$scholarshipIds;


        if(!empty($_GET['removedScholarshipId']))
        {
            $removeID = $_GET['removedScholarshipId'];
            Yii::app()->session['scholarshipIds'] = preg_replace("/(^$removeID,|,$removeID$|,$removeID(?=,))/", '', Yii::app()->session['scholarshipIds']);
        }
        if (substr(Yii::app()->session['scholarshipIds'],0,1) == ",")
        {
            Yii::app()->session['scholarshipIds'] = substr(Yii::app()->session['scholarshipIds'], 1);
        }

        print_r(Yii::app()->session['scholarshipIds']);
    }

    public function actionAllScholarship()
    {
        $criteria = Scholarship::getAllScholarships();
        $dataProvider = new CActiveDataProvider('Scholarship',array('criteria' => $criteria ,'pagination'=>array('pageSize'=>40)));
        $this->render('listScholarships', compact('dataProvider'));
    }

    public function actionConvertToXml()
    {
        $criteria = Scholarship::getAllScholarships();
        $data = Scholarship::model()->findAll($criteria);

        $xml = new SimpleXMLElement('<xml/>');
        foreach($data as $val){
            $link = UniversityHelper::getScholarshipUrl($val->scholarship_id);

            $link = 'https://www.univariety.com'.$link;
            //$link = $val['seo_url'];
            $url = $xml->addChild('url');
            $url->addChild('loc',"$link");
        }
        Header('Content-type: text/xml');
        print($xml->asXML());
        exit;
    }

    public function actionUniqueSearch() {
        $res = array();

        if (isset($_GET['term'])) {
            $listdata = TblUniversityMaster::getUniversityListAuto2($_GET['term'], 10, 'Y');
            foreach ($listdata as $key => $value) {
                if ($value->uni_id != $_GET['uni1'] && $value->uni_id != $_GET['uni2']) {
                    $res[] = array(
                        'id' => $value->uni_id,
                        'label' => html_entity_decode($value->uni_name),
                        'category' => 'College',
                    );
                }
            }
        }

        echo CJSON::encode($res);
        Yii::app()->end();
    }
}
