<?php

function moneyFormatIndia($num){
    $explrestunits = "" ;
    if(strlen($num)>3){
        $lastthree = substr($num, strlen($num)-3, strlen($num));
        $restunits = substr($num, 0, strlen($num)-3); // extracts the last three digits
        $restunits = (strlen($restunits)%2 == 1)?"0".$restunits:$restunits; // explodes the remaining digits in 2's formats, adds a zero in the beginning to maintain the 2's grouping.
        $expunit = str_split($restunits, 2);
        for($i=0; $i<sizeof($expunit); $i++){
            // creates each of the 2's group and adds a comma to the end
            if($i==0)
            {
                $explrestunits .= (int)$expunit[$i].","; // if is first value , convert into integer
            }else{
                $explrestunits .= $expunit[$i].",";
            }
        }
        $thecash = $explrestunits.$lastthree;
    } else {
        $thecash = $num;
    }
    return $thecash; // writes the final format where $currency is the currency symbol.
}


$international_tests_count = count($inter_national_tests);
if($international_tests_count == 0){ ?>
    <div class="row multi_line gutter-verticle-auto center ">
        <h4 class="normal gutter_vertical">No tests applicable for this country and department.<br>
            We suggest that you look at the top colleges to get your admission chances.</h4>
        <a href="<?php echo $this->createUrl('/college/search/GetTopPopularCollege',array('countryId' => $country,'departmentId'=>$dept )); ?>" target="_blank"><button class="button-green tny ">Find Top Colleges</button></a>

    </div>
<?php }
$show_conflict = false;
$completeTestList = CHtml::listData($inter_national_tests,'entrance_id','entrance_short_name');
?>

<div class="row multi_line border-bottom" id="div3">
    <h4 id="count" class="left" style="margin-top: 7px !important;">
        <?php $count = count($national_tests)+count($state_tests)+count($institute_tests);

        if($count > 1){
            echo $count."  Tests found";
        }else{
            echo $count." Test found";
        }?></h4>

    <div class="right ms_pd" id="modify">
        <a href="javascript:void(0)">Modify Search</a>
    </div>
</div>

<?php if($international_tests_count){?>


    <div class="row gutter_vertical" style="overflow: hidden;">
        <div class="row gutter_vertical gray desktop">
            <div class="grid_7 pull gutter-left-35" style="text-align: center"><small>Test Name</small></div>
            <div class="grid_3 pull center" style="text-align: center"><small>Coaching Required</small></div>
            <div class="grid_2 pull center" style="text-align: center"><small>Students Appeared</small></div>
        </div>
        <?php foreach($inter_national_tests as $test): ?>

            <?php  $topCollege1 = TopPopularCollege::getTopCollegeByEntranceTest($test['entrance_id'],0,1000);
            $BooksData = EntranceExamPreparation::getmediaData($test['entrance_id'],'Book'); ?>
            <div class="row multi_line gutter_vertical border-top relative visible clearfix new_mh <?php echo ((count($topCollege1)) && (count($BooksData)))?'hover':''?>">
                <div class="heading grid_6 resp_rwd fln_cr pull">
                    <div class="gutter_vertical small_gutter_l">
                        <h4 class="test_mr"><!--<a title="<?php /*echo $test['entrance_short_name'];*/?>"  href="<?php /*echo $test_url = UniversityHelper::getTestUrl($test['entrance_id']);*/?>" target="_blank">-->
                                <?php if($test['entrance_short_name']== $test['entrance_full_name'] ){
                                    echo $test['entrance_full_name'];
                                }else{
                                    echo $test['entrance_short_name'].' - '.$test['entrance_full_name'];
                                }?>
                                <!--</a>--></h4>
                        <span class="lightgray">
                            <?php if( $test['category']=="NA")
                            {
                                echo $test['category'];
                            }else {
                                echo $test['category']." test";
                            }
                            ?> </span>
                        <a href="javascript:void(0)">
                            <?php
                            if($test['entrance_short_name'] == 'IELTS' || $test['entrance_short_name'] == 'TOEFL'){
                                if(in_array('IELTS',$completeTestList) && in_array('TOEFL',$completeTestList)){
                                    ?>
                                    <span class=" missedContent hover-bubble relative">
                            <i class="fa fa-question-circle small_gutter_r medium-icon color-pink"></i>
                            <div class="popup">
                                <div class="holder">
                                    <p><small>You need to take either IELTS or TOEFL </small></p>
                                </div>
                            </div>
                        </span>

                                    <?php
                                    unset($completeTestList[array_search('IELTS',$completeTestList)]);
                                    unset($completeTestList[array_search('TOEFL',$completeTestList)]);
                                }
                            }
                            ?>
                            <?php if($test['entrance_short_name'] == 'ACT' || $test['entrance_short_name'] == 'SAT'){
                                if(in_array('ACT',$completeTestList) && in_array('SAT',$completeTestList)){?>
                                    <span class=" missedContent hover-bubble relative">
                            <i class="fa fa-question-circle small_gutter_r medium-icon color-pink"></i>
                            <div class="popup">
                                <div class="holder">
                                    <p><small>You need to take either SAT or ACT </small></p>
                                </div>
                            </div>
                        </span>
                                    <?php
                                    unset($completeTestList[array_search('ACT',$completeTestList)]);
                                    unset($completeTestList[array_search('SAT',$completeTestList)]);
                                }
                            }
                            ?></a>
                    </div>
                </div>
                <div class="right resp_rwd fln_cr">
                    <div class="grid_2 pull center">
                        <?php
                        $coaching = $test['coaching_required1'];
                        if(!$coaching){?>
                           <span class="mobile">Coaching Required : </span><small>Not Available</small>
                        <?php } else{
                            echo '<span class="mobile">Coaching Required : </span>'.ucfirst(strtolower($test['coaching_required1']));
                        }
                        ?>
                    </div>
                    <div class="grid_2 right center">
                        <?php $appeared = $test['students_appeared_last_year'];
                        if(!$appeared){?>
                            <span class="mobile">Students Appeared : </span><small>Not Available</small>
                        <?php }else{
                            $amount = moneyFormatIndia($appeared);
                            echo '<span class="mobile">Students Appeared : </span>' .$amount;
                        }?>
                    </div>
                </div>

                <div class="hidden_new right visible multi_line row no-clear small-gutter absolute white no-border grid_5 center new_pst2">
                    <?php $topCollege1 = TopPopularCollege::getTopCollegeByEntranceTest($test['entrance_id'],0,1000);
                    $collegeCount = count($topCollege1);
                    if($collegeCount){?>
                        <a href="<?php echo $this->createUrl('getTopCollege',array('testId' => $test['entrance_id'])); ?>" target="_blank"><button class="button-blue tny small_gutter_r ">View Colleges</button></a>
                    <?php  } ?>
                    <?php $BooksData = EntranceExamPreparation::getmediaData($test['entrance_id'],'Book');
                    $bookCount =count($BooksData);
                    if($bookCount > 0){?>
                        <a href="<?php echo $test_url = UniversityHelper::getTestUrl($test['entrance_id']);?>#books" target="_blank">
                            <button class="button-green tny small_mr">Books</button></a>
                    <?php } ?>
                </div>
                <div id="tag-<?php echo $test['entrance_id']; ?>">
                    <?php if($loginFlag || Yii::app()->user->isGuest){
                        if(in_array( $test['entrance_id'], $testListId) ){ ?>
                            <div class="tag-image addedtag missedContent" onclick="removeFromShortList(<?php echo  $test['entrance_id']; ?>)">&nbsp;
                                <div class="popup" style="display: none;">
                                    <div class="holder">
                                        <p>Remove from Shortlist</p>
                                    </div>
                                </div>
                            </div>
                        <?php }else{ ?>
                            <div class="tag-image addtag missedContent" onclick="addToTestShortList(<?php echo $test['entrance_id']; ?>)">&nbsp;
                                <div class="popup" style="display: none;">
                                    <div class="holder">
                                        <p>Add to Shortlist</p>
                                    </div>
                                </div>
                            </div>
                        <?php } } ?>
                </div>
            </div>
        <?php endforeach ;?>
    </div>
<?php } ?>

<script>

    $(function(){
        var newCount = <?php echo (count($inter_national_tests));?>;

        if(parseInt(newCount) < 2){

            $("#count").html(newCount+ " Test found");
        }else{
            $("#count").html(newCount+ " Tests found");
        }


        if(parseInt(newCount)== 0){
            $("#div3").hide();
            $("#div4").hide();
            $("#last").hide();
            return false;
        }else{
            $("#div3").show();
            $("#view1").show();
            $("#last").show();
        }
    })


    $('#newSearch').click(function(){
        $('#div1').show();
        $('#div2').show();
        $('#last').hide();
        $('#new').hide();
        $('#cancel').hide();

    });

    $('#modify').click(function(){
        $('#div2').show();
        $('#modify').hide();
        $('#cancel').show();
        $('#last').hide();
    });

    $('#cancel').click(function(){
        $('#div2').hide();
        $('#modify').show();
        $('#last').show();


    })





</script>


