<?php

class ToolsController extends Controller
{


    public $currentStudyLevelArray = array(
        '11p' => '11th',
        '12p' => '12th',
        '12c' => '12th Completed',
    );
    public $current_class;
    public $loginRefId;

    public $internationalTests = array();
    public $nationalTests = array();
    public $stateTests = array();
    public $collegeTests = array();
    public $entranceExamDetails = array();
    public $interests = array();
    public $interestsMapping = array();
    public $interestsMappingDepartments = array();

    public function init()
    {
        parent::init();
        Yii::app()->theme = 'uni_avada';
        $this->layout = "//layouts/inner_page";

        if(Yii::app()->request->isAjaxRequest) return;
        Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/css/colorbox.css");
        Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl ."/js/jquery.colorbox.js");
    }

    public function actionIndex()
    {
        $this->breadcrumbs=array(
            'Home'=>array('/home'),
            'Online Counsellor',
        );

        $this->setPageTitle(Yii::app()->name.' - Online Counselling Tools');
        $this->render('landing_page');
    }


    public function actionCountryspecifictest()
    {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        $this->setPageTitle(Yii::app()->name . ' - CountrySpecificTest');
        
       $this->render('landing_page');
    }
    
    
	
	//To get departments based on the selected country.
	public function actiongetDeptList()
	{
		$dataOptions=array();
		try{
					
			$country_id=Yii::app()->request->getparam('country',0);
			$sql='SELECT department_id,department_name
                        FROM `entrance_exam_ranking` eer
                        LEFT JOIN entrance_exam ee ON ee.entrance_id = eer.entrance_exam_ref_id
                        LEFT JOIN entrance_exam_ranking_department eerd ON eerd.entrance_exam_ranking_ref_id = eer.entrance_exam_ranking_id
                        LEFT JOIN lookup_department ld ON ld.department_id = eerd.main_department_ref_id
                        WHERE eer.country_ref_id='.$country_id.' GROUP BY department_id';
			
			$dept_list=Yii::app()->db->createCommand($sql)->queryAll();
			echo CHtml::tag('option',
                    array('value'=>0), CHtml::encode("Choose a Major"),true);
			foreach($dept_list as $dept) {				
				echo CHtml::tag('option',
                    array('value'=>$dept['department_id']), CHtml::encode($dept['department_name']),true);				
			}			
        }		
		catch(Exception $ex)
		{
			echo $ex;
		}		
	}
	
	
    public function actionCareerExplorer()
    {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->canonicalUrl = 'https://www.univariety.com/explore-career-options';
        $this->metaDesc = 'Explore Career option by browsing Primary & Secondary Interest of Career using the categories below, or Use the career explorer tool to find various career options based on your Interest.';
        $this->metaKeyword = 'career explorer, explore career options, career options, aptitude test, career explorer, career training, training schools, looking for a career, explore careers, career search, career planning, explore occupations';
        $this->setPageTitle('Explore your interest for College & Career Options - Univariety');

        $lookupInterests = LookupInterest::model()->findAll(array("condition" => "is_active = 1", "order" => "interest"));
        $this->interests = CHtml::listData($lookupInterests, 'interest_id', 'interest');
        $ajaxLoad = Yii::app()->request->getQuery('ajaxLoad');
        if($ajaxLoad == 'Y'){
            $this->renderPartial('career_explore', '', false, true);
        }else{
            $this->breadcrumbs=array(
                'Home'=>array('/home'),
                'Online Counsellor'=>array('/onlineCounselling/tools'),
                'Career Explorer',
            );

            $this->render('index');
        }
    }

    public function actionGetInterestsMapping(){
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $interest1 = Yii::app()->request->getQuery('interest1',0);
        $interest2 = Yii::app()->request->getQuery('interest2',0);
        $interestsMapping = LookupCareerInterestMapping::getInterestCareers($interest1, $interest2);
        foreach($interestsMapping as $arr){
            if($arr['main_dept_ref_id']){
                $this->interestsMappingDepartments[$arr['main_dept_ref_id']] = $arr['department_name'];
                $careerArray = array();
                $careerArray['career_id'] = $arr['career_id'];
                $careerArray['url_primary_key'] = $arr['url_primary_key'];
                $careerArray['career_name'] = $arr['career_name'];
                $careerArray['page_thumbnail'] = $arr['page_thumbnail'];
                $this->interestsMapping[$arr['main_dept_ref_id']][] = $careerArray;
            }
        }
        ksort($this->interestsMapping);
        $this->renderPartial('_careers_list');
        /*foreach($interestsMapping as $arr){
            //$this->printr($arr->career->mainDeptRef->attributes);
            if($arr->career->mainDeptRef->attributes['department_id']){
            $this->interestsMappingDepartments[$arr->career->mainDeptRef->attributes['department_id']] = $arr->career->mainDeptRef->attributes['department_name'];
            $careerArray = array();
            $careerArray['career_id'] = $arr->career->attributes['career_id'];
            $careerArray['url_primary_key'] = $arr->career->attributes['url_primary_key'];
            $careerArray['career_name'] = $arr->career->attributes['career_name'];
            $careerArray['page_thumbnail'] = $arr->career->attributes['page_thumbnail'];
            $this->interestsMapping[$arr->career->mainDeptRef->attributes['department_id']][] = $careerArray;
            //$this->printr($arr->attributes);
           }
        }*/
        //echo '<pre>';print_r($interestsMapping);
        /*foreach($interestsMapping as $arr){
            if($arr->mainDeptRef->attributes['department_id']){
                $this->interestsMappingDepartments[$arr->mainDeptRef->attributes['department_id']] = $arr->mainDeptRef->attributes['department_name'];
                $careerArray = array();
                $careerArray['career_id'] = $arr->attributes['career_id'];
                $careerArray['url_primary_key'] = $arr->attributes['url_primary_key'];
                $careerArray['career_name'] = $arr->attributes['career_name'];
                $careerArray['page_thumbnail'] = $arr->attributes['page_thumbnail'];
                $this->interestsMapping[$arr->mainDeptRef->attributes['department_id']][] = $careerArray;
                //$this->printr($arr->attributes);
            }
        }
        ksort($this->interestsMapping);
        $this->renderPartial('_careers_list');*/
    }

    public function actionCollegeSearch()
    {
        $this->setPageTitle(Yii::app()->name.' - Finding the right college best suited for you in US, UK, Canada, Australia, India, Singapore and New Zealand');
        $ajaxLoad = Yii::app()->request->getQuery('ajaxLoad');
        if($ajaxLoad == 'Y'){
            $this->renderPartial('college_search', '', false, true);
        }else{
            $this->breadcrumbs=array(
                'Home'=>array('/home'),
                'Online Counsellor'=>array('/onlineCounselling/tools'),
                'College Search',
            );
            $this->render('index');
        }

    }

    public function actionCostCalculator()
    {
        $this->redirect('/app/costcalculator/calculator/costOfDegreeInCountry');
        $this->setPageTitle(Yii::app()->name.' - Find how much does it cost for higher education in US, UK, Canada, Australia, India, Singapore and New Zealand');
        $ajaxLoad = Yii::app()->request->getQuery('ajaxLoad');
        if($ajaxLoad == 'Y'){
            $this->renderPartial('cost_calculator', '', false, true);
        }else{
            $this->breadcrumbs=array(
                'Home'=>array('/dashboard'),
                'Online Counsellor'=>array('/onlineCounselling/tools'),
                'Fee Calculator',
            );
            $this->render('index');
        }
    }

    public function actioncountrySpecificTests()
    {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->canonicalUrl = 'https://www.univariety.com/country-specific-admission-test';
        $this->metaDesc = 'Explore here to find College admission test by country, department, location & details on College - specific tests. Finalize your application by finding out which tests do you need to give.';
        $this->metaKeyword = 'SAT test, ACT test, GRE test, GMAT test, Online Test for competitive exams, SAT & ACT test, TOEFL, GMAT, GRE, LSAT, MCAT, Admission Tests, Practice Tests & Tips, Study Abroad Tests';

        $this->PageTitle = 'Find out Different Country Specific Admission Test - Univariety';
        $testListId=array();
        $shortListData = array();
        $shortlistCount = 0;
        $obj=new ShortListTestEngine();
        $shortListData=$obj->getTestShortList();

        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject' && $val['shortlist_status']){
                $testListId[$key] = $key;
                $shortlistCount++;
            }
        }
	
        $country=Yii::app()->request->getparam('countryId',0);
        $dept=Yii::app()->request->getparam('departmentId',0);
        $sub_view=Yii::app()->request->getparam('sub_view',0);
        $full_view=Yii::app()->request->getparam('full_view',0);
        $uniId=null;
	       
        $loginId = Yii::app()->user->id;

        if($loginId>0)
        {
            $userType = Yii::app()->user->user_type_ref_id;
            $userId= Yii::app()->user->sub_id;
        }
        $loginFlag = false;
        if ($loginId > 0 && $userType == 1 )
        {
            $loginFlag = true;

        }

        if($sub_view &&  $country==100){            
            $national_tests = EntranceExam::getTestListByType($country,$dept,$uniId,"National",0,0);
            $state_tests = EntranceExam::getTestListByType($country,$dept,$uniId,'State',0,0);
            $institute_tests = EntranceExam::getTestListByType($country,$dept,$uniId,'College',0,0);


            $this->renderPartial('_testlist',compact('country','dept','uniId','national_tests','state_tests',
                    'institute_tests','inter_national_tests','loginFlag','testListId'));            

        }
        else if($sub_view && $country!=100){

            $inter_national_tests =EntranceExam::getTestListByType($country,$dept,$uniId,'International',0,0);
            $this->renderPartial('_internationalTestList',compact('country','dept','uniId','national_tests','state_tests','institute_tests',
                    'inter_national_tests','loginFlag','testListId'));
        }
        else{
            $this->render('countryspecifictest',compact('country','dept','uniId','national_tests','state_tests','institute_tests','inter_national_tests','loginFlag','testListId','full_view'));
        }
    }
    
    public function actioncountrySpecificTestsbydept()
    {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->canonicalUrl = 'https://www.univariety.com/country-specific-admission-test';
        $this->metaDesc = 'Admission test-entrance exams for US, UK, India & more Colleges/Universities. Several countries have specific test requirements, explore here to find which tests you need to prepare for.';
        $this->metaKeyword = 'admission test, entrance exams for usa';

        $this->PageTitle = 'Admission Test-Country Specific Entrance Exams Details';
        $testListId=array();
        $shortListData = array();
        $shortlistCount = 0;
        $obj=new ShortListTestEngine();
        $shortListData=$obj->getTestShortList();

        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject' && $val['shortlist_status']){
                $testListId[$key] = $key;
                $shortlistCount++;
            }
        }
	
        $country=Yii::app()->request->getparam('countryId',0);
        $dept=Yii::app()->request->getparam('departmentId',0);
        $sub_view=Yii::app()->request->getparam('sub_view',0);
        $uniId=null;
	       
        $loginId = Yii::app()->user->id;

        if($loginId>0)
        {
            $userType = Yii::app()->user->user_type_ref_id;
            $userId= Yii::app()->user->sub_id;
        }
        $loginFlag = false;
        if ($loginId > 0 && $userType == 1 )
        {
            $loginFlag = true;
        }
        if($sub_view &&  $country==100){            
            $national_tests = EntranceExam::getTestListByType($country,$dept,$uniId,"National",0,0);
            $state_tests = EntranceExam::getTestListByType($country,$dept,$uniId,'State',0,0);
            $institute_tests = EntranceExam::getTestListByType($country,$dept,$uniId,'College',0,0);
            
            $this->renderPartial('_testlistbydept',compact('country','dept','uniId','national_tests','state_tests',
                    'institute_tests','inter_national_tests','loginFlag','testListId'));
        }
        else if($sub_view && $country!=100){
            $inter_national_tests =EntranceExam::getTestListByType($country,$dept,$uniId,'International',0,0);
            $this->renderPartial('_internationalTestListbydept',compact('country','dept','uniId','national_tests','state_tests','institute_tests',
                    'inter_national_tests','loginFlag','testListId'));
        }
        else{
            $this->render('countryspecifictestbydept',compact('country','dept','uniId','national_tests','state_tests','institute_tests','inter_national_tests','loginFlag','testListId'));
        }
    }

    
    public function actionCollegeSpecificTests(){

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->canonicalUrl = 'https://www.univariety.com/app/onlineCounselling/Tools/CollegeSpecificTests';
        $this->metaDesc = 'Explore here to find College admission test by admission, course and ranking & details on College - specific tests. Finalize your application by finding out which tests do you need to give.';
        $this->metaKeyword = 'SAT test, ACT test, GRE test, GMAT test, Online Test for competitive exams, SAT & ACT test, TOEFL, GMAT, GRE, LSAT, MCAT, Admission Tests, Practice Tests & Tips, Study Abroad Tests';
        $this->pageTitle = 'Find out Various College Specific Admission Test - Univariety';

        $testListId=array();
        $shortListData = array();
        $shortlistCount = 0;
        $obj=new ShortListTestEngine();
        $shortListData=$obj->getTestShortList();
        //echo '<pre>'; print_r($shortListData);

        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject' && $val['shortlist_status']){
                    $testListId[$key] = $key;
                $shortlistCount++;
            }
        }

        $collegeList = TblUniversityMaster::getUniversityNameList();
        $deptList = LookupDepartment::getMainDepartmentList();
        $loginId = Yii::app()->user->id;
        if($loginId>0)
        {
            $userType = Yii::app()->user->user_type_ref_id;
            $userId= Yii::app()->user->sub_id;
        }
        $loginFlag = false;

        if ($loginId > 0 && $userType == 1 )
        {
            $loginFlag = true;
        }

        if(Yii::app()->request->isAjaxRequest){

            $uniId = Yii::app()->request->getParam('collegeId');
            $deptId =Yii::app()->request->getParam('deptId');
            $country = null;

            $national_tests = EntranceExam::getTestListByType($country,$deptId,$uniId,"National",0,0);
            $state_tests = EntranceExam::getTestListByType($country,$deptId,$uniId,"State",0,0);
            $institute_tests = EntranceExam::getTestListByType($country,$deptId,$uniId,"College",0,0);
            $inter_national_tests =EntranceExam::getTestListByType($country,$deptId,$uniId,"International",0,0);
            $country = TblUniversityMaster::getUniCountryCityState($uniId);

            if($country['country'] == 'India'){				
                $this->renderPartial('_indiaTestList',compact('national_tests','state_tests','institute_tests','loginFlag','testListId'));
                Yii::app()->end();
            }else{					
                $this->renderPartial('_otherTestList',compact('inter_national_tests','loginFlag','testListId','loginFlag','testListId'));
                Yii::app()->end();
            }


        }
        $this->render('collegeBasedTest',compact('collegeList','deptList','loginFlag','testListId'));
    }



    public function actionAddTestToShortlist(){
        $userId = Yii::app()->user->sub_id;
        $entranceId = Yii::app()->request->getParam('entranceId',null);
        $exam = EntranceExam::model()->findByPk($entranceId);

        if(!$entranceId){
            echo json_encode(array('error' => true,'message' => 'entranceId missing'));
            Yii::app()->end();
        }

        $userEntranceExam= new UserEntranceExam();
        $userEntranceExam->user_ref_id = $userId;
        $userEntranceExam->entrance_exam_ref_id = $entranceId;
        $userEntranceExam->exam_status = 'Planned';
        $userEntranceExam->added_by = Yii::app()->user->id;
        $userEntranceExam->save(false);

        $data = array('flag' => true,'entrance_full_name' => $exam->entrance_full_name);
        echo json_encode($data);
        Yii::app()->end();
    }

    public function actionRemoveFromShortList(){
        $entranceId = Yii::app()->request->getParam('entranceId',null);
        $exam = EntranceExam::model()->findByPk($entranceId);
        if(!$entranceId){
            echo json_encode(array('error' => true,'message' => 'entranceId missing'));
            Yii::app()->end();
        }

        $savedExam = UserEntranceExam::model()->find('user_ref_id=:uid and entrance_exam_ref_id=:eid',array(':uid' => Yii::app()->user->sub_id,':eid' => $entranceId));
        if($savedExam) $savedExam->delete();

        $data = array('flag' => true,'entrance_full_name' =>  $exam->entrance_full_name);
        echo json_encode($data);
        Yii::app()->end();
    }

    public function actionAddCollegeToShortList() {
        $universityId = Yii::app()->request->getParam('universityId');
        $needShortList = Yii::app()->request->getParam('shortList');
        $intent = Yii::app()->request->getParam('intent');
        if($needShortList==""){
            $needShortList = false;
        }
        $universityName = TblUniversityMaster::getUniversityName($universityId);
        $flag = false;
        if ($universityId != '') {
            $flag = true;
            $shortList = new ShortListEngine();
            try{
                if($intent!=''){
                    $shortList->saveToShortList($universityId,constant($intent));
                }else{
                    $shortList->saveToShortList($universityId);
                }
            }catch(Exception $e){
                $flag = false;
            }

        }
        $shortListObj = new ShortListEngine();
        $shortListData = $shortListObj->getShortList();
        $shortlistCount = 0;
        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject'){
                $shortlistCount++;
            }
        }
        echo json_encode(array("count" => "$shortlistCount", "flag" => "$flag","uni_name"=>"$universityName"));
    }

    public function actionGetTests(){
        $action = Yii::app()->request->getParam('action');
        $countryId = Yii::app()->request->getParam('countryId');
        $departmentId = Yii::app()->request->getParam('departmentId');
        $uniId = Yii::app()->request->getParam('uniId');
        if($action != ''){
            if($action == 'testByCountry'){
                $fields = array('countryId' => $countryId, 'departmentId' => $departmentId);
            }
            if($action == 'testByCollege'){
                $fields = array('uniId' => $uniId, 'departmentId' => $departmentId);
            }
            $this->entranceExamDetails['International Level'] = EntranceExam::getTestDetailsByCountryAndDepartment('International', $fields);
            $this->entranceExamDetails['National Level'] = EntranceExam::getTestDetailsByCountryAndDepartment('National', $fields);
            $this->entranceExamDetails['State Level'] = EntranceExam::getTestDetailsByCountryAndDepartment('State', $fields);
            $this->entranceExamDetails['Institute Level'] = EntranceExam::getTestDetailsByCountryAndDepartment('College', $fields);

            $this->renderPartial('_tests_list');
        }

    }


    public function actionAddTestToShortlist1(){

        $entranceId = Yii::app()->request->getParam('entranceId',null);
        $intent = Yii::app()->request->getParam('intent',0);
        $exam = EntranceExam::getTestName($entranceId);
        $flag = false;
        if ($entranceId != '') {
            $flag = true;
            $obj=new ShortListTestEngine();

            try{
                if($intent){
                    $obj->saveToShortList($entranceId,1); // 1 for shortlist
                    //$obj->saveToShortList($entranceId,constant($intent));
                }else{
                    $obj->saveToShortList($entranceId,0); // 0 for remove from shortlist
                    //$obj->saveToShortList($entranceId);
                }
            }catch(Exception $e){
                $flag = false;
            }

        }
        $shortListData=array();
        $obj=new ShortListTestEngine();
        $shortListData = $obj->getTestShortList();
        $shortlistCount = 0;
        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject' && $val['shortlist_status']){
                $shortlistCount++;
            }
        }
        $val = '';
        switch ($intent) {
            case 'SHORTLIST_PLANNED':
                $val = str_replace('Planned', ' Planned', SHORTLIST_PLANNED);break;
            case 'DELETED':
                $val = SHORTLIST_COMPLETED;break;
        }
        echo json_encode(array("count" => "$shortlistCount", "flag" => "$flag","entrance_full_name"=>"$exam", 'status'=>$val));
    }


    public function actionGetTopCollege(){
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $limit = 10;
        $testId = Yii::app()->request->getParam('testId');
        $offset = Yii::app()->request->getParam('offset',0);
        $exam = EntranceExam::model()->findByPk($testId);
        $topCollege = TopPopularCollege::getTopCollegeByEntranceTest($testId,$offset,$limit);
        $shortListData = $collegeListId = array();
        $shortList = new ShortListEngine();
        $shortListData = $shortList->getShortList();
        $shortlistCount = 0;

        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject'){
                $collegeListId[$key] = $key;
                $shortlistCount++;
            }
        }

        if($_GET['sub_view'] == 'sub_view'){
            $this->renderPartial('_testTopColleges',compact('topCollege','exam','collegeListId','testId'));
        }
        else{
            $this->render('testTopColleges',compact('topCollege','exam','collegeListId','testId'));
        }
    }

    public function actionFinish() {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";

        $this->setPageTitle(Yii::app()->name ." - SignUp Completed");

        if (Yii::app()->session->itemAt('sUserUnivariety') == '') {
            $this->redirect('/app/student/createProfile');
        }

        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);
        $url_det = LookupUrl::model()->findByPK($user->redirect_url_ref_id);
        if ($url_det) {
            if ($url_det->url == '/app/dashboard') {
                $this->redirect($url_det->url);
            }
        }
        $this->render('finish');
    }
    public function DynamicPassoutYearAndMonth() {
        $current_month = date('n');
        $year = date('Y');
        $return = array();
        switch ($this->current_class) {
            case '11p':
                if ($current_month < 6) {
                    $return['passout_year'] = $year + 1;
                } else {
                    $return['passout_year'] = $year + 2;
                }
                $return['passout_month'] = 6;
                $return['present_class'] = 11;
                $return['class_status'] = 'Pursuing';
                break;
            case '12p':
                if ($current_month < 6) {
                    $return['passout_year'] = $year;
                } else {
                    $return['passout_year'] = $year + 1;
                }
                $return['passout_month'] = 6;
                $return['present_class'] = 12;
                $return['class_status'] = 'Pursuing';
                break;
            case '12c':
                $return['passout_year'] = 0;
                $return['passout_month'] = 0;
                $return['present_class'] = 12;
                $return['class_status'] = 'Completed';
                break;
        }
        return $return;
    }




    public function sendConfirmationEmail($firstName = false, $email = false) {

        $s = empty($_SERVER['HTTPS']) ? '' : ($_SERVER['HTTPS'] == 'on') ? 's' : '';
        $protocol = strtolower($_SERVER['SERVER_PROTOCOL']);
        $protocol =  substr($protocol, 0, strpos($protocol, '/')). $s;
        $port = ($_SERVER['SERVER_PORT'] == '80') ? '' : (':'.$_SERVER['SERVER_PORT']);
        $siteURL = $protocol . '://' . $_SERVER['SERVER_NAME'];

        $msg = $this->renderPartial('../signup/confirmationTemplateMail', array('firstName' => $firstName, 'email' => $email, 'siteURL' => $siteURL), true);

        $params = array();
        $params['EmailMessage']['subject'] = 'Registration Confirmation';
        $params['EmailMessage']['body'] = $msg;
        $params['EmailMessage']['type'] = 'Signup';
        $params['EmailMessage']['siteUrl'] = '';
        $params['EmailMessage']['cc'] = '';
        $params['EmailMessage']['toName'] = $firstName;
        $params['EmailMessage']['toEmail'] = $email;
        $params['EmailMessage']['apiKey'] = Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;
        Yii::app()->user->setState('$_POST', $url);
        $status = Yii::app()->runController("sms/email/addMessage");
    }


    public function actionCollegesList(){
        $term = Yii::app()->getRequest()->getParam('term', false);
        $val = array();
        if ($term) {
            $res = TblUniversityMaster::getSuggestionList($term);
            if ($res) {
                foreach ($res as $r) {
                    $val[] = array('id' => $r->attributes['uni_id'], 'value' => html_entity_decode($r->attributes['uni_name'], ENT_QUOTES));
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }

    public function printr($array = array()){
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }

    public function actionautocompleteColleges(){
        $res =array();

        if (isset($_GET['term'])) {
            // http://www.yiiframework.com/doc/guide/database.dao
            $qtxt ="SELECT uni_id, uni_name FROM tbl_university_master WHERE uni_name  LIKE :uni_name";
            $command =Yii::app()->db->createCommand($qtxt);
            $command->bindValue(":uni_name", '%'.$_GET['term'].'%', PDO::PARAM_STR);
            $res = $command->queryAll();
        }

        echo CJSON::encode($res);
        Yii::app()->end();
    }

    public function actionGetUniversitySuggest($term) {
        $countryId = "";
        $term = trim($term);
        if($term != ''){
            $results = TblUniversityMaster::getUniversityListAuto2($term, 10, 'Y');
            $op = array();
            if (count($results) > 0) {
                foreach ($results as $result) {
                    $op[] = array(
                        'id' => $result->uni_id,
                        'value' => htmlspecialchars_decode($result->uni_name),
                        'url' => $result->website_url,
                        'url_primary_key' => $result->url_primary_key,
                    );
                }
            } else {
                $op[] = array(
                    'id' => "#000",
                    'value' => "There is no college that match what you've entered",
                );
            }
        } else {
            $op[] = array(
                'id' => "#000",
                'value' => "There is no college that match what you've entered",
            );
        }
        echo CJSON::encode($op);
    }
}