<link rel="stylesheet/less" type="text/css" href="/app/themes/new_grid_theme/views/layouts/less/skelton.less" />
<link rel="stylesheet/less" type="text/css" href="/app/themes/new_grid_theme/views/layouts/less/component.less" />
<?php
$userID = Yii::app()->session->get('studentID');
$lookupRes = LookupLorType::model()->findByPk($inviteType)
?>
<div class="row multi_line white color-dark-gray small-gutter container visible" style="margin-top: 0px">
	<h4 class="center uppercase gutter_vertical">
        <?php if ($inviteType == '4') {
            echo 'Invite Others';
        }
        else {
            echo 'Invite Teacher from your School';
        }
        ?>
    </h4>

	<div class="gutter_vertical visible">
        <?php
        if($inviteType == '2') {
            $recommendationList = LorTeachersInfo::model()->findAll(sprintf('added_by_student=%d OR added_by_student IS NULL',$userID));}
        else if ($inviteType == '4'){
            $recommendationList = LorOthersInfo::model()->findAll(sprintf('added_by_student=%d OR added_by_student IS NULL',$userID));
        }
        ?>
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'inviteData',
            'enableAjaxValidation' => true,
            'enableClientValidation' => false,
            'clientOptions' => array(
                'validateOnSubmit' => true,
                'validateOnChange' => false,
                'validateOnType' => false,
                'afterValidate' => 'js:function(form, data, hasError){
                        if(!$.isEmptyObject(data)){
                            for(var i in data) {
                                var id = i, message = data[i][0];
                               $("#"+i+"_em_").html(message).show();
                            }
                            $("html, body").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 100 }, 1000);
                            return false;
                        }
                        else
                        {
                            postData(form);
                        }
                }',
            )
        ));
            $selectDispDiv = count($recommendationList)>0 ? 'block' : 'none';
        ?>
        <div class="selectListDiv visible" style="display: <?php echo $selectDispDiv;?> ">
            <div class="clearfix gutter_vertical">
                <span>Select and send invitation for letter of recommendation</span>
                <a href="javascript:void(0);" class="right" id="addList">Not find teacher in the list?</a>
            </div>
            <div class="gutter_vertical relative">
                <?php
                echo $form->hiddenField($model, 'temp', array('class'=>'relative'));
                echo $form->error($model, 'temp', array("class" => "errorMessage popup"));
                ?>
            </div>
            <div class="gutter_vertical visible">
                <?php
                $notInviteCount = 0;
                foreach($recommendationList as $list) { ?>
                <div class="clearfix row multi_line small-gutter border-bottom">
                    <div class="grid_0 pull">
                        <?php
                            $style = 'margin-left: 30px !important;';
                            if($inviteType == '2'){
                                $hasSentInvites = LorInviteInfo::model()->exists(sprintf('uni_ref_id=%s AND user_ref_id=%s AND teacher_ref_id=%d', $collegeID, $userID, $list->lor_teachers_info_id));
                                if(!$hasSentInvites){
                                    echo $form->checkBox($model, "rec_lists[$list->lor_teachers_info_id]", array('uncheckValue'=>null) );
                                    $notInviteCount = 1;
                                    $style = '';
                                }
                            } else {
                                $hasSentInvites = LorInviteInfo::model()->exists(sprintf('uni_ref_id=%d AND user_ref_id=%d AND other_ref_id=%d', $collegeID, $userID, $list->lor_others_info_id));
                                if(!$hasSentInvites){
                                    echo $form->checkBox($model, "rec_lists[$list->lor_others_info_id]",  array('uncheckValue'=>null));
                                    $notInviteCount = 1;
                                    $style = '';
                                }
                            }
                        ?>
                    </div>
                    <div class="left small-right" style="<?php echo $style;?>">
                        <h4 class="left small-right"><?php echo ucfirst($list->first_name.' '.$list->last_name);?></h4>
                        <span class="left small-right">(<?php echo ($inviteType == '2') ? $list->teacherSubjectRef->subject_name : $list->relationRef->relation;?>),</span>
                        <span><?php echo $list->email;?> </span>
                    </div>
                </div>
                <?php }
                echo CHtml::hiddenField('pickListFlag','1');
                echo CHtml::hiddenField('collegeID',$collegeID);
                echo CHtml::hiddenField('inviteType',$inviteType);
                ?>
            </div>
            <div class="center">
                <?php
                if($notInviteCount){
                    echo CHtml::submitButton('Invite', array('value' => 'Invite', 'class' => "button-green tny grid_2"));
                }?>
            </div>

            <?php $this->endWidget(); ?>
        </div>
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'inviteData2',
            'enableAjaxValidation' => true,
            'enableClientValidation' => false,
            'clientOptions' => array(
                'validateOnSubmit' => true,
                'validateOnChange' => false,
                'validateOnType' => false,
                'afterValidate' => 'js:function(form, data, hasError){
                        if(!$.isEmptyObject(data)){
                            for(var i in data) {
                                var id = i, message = data[i][0];
                               $("#"+i+"_em_").html(message).show();
                            }
                            $("html, body").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 100 }, 1000);
                            return false;
                        }
                        else
                        {
                            postData(form);
                        }
                }',
            )
        ));
            $displayDiv = count($recommendationList)<1 ? 'block' : 'none';
        ?>
        <div class="addListDiv" style="display: <?php echo $displayDiv;?>;">
            <div class="clearfix gutter_vertical">
                <span>Add and send invitation for letter of recommendation</span>
                <?php if(count($recommendationList)>0){ ?>
                    <a href="javascript:void(0);" class="right" id="selectList">Select from the list</a>
                <?php } ?>
            </div>

            <div class="gutter_vertical relative">
                <?php
                echo $form->textField($model, 'first_name', array('placeholder'=>"First Name", 'class'=>'full-width', "maxlength"=>"30"));
                echo $form->error($model, 'first_name', array("class" => "errorMessage popup right"));
                ?>
            </div>
            <div class="gutter_vertical relative">
                <?php
                echo $form->textField($model, 'last_name', array('placeholder'=>"Last Name", 'class'=>'full-width', "maxlength"=>"30"));
                echo $form->error($model, 'last_name', array("class" => "errorMessage popup right"));
                ?>
            </div>
            <?php if($inviteType == '2') { ?>
            <div class="gutter_vertical relative">
                <?php
                echo $form->dropDownList($model, 'teacher_subject_ref_id', $teacherSubjects, array('empty' => 'Subject', 'class' => 'full-width'));
                echo $form->error($model, 'teacher_subject_ref_id', array("class" => "errorMessage popup right"));
                ?>
            </div>
            <?php } ?>
            <?php if($inviteType == '4') {?>
            <div class="gutter_vertical relative">
                <?php
                echo $form->dropDownList($model, 'relation_ref_id', $relationList, array('empty' => 'Relation', 'class' => 'full-width'));
                echo $form->error($model, 'relation_ref_id', array("class" => "errorMessage popup right"));
                ?>
            </div>
            <?php } ?>
            <div class="gutter_vertical relative">
                <?php
                echo $form->textField($model, 'email', array('placeholder' => "Email", "maxlength" => "50", "class" => "full-width"));
                echo $form->error($model, 'email', array("class" => "errorMessage popup right"));
                echo CHtml::hiddenField('pickListFlag',0);
                echo CHtml::hiddenField('collegeID',$collegeID);
                echo CHtml::hiddenField('inviteType',$inviteType);
                ?>
            </div>
            <div class="center">
                <?php echo CHtml::submitButton('Invite', array('value' => 'Invite', 'class' => "button-green tny grid_2")); ?>
            </div>

            <?php $this->endWidget(); ?>
        </div>
        <?php //} ?>
	</div>
</div>

<script>

$('#addList').click(function(){
    $('.addListDiv').show();
    $('.selectListDiv').hide();
});

$('#selectList').click(function(){
    $('.addListDiv').hide();
    $('.selectListDiv').show();
});

function postData(form){

    var datastring = $(form).serialize();
    $.post(ibase_url + "milestoneprogress/lor/invite", datastring, function(){
        $.fancybox.close();
        $.notification({
            class: "success_notify",
            notification: "notification_geniric",
            replaceKeys: {MESSAGE: "Invited successfully."}
        });
        var collegeID = $('body').data('invitedCollege');
        $(".collegeSection").load(ibase_url + "milestoneprogress/default/CollegePreferences", function(){
            $('.sliderMP', '.collegeSection').slides({ preload: true, generateNextPrev: true, });
            $('.collegeRow[data-college-id="'+collegeID+'"]').find('.viewInvites').trigger('click');
        });
        /*updateCollegeSection(function(){
            var collegeID = $('body').data('invitedCollege');
            $('.collegeRow[data-college-id="'+collegeID+'"]').find('.viewInvites').trigger('click');
        });*/
    });
}

$("body").on('focus', 'input, select',function(){
    $(this).next('div.errorMessage').hide('slow');
})
</script>