<?php
$userID = $uid;
$milestoneData = UserMilestoneTracking::model()->find(
    sprintf("user_ref_id = %d AND milestone_ref_id=3", $userID));
$shortlistedTests = UserEntranceExam::model()->with('entranceExamRef')->findAll(array(
    'condition'=>"t.user_ref_id=:userID AND t.shortlist_status = '1' AND entranceExamRef.is_active='1'",
    'params'=>array(':userID'=>$userID),
    'order'=>'t.added_on DESC'
));

?>
<div>
    <div class="row multi_line small-gutter white gutter_vertical">
        <div class="clearfix gutter_vertical">
            <div class="gutter_vertical left grid_6 small-right">
                <h4 class="left grid_3 small-right"><span class="link-button button-green small_gutter_r">3</span> Entrance Tests</h4>
                <?php if($milestoneData && $milestoneData->completion_date){ ?>
                    <span class="color-green"><strong>
                            Completed ( <?php echo (new DateTime($milestoneData->completion_date))->format('jS M Y'); ?> )
                        </strong></span>
                <?php }else{ ?>
                    <span class="color-gray"><strong>
                            Pending ( <?php echo $milestoneData->deadline_date ?
                                (new DateTime($milestoneData->deadline_date))->format('jS M Y') : 'N/A'; ?> )
                        </strong></span>
                <?php } ?>
            </div>
            <div class="left actionable">
                <div class="left relative small-right sliderMP" style="overflow: hidden;">
                    <div class="left small_gutter_t small-right">Tools: </div>
                    <div class="row multi_line no-clear light-gray bordered pull slides_container" style="border-radius: 50px; padding: 4px 28px !important; width: 360px;">
                        <div class="small">
                            <a target="_blank" href="/app/index.php/onlineCounselling/Tools/countrySpecificTests">
                                <img src="/app/themes/new_grid_theme/views/layouts/images/test-deepdive-icon.png" > Test Deep Dive</a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="gutter-left-35">
            <div class="row multi_line no-gutter small gutter_vertical">
                <div class="grid_4 pull">Test</div>
                <div class="grid_4 pull" style="text-align: center">Important Dates</div>
                <div class="right actionable">
                    <input type="text" class="search tny2 small_gutter_r grid_3 test_search"
                           placeholder="Add Entrance Tests" style="border-radius: 30px; padding: 4px 21px !important; background-position: 103% -0%">
                </div>
            </div>
            <?php
            if($shortlistedTests){
                foreach($shortlistedTests as $shortlistedTest){
                    $testID = $shortlistedTest->entrance_exam_ref_id;
                    $shortName = $shortlistedTest->entranceExamRef->entrance_short_name;
                    $fullName  = $shortlistedTest->entranceExamRef->entrance_full_name;
                    $Name = strpos($fullName, $shortName) !== false ? $fullName : $fullName.' ('.$shortName.')';
                    ?>
                    <div class="row multi_line border-top testRow" data-test-id="<?php echo $testID; ?>" data-test-name="<?php echo $Name; ?>"
                         style="padding: 7px 0px !important">
                        <div class="grid_5 pull">
                            <?php
                            echo $Name;
                            //echo CHtml::link($Name, Yii::app()->getbaseUrl(true).UniversityHelper::getTestUrl($testID), array('target'=>'_blank')); ?></div>
                        <div class="grid_4 pull">
                            <?php
                            $choseDeadLines = MilestoneTestDeadlinesChosen::model()->with(array(
                                'entranceExamDateLabelRef',
                                'entranceExamDateLabelRef.entranceExamDateSectionRef'))->findAll("user_ref_id=$userID AND entranceExamDateSectionRef.entrance_exam_ref_id=$testID");
                            if($choseDeadLines){ ?>
                                <ol style="list-style-type:disc; margin: 0px; padding: 0px">
                                    <?php foreach($choseDeadLines as $deadline){ ?>
                                        <li>
                                            <?php
                                            echo date("M",mktime('0','0','0',$deadline->entranceExamDateLabelRef->date_month,1));
                                            if(!empty($deadline->entranceExamDateLabelRef->date_day)) echo ' '.$deadline->entranceExamDateLabelRef->date_day;
                                            if(!empty($deadline->entranceExamDateLabelRef->date_year)) echo ', '.$deadline->entranceExamDateLabelRef->date_year;
                                            ?>
                                            <?php echo $deadline->entranceExamDateLabelRef->entranceExamDateSectionRef->section.' '.$deadline->entranceExamDateLabelRef->label; ?>
                                        </li>
                                    <?php } ?>
                                </ol>
                            <?php } else{ echo '<div class="grid_2 center"> - </div>'; } ?>
                            <a href="#" class="updateImpDates left small actionable">
                                <i class="fa fa-plus"></i> Add/Edit important dates</a>
                        </div>
                        <div class="right actionable">
                            <a href="#" class="deleteTest" title="Delete"><i class="fa fa-times"></i></a>
                        </div>
                    </div>
                    <?php
                }
            }else{
                echo '<div class="center row gutter_vertical dark-pink gutter-left-35">No Entrance Tests found.</div>';
            }
            ?>
        </div>
        <div class="center actionable">
            <button type="button" onclick="goHash('instituteSection', this.form)" class="button-default tny small_gutter_r">Skip</button>
        </div>
    </div>
</div>