<?php
$userID = $uid;
$milestoneData = UserMilestoneTracking::model()->find(
    sprintf("user_ref_id = %d AND milestone_ref_id=2", $userID));
$majorPrefs = StudentPreferredDepartment::model()->with('mainDeptRef')->findAll(array(
    'condition'=>sprintf("user_ref_id = %d AND not_sure != 1", $userID),
    'order'=>'t.preference_order ASC'
));

?>
<div>
    <div class="row multi_line small-gutter white gutter_vertical">
        <div class="clearfix">
            <div class="gutter_vertical left grid_6 small-right">
                <h4 class="left grid_3 small-right"><span class="link-button button-green small_gutter_r">2</span> Major Preferences</h4>
                <?php if($milestoneData && $milestoneData->completion_date){ ?>
                    <span class="color-green"><strong>
                            Completed ( <?php echo (new DateTime($milestoneData->completion_date))->format('jS M Y'); ?> )
                        </strong></span>
                <?php }else{ ?>
                    <span class="color-gray"><strong>
                            Pending ( <?php echo $milestoneData->deadline_date ?
                                (new DateTime($milestoneData->deadline_date))->format('jS M Y') : 'N/A'; ?> )
                        </strong></span>
                <?php } ?>
            </div>
            <div class="actionable">
                <div class="left relative small-right sliderMP" style="overflow: hidden;">
                    <div class="left small_gutter_t small-right">Tools: </div>
                    <div class="row multi_line no-clear light-gray bordered pull slides_container" style="border-radius: 50px; padding: 4px 28px !important; width: 360px;">
                        <div class="small">
                            <a target="_blank" href="/app/index.php/onlineCounselling/tools/careerExplorer">
                                <img src="/app/themes/new_grid_theme/views/layouts/images/career-interest-icon.png" > Career Interest Match</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="gutter-left-35">
            <?php if($majorPrefs){
                $i=1;
                foreach($majorPrefs as $majorPref) { ?>
                    <?php echo $i; ?>.
                    <span class="small_gutter_r">
                            <?php
                            echo $majorPref->mainDeptRef->department_name;
                            $subdeptName = $majorPref->subDeptRef->department_name;
                            if($subdeptName){
                                ?> <span class="color-gray">( <?php echo $subdeptName; ?> )</span> <?php
                            }
                            ?>
                        </span>
                    <?php if($i < count($majorPrefs)){ ?>
                        <span class="small_gutter_r">|</span>
                    <?php } ?>
                    <?php $i++;
                }
            }
            ?>
        </div>

        <?php if(!isset($_GET['bypass'])){ ?>
            <div class="clearfix gutter-verticle-auto grid_9 majorEditDiv">

            <?php
            $formModel = new CareerPlanFormModel;
            $form = $this->beginWidget('CActiveForm', array(
                'action'=> Yii::app()->createUrl('student/careerplan/updatemajorpreferences?uid='.$userID),
                'id'=>'majorForm',
                'enableClientValidation' => false,
                'enableAjaxValidation'=>true,
                'clientOptions' =>array(
                    'validateOnSubmit'=>true,
                    'beforeValidate'  => 'js:function(form){
                        return true;
                    }',
                    'afterValidate' => 'js:function(form, data, hasError){
                        if(!$.isEmptyObject(data)){
                            for(var i in data) {
                               var id = i, message = data[i][0];
                               $("#"+i+"_em_").html(message).show();
                            }
                            $("html, body").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 250 }, 1000);
                            return false;
                        }else{
                            $(".submitBtn", form).attr("disabled", "disabled").text("...please wait");
                            $.post($(form).attr("action"), $(form).serialize() , function(r){
                                $.notification({class: r.msg_cls, notification:r.msg_notification, replaceKeys: r.replaceKeys, time:4E3});
                                if(r.msg_cls != "error_notify"){
                                    milestoneProgress.updateSection("majorsection", function(){
                                        goHash("testSection");
                                    });
                                }
                            }, "json")
                        }
                    }',
                )
            ));
            echo $form->hiddenField($formModel,'hidden_temp');
            echo $form->error($formModel,'hidden_temp');

            $i = 1;
            while($i <= 3){
                $index = uniqid();
                $chosenMajor = array_shift($majorPrefs);
                ?>
                <div class="mainSection gutter_vertical clearfix">
                    <div class="grid_2 pull small_gutter_t">Preferred Course <?php echo $i; ?> </div>
                    <div class="grid_3 left small-right relative">
                        <?php
                        echo $form->dropDownList(
                            $formModel,'major_of_interest['.$index.'][major_id]', $formModel->getMajorsList(),
                            array(
                                'empty' => 'Choose Major', 'class' => 'full-width majorInterest',
                                'options' => array( $chosenMajor->main_dept_ref_id =>array('selected'=>true))
                            )
                        );
                        echo $form->error($formModel,'major_of_interest['.$index.'][major_id]',  array('class'=>'errorMessage popup'));
                        ?>
                    </div>
                    <div class="grid_3 pull dependent_div relative">
                        <?php
                        $subDepts = array();
                        if($chosenMajor->main_dept_ref_id){
                            $sData = LookupDepartment::getSubDepartmentsList($chosenMajor->main_dept_ref_id);
                            $subDepts = CHtml::listData($sData,'department_id','department_name');
                        }

                        echo $form->dropDownList(
                            $formModel,'major_of_interest['.$index.'][sub_dept_id]', $subDepts,
                            array(
                                'empty' => 'Choose sub department', 'class' => 'full-width sub_department_drpdwn',
                                'options' => array( $chosenMajor->sub_dept_ref_id =>array('selected'=>true))
                            )
                        );
                        echo $form->error($formModel,'major_of_interest['.$index.'][sub_dept_id]',  array('class'=>'errorMessage popup'));

                        ?>
                    </div>
                </div>
                <?php
                $i++;
            } ?>
            <div class="clearfix center">
                <button type="submit" class="submitBtn button-blue tny small_gutter_r">Save</button>
                <button type="button" onclick="goHash('testSection', this.form)" class="button-default tny small_gutter_r">Skip</button>
            </div>
            <?php $this->endWidget(); ?>
        </div>
        <?php } ?>
    </div>
</div>