<?php
Yii::import('application.modules.vendor.models.VendorCentre');
$userID = $uid;
$milestoneData = UserMilestoneTracking::model()->find(
    sprintf("user_ref_id = %d AND milestone_ref_id=4", $userID));
$Sql = "SELECT vc.vendor_centre_id, vc.centre_name, tcm.city_name, vc.address2, ll.locality_name
        FROM student_shortlist_vendor ssv
        JOIN vendor_centre vc ON vc.vendor_centre_id = ssv.vendor_centre_ref_id
        LEFT JOIN lookup_locality ll ON ll.locality_id = vc.locality_ref_id
        LEFT JOIN tbl_city_master tcm ON tcm.city_id = vc.city_ref_id
        WHERE ssv.user_ref_id = '{$userID}' GROUP BY vc.vendor_centre_id ORDER BY ssv.added_on DESC";
$shortlistedCenters =Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();

?>
<div>
    <div class="row multi_line small-gutter white gutter_vertical">
        <div class="clearfix gutter_vertical">
            <div class="gutter_vertical left grid_6">
                <h4 class="left grid_3 small-right"><span class="link-button button-green small_gutter_r">4</span> Coaching Institutes</h4>
                <?php if($milestoneData && $milestoneData->completion_date){ ?>
                    <span class="color-green"><strong>
                            Completed ( <?php echo (new DateTime($milestoneData->completion_date))->format('jS M Y'); ?> )
                        </strong></span>
                <?php }else{ ?>
                    <span class="color-gray"><strong>
                            Pending ( <?php echo $milestoneData->deadline_date ?
                                (new DateTime($milestoneData->deadline_date))->format('jS M Y') : 'N/A'; ?> )
                        </strong></span>
                <?php } ?>
            </div>
            <div class="right actionable">
                <div class="row multi_line no-clear right no-gutter">
                    <button class="button-blue link-button small findInstitutes">Find Institutes</button>
                </div>
            </div>
        </div>
        <div class="gutter-left-35">
            <div class="row multi_line no-gutter small">
                <div class="grid_4 pull">Institute</div>
                <div class="grid_3 pull">Location</div>
                <div class="grid_3 pull">Phone</div>
            </div>
            <?php
            if($shortlistedCenters){
                foreach($shortlistedCenters as $Center){
                    $centerID = $Center->vendor_centre_id;
                    $centerName = $Center->centre_name;
                    $address = implode(', ', array_filter(array($Center->locality_name ? $Center->locality_name : $Center->address2, $Center->city_name), 'strlen'));
                    ?>

                    <div class="row multi_line border-top instituteRow" data-institute-id="<?php echo $centerID; ?>" data-institute-name="<?php echo $centerName; ?>"
                         style="padding: 7px 0px !important">
                        <div class="grid_4 pull">
<!--                            <a target="_blank" href="<?php /*echo Yii::app()->createabsoluteUrl('/testexperts/expert',array('center' => $centerID));*/?>">-->
                                <?php echo $centerName; ?>
                            <!--</a>-->
                        </div>
                        <div class="grid_3 pull"><?php echo $address; ?></div>
                        <div class="grid_3 pull">
                            <?php
                            $subSql = "SELECT vn.country_code, vn.number from vendor_centre_contact_number vn
                                    JOIN vendor_centre_contact vc ON vc.vendor_centre_contact_id = vn.vendor_centre_contact_ref_id
                                    WHERE vc.vendor_centre_ref_id={$centerID}";
                            $contactNumbers=Yii::app()->db->createCommand($subSql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
                            $phoneInfo = array();
                            if($contactNumbers){
                                foreach($contactNumbers as $contactNumber){
                                    $phoneInfo[] = '('.$contactNumber->country_code.') '.$contactNumber->number;
                                }
                            }
                            echo count($phoneInfo) ? implode('<br>', $phoneInfo) : '-';
                            ?>
                        </div>
                        <div class="right actionable">
                            <a href="#" class="deleteInstitute"><i class="fa fa-times"></i></a>
                        </div>
                    </div>

                    <?php
                }
            }else{
                echo '<div class="center row gutter_vertical dark-pink gutter-left-35">No Institutes found.</div>';
            }
            ?>
        </div>

        <div class="center actionable">
            <button type="button" onclick="goHash('collegeSection', this.form)" class="button-default tny small_gutter_r">Skip</button>
        </div>
    </div>
</div>

