<?php
Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/css/colorbox.css");
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/js/jquery.colorbox.js");

?>
<div>
    <div class="row multi_line white gutter_vertical">
        <div class="clearfix gutter_vertical">
            <h4 class="left">My Notes</h4>
        </div>
    <?php
        $notes = UserDataPoint::model()->with('interactionRef')->findAllByAttributes(['user_ref_id'=>$uid]);
    ?>
        <div class="">
            <div class="row multi_line no-gutter small gutter_vertical">
                <div class="grid_5 left">Note</div>
                <div class="grid_2 pull">Interaction Mode</div>
                <div class="grid_2 pull">Created by</div>
                <div class="grid_2 pull">Created on</div>
            </div>
            <?php
            if($notes) {
                foreach($notes as $note) { ?>
                <div class="row multi_line border-top listingRow" style="padding: 7px 0px !important" id="Row_<?php echo $note->user_data_point_id; ?>">
                    <div class="grid_5 left shortContent">
                        <?php
                        $substring = UniversityHelper::chopString(CHtml::decode($note->comments), 55);
                        echo $substring;
                        if(strlen($substring) > 57) { ?>
                            <a href="javascript:void(0);" class="smal_gutter_l"><i class="fa fa-angle-double-right arrowExpand"></i></a>
                        <?php } ?>
                    </div>
                    <div class="grid_5 left invisible subContent">
                        <?php echo CHtml::decode($note->comments);?> <a href="javascript:void(0);" class="arrowExpand smal_gutter_l"></a>
                    </div>
                    <div class="grid_2 pull">
                        <?php
                        echo $note->interactionRef->interaction_type ?: '-';
                        ?>
                    </div>
                    <div class="grid_2 pull">
                        <?php
                        $admin = TblAdmin::model()->findByAttributes(array('login_ref_id'=>$note->added_by));
                        echo ucwords($admin->admin_name ?: '-');
                        ?>
                    </div>
                    <div class="grid_2 pull">
                        <?php
                        echo date("M d, Y", strtotime($note->added_on));
                        if($note->added_by == Yii::app()->user->id){
                        ?>
                        <a href="javascript:void(0);" class="small right" onclick="DeleteNotes(<?php echo $note->user_data_point_id; ?>);"><i class="fa fa-times"></i> remove</a>
                        <?php
                        } ?>
                    </div>
                </div>
               <?php }
            } ?>
        </div>
    </div>
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'noteData',
        'enableAjaxValidation' => true,
        'action' => array('/milestoneprogress/default/addNotes?uid='.$uid),
        'enableClientValidation' => false,
        'clientOptions' => array(
            'validateOnSubmit' => true,
            'validateOnChange' => false,
            'validateOnType' => false,
            'afterValidate' => 'js:function(form, data, hasError){
                if(!$.isEmptyObject(data)){
                    for(var i in data) {
                        var id = i, message = data[i][0];
                       $("#"+i+"_em_").html(message).show();
                    }
                    return false;
                }
                else{
                    addNotes(form);
                }
            }',
        )
    ));
    $model = new UserDataPoint('counsellor')
    ?>
    <div class="row multi_line no-gutter gutter_vertical visible">
        <div class="gutter_vertical relative">
            <?php
            echo $form->dropDownList(
                $model,'interaction_ref_id',
                CHtml::listData(MasterInteraction::model()->findAll(), 'interaction_id', 'interaction_type'),
                array('empty' => 'Mode of Interaction', 'class' => 'input grid_12')
            );
            echo $form->error($model, 'interaction_ref_id', array("class" => "errorMessage popup"));
            ?>
        </div>
        <div class="gutter_vertical relative">
            <?php
            $this->widget('ext.editMe.widgets.ExtEditMe', array(
                'model'=>$model,
                'attribute'=>'comments',
                'toolbar'=>[
                     ['Bold', '-', 'Italic', '-', 'Underline'],
                     ['Link','-', 'Unlink','-', 'SpecialChar'],
                ],
                'ckeConfig'=>[
                    'enterMode'=>2, 'resize_enabled'=>false,
                    'removePlugins'=>'elementspath',
                    //'startupFocus'=>true,
                    //'toolbarLocation'=>'bottom',
                    'placeholder' => 'Provide some notes...',
                ],
            ));
            echo $form->error($model, 'comments', array("class" => "errorMessage popup"));
            //echo $form->textArea($model, 'comments', array("maxlength" => "2500","class"=>"input","style"=>"width: 100%; height: 200px;","placeholder"=>"Enter your message here", "onkeyup" => "countChar(this, 2500);"));
            // echo $form->error($model, 'comments', array("class" => "errorMessage popup"));
            ?>
            <!-- <span class="relative normal small" id="charNum">2500</span>
            <span class="color-gray">&nbsp; Characters left</span> -->
        </div>
        <?php echo CHtml::submitButton('Save', array('value' => 'Save', 'class' => "button-blue tny")); ?>
        <button type="button" class="button-green tny right shareDiscussion">Share Discussion</button>
    </div>

    <?php $this->endWidget(); ?>
</div>
<style>
    .cke_dialog{
        z-index: 1000001 !important;
    }
</style>
<script>
    function countChar(val, maxLen) {
        var len = val.value.length;
        if (len > maxLen) {
            val.value = val.value.substring(0, maxLen-1);
        } else {
            var value = maxLen - len ;
            $('#charNum').text(value);
        }
    }
    function addNotes(form){
        var datastring = $(form).serialize()+'&uid='+milestoneStudentID;
        $.post(ibase_url + "milestoneprogress/default/addNotes", datastring, function(){
            $.notification({
                class: "success_notify",
                notification: "notification_geniric",
                replaceKeys: {MESSAGE: "Note has been added successfully."}
            });
            $("#noteSection").load(ibase_url + "milestoneprogress/default/notes?uid=" + milestoneStudentID);
        });
    }

    function DeleteNotes(nId){
        if (confirm("Do you want to delete this note?")) {
            if(nId) {
                $.ajax({
                    type: 'POST',
                    url: '<?php echo Yii::app()->createUrl('milestoneprogress/default/deleteNotes'); ?>',
                    data: 'nId='+nId+'&uid='+milestoneStudentID,
                    success: function (data){
                        $.notification({
                            class: "success_notify",
                            notification: "notification_geniric",
                            replaceKeys: {MESSAGE: "Note deleted successfully."}
                        });
                        $("#Row_"+nId).hide();
                    }
                });
            }
        }
    }

</script>