<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'subjectHelpData',
    'enableAjaxValidation' => true,
    'enableClientValidation' => false,
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'validateOnType' => false,
        'afterValidate' => 'js:function(form, data, hasError){
            if(!$.isEmptyObject(data)){
                for(var i in data) {
                    var id = i, message = data[i][0];
                   $("#"+i+"_em_").html(message).show();
                }
                $("div.container").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 100 }, 1000);
                return false;
            }else {
                $(".submitSubjectBtn").attr("disabled", "disabled").val("Please wait...");
                $.post($(form).attr("action"),$(form).serialize(), function(resp){
                    $(".subjectHelp").prop("checked", true);
                    $(".subjectHelpIcon").show();
                    $.fancybox.close();
                    $.notification({
                        class: "success_notify",
                        notification: "notification_geniric",
                        replaceKeys: {MESSAGE: "Subjects has been saved successfully."}
                    });
                    $(".subjectHelpToolTip").find(".basefont").html(resp.data_string).end().show();
                }, "json");
            }
        }',
    )
));
?>
<div class="row multi_line white color-dark-gray small-gutter container" style="margin-top: 0px; width: 600px">
    <h4 class="center uppercase gutter_vertical">Subjects Help</h4>
    <div class="row multi_line no-gutter visible">

        <div class="gutter_vertical relative">
            <?php
            echo $form->textField($model,'target_subjects', array('class' => 'target_subjects input full-width'));
            echo $form->error($model, 'target_subjects', array("class" => "errorMessage popup"));
            ?>
        </div>
    </div>
    <div class="row center">
        <?php echo CHtml::submitButton('Submit', array('class' => "submitSubjectBtn button-green tny")); ?>
    </div>
</div>
<?php
$this->endWidget();
$subjectsListAr=[];
if($subjectsList){
    foreach($subjectsList as $subject){
        $subjectsListAr[] = [
            'id'=>$subject->student_subject_id,
            'name'=>$subject->subject_name
        ];
    }
}
$subjectsHelpAr=[];
if($subjectsHelp){
    foreach($subjectsHelp as $subject){
        $subjectsHelpAr[] = [
            'id'=>$subject->subjectRef->student_subject_id,
            'name'=>$subject->subjectRef->subject_name
        ];
    }
}

?>
<script>
    $(function(){
        $(".target_subjects").tokenInput(<?php echo json_encode($subjectsListAr); ?>, {
            theme: "facebook",
            placeholder: 'Type and choose subjects',
            preventDuplicates: true,
            hintText: "Type and choose subjects",
            prePopulate: <?php echo json_encode($subjectsHelpAr); ?>
        });
    });
</script>