<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'productCommentData',
    'enableAjaxValidation' => true,
    'enableClientValidation' => false,
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'validateOnType' => false,
        'afterValidate' => 'js:function(form, data, hasError){
            if(!$.isEmptyObject(data)){
                for(var i in data) {
                    var id = i, message = data[i][0];
                   $("#"+i+"_em_").html(message).show();
                }
                $("div.container").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 100 }, 1000);
                return false;
            }else {
                $(".submitCmtBtn").attr("disabled", "disabled").val("Please wait...");
                $.post($(form).attr("action"),$(form).serialize(), function(){
                    var productCommentsIcon = $(".productCommentsIcon");
                    var productCommentsCnt = productCommentsIcon.find("#commentsCnt");
                    productCommentsIcon.show();
                    productCommentsCnt.html(parseInt(productCommentsCnt.html()) + 1);
                    $.fancybox.close();
                    $.notification({
                        class: "success_notify",
                        notification: "notification_geniric",
                        replaceKeys: {MESSAGE: "Comment has been saved successfully."}
                    });
                });
            }
        }',
    )
));
?>
<div class="row multi_line white color-dark-gray small-gutter container" style="margin-top: 0px; width: 700px">
    <h4 class="center uppercase gutter_vertical">Comments</h4>
    <div class="row multi_line no-gutter visible">
        <div class="gutter_vertical relative">
            <?php
            echo $form->textArea($model, 'comment', array("maxlength" => "200","class"=>"input full-width","style"=>"height: 50px;","placeholder"=>"Enter your comments here"));
            echo $form->error($model, 'comment', array("class" => "errorMessage popup"));
            ?>
        </div>
    </div>
    <div class="row center">
        <?php echo CHtml::submitButton('Submit', array('class' => "submitCmtBtn button-green tny")); ?>
    </div>
</div>
<?php
$this->endWidget();
if($productComments){
    ?>
    <div class="row multi_line white gutter_vertical container" style="margin-top: 0px; width: 700px">
        <div class="row multi_line no-gutter small gutter_vertical">
            <div class="grid_3 left">Comment</div>
            <div class="grid_2 left">Added by</div>
            <div class="grid_2 pull">Added on</div>
        </div>
        <?php foreach($productComments as $comment){ ?>
            <div class="row multi_line border-top listingRow" style="padding: 7px 0px !important" id="Row_">
                <div class="grid_3 left"><?php echo $comment->comment; ?></div>
                <div class="grid_2 left"><?php echo $comment->enteredBy->admin_name; ?></div>
                <div class="grid_2 pull"><?php echo date("M d, Y", strtotime($comment->entered_on));?></div>
            </div>
        <?php } ?>
    </div>
    <?php
}
?>