<?php
Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'DynamicData',
    'enableAjaxValidation' => true,
    'enableClientValidation' => false,
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'validateOnType' => false,
        'afterValidate' => 'js:function(form, data, hasError){
            if(!$.isEmptyObject(data)){
                for(var i in data) {
                    var id = i, message = data[i][0];
                   $("#"+i+"_em_").html(message).show();
                }
                $("div.container").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 100 }, 1000);
                return false;
            }else {
                $.post($(form).attr("action"),$(form).serialize(), function(resp){
                    $(".levelUpHelp").prop("checked", true);
                    $(".levelUpHelpIcon").show();
                    $.fancybox.close();
                    $.notification({
                        class: "success_notify",
                        notification: "notification_geniric",
                        replaceKeys: {MESSAGE: "Level 2 Counselling has been scheduled successfully."}
                    });
                    $(".levelUpHelpToolTip").find(".basefont").html(resp.date_string).end().show();
                }, "json");
            }
        }',
    )
));
?>
<div class="row multi_line white color-dark-gray small-gutter container" style="margin-top: 0px; width: 600px">
    <h4 class="center uppercase gutter_vertical">Level 2 Counselling - Date & Time</h4>
    <div class="row clearfix multi_line no-gutter visible gutter_vertical">
        <div class="gutter_vertical relative grid_3 left">
            <?php
            if($model->schedule_date)
                $model->schedule_date = DateTime::createFromFormat('Y-m-d', $model->schedule_date)->format('d/m/Y');
            $this->widget('CJuiDateTimePicker',array(
                'model'=>$model, //Model object
                'attribute'=>'schedule_date', //attribute name
                'language'=>'',
                'mode'=>'date', //use "time","date" or "datetime" (default)
                'options'=>array('minDate' => '+0d', "dateFormat" => 'dd/mm/yy'), // jquery plugin options
                'htmlOptions'=>array('placeholder' => 'Choose Date', 'class' => 'input full-width', 'autocomplete' => 'off')
            ));
            echo $form->error($model, 'schedule_date', array("class" => "errorMessage popup"));
            ?>
        </div>
        <div class="gutter_vertical relative grid_3 pull">
            <?php
            if($model->schedule_time)
                $model->schedule_time = DateTime::createFromFormat('H:i:s', $model->schedule_time)->format('H:i');

            $this->widget('CJuiDateTimePicker',array(
                'model'=>$model, //Model object
                'attribute'=>'schedule_time', //attribute name
                'language'=>'',
                'mode'=>'time', //use "time","date" or "datetime" (default)
                //'options'=>array('timeFormat' => "hh:mm",'ampm'=> true, 'showSecond'=>false), // jquery plugin options
                'htmlOptions'=>array('placeholder' => 'Choose Time', 'class' => 'input full-width  uppercase', 'autocomplete' => 'off',)
            ));
            echo $form->error($model, 'schedule_time', array("class" => "errorMessage popup"));
            ?>
        </div>
    </div>
    <div class="row center">
        <?php echo CHtml::submitButton('Submit', array('class' => "sendBtn button-green tny")); ?>
    </div>
</div>
<?php $this->endWidget(); ?>
