<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseFeedbackDiscussion is autogenerate by UniModel generator
 *
 * This is the model class for table "feedback_discussion".
 *
 * The followings are the available columns in table 'feedback_discussion':
 * @property string $feedback_id
 * @property integer $note_ref_id
 * @property string $like_status
 * @property string $email
 * @property string $feedback
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property UserDataPoint $noteRef
 */
class BaseFeedbackDiscussion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FeedbackDiscussion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'feedback_discussion';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('note_ref_id, like_status, email', 'required'),
			array('note_ref_id', 'numerical', 'integerOnly'=>true),
			array('like_status', 'length', 'max'=>1),
			array('email', 'length', 'max'=>50),
			array('feedback, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('feedback_id, note_ref_id, like_status, email, feedback, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'noteRef' => array(self::BELONGS_TO, 'UserDataPoint', 'note_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'feedback_id' => 'Feedback',
			'note_ref_id' => 'Note Ref',
			'like_status' => 'Like Status',
			'email' => 'Email',
			'feedback' => 'Feedback',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('feedback_id',$this->feedback_id,true);
		$criteria->compare('note_ref_id',$this->note_ref_id);
		$criteria->compare('like_status',$this->like_status,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('feedback',$this->feedback,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}