<?php
class StudentSubjectHelpForm extends CFormModel {

	public $target_subjects;

	public function rules() {

		return array(
			array('target_subjects', 'required'),
		);
	}

	public function attributeLabels() {
		return [
			'target_subjects' => 'Subjects',
		];
	}

	public function _ce($error) {
		return '<div class="holder"><p>' . $error . '</p></div>';
	}

	public function addError($attribute, $error) {
		parent::addError($attribute, $this->_ce($error));
	}

	public function saveSubjects($studentID) {

        StudentSubjectHelp::model()->deleteAll('student_ref_id= :userid', [':userid'=>$studentID]);
		if ($this->target_subjects) {
			foreach (explode(',', $this->target_subjects) as $subject) {
				$subjectHelp = new StudentSubjectHelp;
				$subjectHelp->setAttributes(array(
					'student_ref_id' => $studentID,
					'subject_ref_id' => $subject,
					'entered_by' => Yii::app()->user->sub_id,
				), false);
				$subjectHelp->save(false);
			}
		}
	}
}

?>