<?php
class Invite extends LorTeachersInfo {

    public $relation_ref_id;
    public $rec_lists = array();
    public $temp;

    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('email, teacher_subject_ref_id, first_name, last_name, relation_ref_id', 'required'),
            array('email', 'match', 'pattern' => '/^[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/', 'message' => 'Enter a valid email.'),
            //array('email', 'unique', 'className' => 'LoginMaster','attributeName'=>'username', 'message' => 'Email already exist. try another email'),
            array('rec_lists', 'validateCheckBox'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('lor_teachers_info_id, school_ref_id, first_name, last_name, email, teacher_subject_ref_id, added_by_student, added_on, relation_ref_id, temp, rec_lists', 'safe', 'on'=>'search'),
        );
    }

    public function attributeLabels() {
        return array(
            'teacher_subject_ref_id' => 'Subject',
            'relation_ref_id' => 'Relation',
            'rec_lists' => 'Recommendation'
        );
    }

    public function validateCheckBox() {
        $selected = 0;
        if (count($this->rec_lists)) {
            foreach($this->rec_lists as $list){
                if($list){
                    $selected = 1;
                }
            }
            if(!$selected){
                $this->addError('temp', 'Select at least one');
            }
        } else {
            $this->addError('temp', 'Select at least one');
        }
    }

    public function _ce($error){

        return '<div class="holder"><p>'.$error.'</p></div>';
    }

    public function addError($attribute,$error) {

        parent::addError($attribute, $this->_ce($error));
    }
}