<?php

class LorReportController extends BaseController {

    public $requiredDays = 5;
    public $delayTime = 5;

    public function init() {
        parent::init();
        $userType = CommonUtils::getRbacUserRole(Yii::app()->user->id);
        if(!in_array($userType, array('SI'))){
            $this->redirect(Yii::app()->user->redirectUrl);
        }
    }

    public function actionRecommendations(){

        $this->pageTitle = 'Recommendations';

        $model = new LorInviteInfo('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['LorInviteInfo']))
            $model->attributes = $_GET['LorInviteInfo'];
        Yii::app()->session->add('current_class',$model->current_class);
        Yii::app()->session->add('passout_year',$model->passout_year);

        $studentID = Yii::app()->session->get('studentID');
        $user = TblUserMaster::model()->findByPk($studentID);
        $this->render('teacher_recommendations',compact('user','model'));
    }

    public function actionStudents(){

        $teacherId = Yii::app()->request->getParam('tid',0);
        $othersId = Yii::app()->request->getParam('oid',0);
        $mainId = Yii::app()->request->getParam('mid',0);
        if($mainId){
            $lorType = LookupLorType::model()->findByPk($mainId);
            $this->pageTitle = $lorType->lor_name;
        }
        if($teacherId){
            $teachersInfo = LorTeachersInfo::model()->findByPk($teacherId);
        }
        if($othersId){
            $teachersInfo = LorOthersInfo::model()->findByPk($othersId);
        }
        $model = new LorInviteInfo('search');

        $this->render('student_list',compact('model','teacherId','othersId','teachersInfo','mainId','lorType'));
    }

    public function actionAllStudents(){

        $this->pageTitle = 'AllStudents';

        $model = new LorInviteInfo('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['LorInviteInfo']))
            $model->attributes = $_GET['LorInviteInfo'];

        $studentID = Yii::app()->session->get('studentID');
        $user = TblUserMaster::model()->findByPk($studentID);
        $this->render('all_students',compact('user','model'));
    }
}