<?php

class LorController extends BaseController {

    public function init() {
        parent::init();
    }

    public function accessRules() {
        return array(
            array('allow',
                //'expression'=> 'in_array($loginModel->user_type_ref_id, array("9","10"))',
                //'roles'=>array('')
            ),
            array('deny',  // deny all users
                'users'=>array('*'),
            ),
        );
    }

    public function actionInvite(){
        Yii::app()->clientScript->scriptMap['*.js'] = false;
           $collegeID = Yii::app()->request->getParam('collegeID');
           $inviteType = Yii::app()->request->getParam('inviteType');
           $pickListFlag = Yii::app()->request->getParam('pickListFlag');
           if(!$pickListFlag){
               $attributes_to_validate = array('first_name', 'last_name', 'email');
               if($inviteType == '2') {
                    array_push($attributes_to_validate, 'teacher_subject_ref_id');
               } else if($inviteType == '4') {
                   array_push($attributes_to_validate, 'relation_ref_id');
               }
           } else if ($pickListFlag){
               $attributes_to_validate = array('rec_lists', 'temp');
           }

       $model = new Invite('search');

        if (Yii::app()->request->getParam('ajax'))
        {
            $errors = json_decode(CActiveForm::validate($model, $attributes_to_validate), TRUE);
            echo json_encode($errors);
            Yii::app()->end();
        }
        if (Yii::app()->request->isPostRequest)
        {
            $userID = Yii::app()->session->get('studentID');
            $user = TblUserMaster::model()->findByPk($userID);
            $postData = Yii::app()->request->getParam('Invite');
            $model->attributes = $postData;
            if(in_array($inviteType, array(2,4)) )
            {
                if($pickListFlag) {
                    foreach($postData['rec_lists'] as $key=>$list){
                        if($list)
                        {
                            $inviteModel = new LorInviteInfo();
                            $inviteModel->uni_ref_id = $collegeID;
                            $inviteModel->user_ref_id = $userID;
                            $inviteModel->lor_type_ref_id = $inviteType;
                            if($inviteType == '2') {
                                $inviteModel->teacher_ref_id = $key;
                            } else {
                                $inviteModel->other_ref_id = $key;
                            }
                            $inviteModel->added_on = date('Y-m-d H:i:s');
                            $inviteModel->added_by = Yii::app()->user->id;
                            $inviteModel->save(false);
                            if($inviteModel){
                                $lorInfo = LorInviteInfo::model()->findByPk($inviteModel->lor_invite_info_id);
                                if($inviteType == '2') {
                                    $this->_send_lor_mail($lorInfo->teacherRef->first_name, $lorInfo->teacherRef->email, $inviteModel->lor_invite_info_id);
                                } else {
                                    $this->_send_lor_mail($lorInfo->otherRef->first_name, $lorInfo->otherRef->email, $inviteModel->lor_invite_info_id);
                                }
                            }
                        }
                    }
                } else if (!$pickListFlag) {
                    if($inviteType == '2') {
                        $loginId = $this->setLoginCredentials($model,9); // 9 - user type: Teacher
                        $teacherData = array('school_ref_id' => $user->school_ref_id,
                            'first_name' => $model->first_name,
                            'last_name' => $model->last_name,
                            'email' => $model->email,
                            'teacher_subject_ref_id' => $model->teacher_subject_ref_id,
                            'login_ref_id' => $loginId,
                            'added_by_student' => $userID,
                            'added_on' => date('Y-m-d H:i:s')
                        );
                        $infoModel = new LorTeachersInfo();
                        $infoModel->setAttributes($teacherData);
                        $infoModel->save(false);
                    } else if($inviteType == '4') {
                        $loginId = $this->setLoginCredentials($model,10); // 10 - user type: Other(LOR)
                        $otherData = array(
                            'first_name' => $model->first_name,
                            'last_name' => $model->last_name,
                            'email' => $model->email,
                            'relation_ref_id' => $model->relation_ref_id,
                            'login_ref_id' => $loginId,
                            'added_by_student' => $userID,
                            'added_on' => date('Y-m-d H:i:s')
                        );
                        $infoModel = new LorOthersInfo();
                        $infoModel->setAttributes($otherData);
                        $infoModel->save(false);
                    }

                    if($infoModel){
                        $inviteModel = new LorInviteInfo();
                        $inviteModel->uni_ref_id = $collegeID;
                        $inviteModel->user_ref_id = $userID;
                        $inviteModel->lor_type_ref_id = $inviteType;
                        if($inviteType == '2'){
                            $inviteModel->teacher_ref_id = $infoModel->lor_teachers_info_id;
                        } else {
                            $inviteModel->other_ref_id = $infoModel->lor_others_info_id;
                        }
                        $inviteModel->added_on = date('Y-m-d H:i:s');
                        $inviteModel->added_by = Yii::app()->user->id;
                        $inviteModel->save(false);
                        if($inviteModel){
                            $lorInfo = LorInviteInfo::model()->findByPk($inviteModel->lor_invite_info_id);
                            if($inviteType == '2') {
                                $this->_send_lor_mail($lorInfo->teacherRef->first_name, $lorInfo->teacherRef->email, $inviteModel->lor_invite_info_id);
                            } else {
                                $this->_send_lor_mail($lorInfo->otherRef->first_name, $lorInfo->otherRef->email, $inviteModel->lor_invite_info_id);
                            }
                        }
                    }
                }
            }
            Yii::app()->end();
        }

        $subjects = LookupLorTeacherSubject::model()->findAll("is_active='Y'");
        $teacherSubjects = array();
        foreach($subjects as $subject){
            $teacherSubjects[$subject['lor_teacher_subject_id']] = $subject['subject_name'];
        }

        $relations = LookupLorRelation::model()->findAll();
        $relationList = array();
        foreach($relations as $relation){
            $relationList[$relation['lor_relation_id']] = $relation['relation'];
        }

        $this->renderPartial('_invite_teacher', compact('model','teacherSubjects','relationList','inviteType','collegeID'), false, true);
    }

    public function actionInviteCounsellor(){
        $collegeID = Yii::app()->request->getParam('collegeID');
        $inviteType = Yii::app()->request->getParam('inviteType');
        if($collegeID && $inviteType)
        {
            $userID = Yii::app()->session->get('studentID');
            $user = TblUserMaster::model()->findByPk($userID);
            $siInfo = TblSiDi::model()->findByAttributes(array('school_ref_id'=>$user->school_ref_id));

            $inviteModel = new LorInviteInfo();
            $inviteModel->uni_ref_id = $collegeID;
            $inviteModel->user_ref_id = $userID;
            $inviteModel->lor_type_ref_id = $inviteType;
            $inviteModel->counsellor_ref_id = $siInfo->inst_id ?: null;
            $inviteModel->added_on = date('Y-m-d H:i:s');
            $inviteModel->added_by = Yii::app()->user->id;
            $inviteModel->save(false);
            $lorInfo = LorInviteInfo::model()->findByPk($inviteModel->lor_invite_info_id);
            if($lorInfo) {
                $this->_send_lor_mail($lorInfo->counsellorRef->inst_name, $lorInfo->counsellorRef->inst_email, $inviteModel->lor_invite_info_id);
            }
            Yii::app()->end();
        }
    }

    private function _send_lor_mail($firstname, $email, $inviteId) {
        $userID = Yii::app()->session->get('studentID');
        $student = TblUserMaster::model()->findByPk($userID);
        $email_body = $this->renderPartial('email/_lor_tmpl', compact('firstname', 'email', 'inviteId','userID','student'), TRUE);
        $email_header = CBaseController::renderInternal(Yii::app()->basePath . '/views/testexperts/email/_mail_header.php', array(), true);
        $email_footer = CBaseController::renderInternal(Yii::app()->basePath . '/views/testexperts/email/_mail_footer.php', array(), true);
        $message = array();
        $message['subject'] = 'LOR Request From - '.$student->first_name;
        $message['body'] = $email_header . $email_body . $email_footer;
        $message['type'] = 'Signup';
        $message['toName'] = $firstname;
        $message['toEmail'] = $email;
        $message['apiKey'] = Yii::app()->params['emailCron']['curlKey'];
        $emailq = new EmailMessage;
        $emailq->addEmailMessage($message);
        return true;
    }

    public function ActionResendLorMail() {
        $inviteId = Yii::app()->request->getParam('inviteId');
        $inviteInfo = LorInviteInfo::model()->findByPk($inviteId);
        if($inviteInfo->lor_type_ref_id == 2) {
            $firstname = $inviteInfo->teacherRef->first_name;
            $email = $inviteInfo->teacherRef->email;
        }
        else if($inviteInfo->lor_type_ref_id == 4) {
            $firstname = $inviteInfo->otherRef->first_name;
            $email = $inviteInfo->otherRef->email;
        } else {
            $firstname = $inviteInfo->counsellorRef->inst_name;
            $email = $inviteInfo->counsellorRef->inst_email;
        }

        $userID = $inviteInfo->user_ref_id;
        $student = TblUserMaster::model()->findByPk($userID);

        $email_body = $this->renderPartial('email/_lor_resend_tmpl', compact('firstname', 'email', 'inviteId','userID','student'), TRUE);
        $email_header = CBaseController::renderInternal(Yii::app()->basePath . '/views/testexperts/email/_mail_header.php', array(), true);
        $email_footer = CBaseController::renderInternal(Yii::app()->basePath . '/views/testexperts/email/_mail_footer.php', array(), true);
        $message = array();
        $message['subject'] = 'LOR Request From:'.$student->first_name;
        $message['body'] = $email_header . $email_body . $email_footer;
        $message['type'] = 'Signup';
        $message['toName'] = $firstname;
        $message['toEmail'] = $email;
        $message['apiKey'] = Yii::app()->params['emailCron']['curlKey'];
        $emailq = new EmailMessage;
        $emailq->addEmailMessage($message);
        if($emailq && $inviteInfo) {
            $inviteInfo->resent_on = date('Y-m-d H:i:s');
            $inviteInfo->save(false);
        }
        return true;
    }

    public function ActionLorResponse(){
        $inviteId = Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');
        $inviteInfo = LorInviteInfo::model()->findByPk($inviteId);
        if($inviteInfo)
        {
            $inviteInfo->invite_status = $status;
            $inviteInfo->save(false);
            setFlashMessage('success_notify', 'globalnotifications.lor_'.$status);
            $this->redirect('/app/milestoneprogress/lor/recommendationSummary');
        }
    }

    public function setLoginCredentials($model, $userType=false){
        $loginMasterModel = LoginMaster::model()->findByAttributes(array('username'=>trim($model->email) ));
        if($loginMasterModel){
            return $loginMasterModel->login_id;
        }
        $password = DiHelper::genPassword(6);
        $loginMasterData = array('username' => $model->email, 'pass_word' => $password,
            'user_type_ref_id' => $userType, 'is_active' => 1, 'is_email_confirmed' => 0,'added_on' => date('Y-m-d H:i:s'));

        $loginMasterModel = new LoginMaster;
        $loginMasterModel->setAttributes($loginMasterData, false);
        $loginMasterModel->save(false);
        StudentRegistration::_send_login_details_mail('', $model->email, $password);
        return $loginMasterModel->login_id;
    }

    public function actionRecommendationSummary() {
        $this->layout = "//layouts/new_grid_signup";

        $loginModel = LoginMaster::model()->findByPk(Yii::app()->user->id);
        if(!in_array($loginModel->user_type_ref_id, array(2,9,10)) ){
            throw new CHttpException(404, 'The page will access by teachers');
        }
        $this->pageTitle = 'Recommendation Summary';

        $model = new LorInviteInfo('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['LorInviteInfo']))
            $model->attributes = $_GET['LorInviteInfo'];

        $this->render('recommendation_summary',compact('model'));
    }

    public function ActionLorChangeStatus(){
        $inviteId = Yii::app()->request->getParam('inviteid');
        $status = Yii::app()->request->getParam('status');
        $inviteInfo = LorInviteInfo::model()->findByPk($inviteId);
        if($inviteInfo)
        {
            $inviteInfo->invite_status = $status ?: null;
            $inviteInfo->save(false);
        }
    }
}