<?php
class InstituteFormModel extends CFormModel {

    public $hidden_temp;
    public $test_id;
    public $test_name;
    //public $location_name;
    public $city_id;

    public function rules() {

        return array(
            array('test_name, city_id','required'),
            array('test_name, test_id, hidden_temp, city_id', 'safe'),
        );
    }

    public function attributeLabels(){

        return array(
            'test_name' => 'Test',
            'city_id' => 'City',
            //'location_name' => 'Location',
        );
    }

    public function _ce($error){
        return '<div class="holder"><p>'.$error.'</p></div>';
    }

    public function addError($attribute,$error) {
        parent::addError($attribute, $this->_ce($error));
    }

    public function getCoachingCenters($studentID = 0){

        $CentersInfo = array();
        if($this->test_id && $this->city_id){

            $Sql = "SELECT vc.vendor_centre_id, vc.centre_name, tcm.city_name, vc.address2,
         ll.locality_name, IF(ssv.student_shortlist_vendor_id, 1, 0) AS shortlisted,
          vc.establishment_year, vc.is_registered
        FROM vendor_centre_course_test vcct
        JOIN vendor_centre_course vcc ON vcc.vendor_centre_course_id = vcct.vendor_centre_course_ref_id
        JOIN vendor_centre vc ON vc.vendor_centre_id = vcc.vendor_centre_ref_id
        JOIN entrance_exam ee ON ee.entrance_id = vcct.entrance_ref_id
        LEFT JOIN lookup_locality ll ON ll.locality_id = vc.locality_ref_id
        LEFT JOIN student_shortlist_vendor ssv ON ssv.vendor_centre_ref_id = vc.vendor_centre_id
        AND ssv.user_ref_id = '".$studentID."'
        LEFT JOIN tbl_city_master tcm ON tcm.city_id = vc.city_ref_id
        WHERE 1=1 AND vc.is_active=1 AND entrance_id = '".$this->test_id."' AND vc.city_ref_id= '".$this->city_id."'
        GROUP BY vc.vendor_centre_id
        ORDER BY (CASE vc.is_registered WHEN 'Y' THEN '1' ELSE '0' END)  DESC, centre_name ASC  LIMIT 50";
            $Centers =Yii::app()->db->createCommand($Sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
            if($Centers){
                foreach($Centers as $Center){

                    $address = implode(', ', array_filter(array($Center->locality_name ? $Center->locality_name : $Center->address2, $Center->city_name), 'strlen'));

                    $CentersInfo[] = array(
                        'id'   => $Center->vendor_centre_id,
                        'name' => $Center->centre_name,
                        'link' => Yii::app()->createUrl('/testexperts/expert',array('center' => $Center->vendor_centre_id)),
                        'address'=>$address,
                        'verified'=>$Center->is_registered,
                        'shortlisted' => $Center->shortlisted ? true : false,
                        'establishment_year' => $Center->establishment_year,
                    );
                }
            }
        }

        return $CentersInfo;
    }

    static public function getVendorCities(){

        Yii::import('application.models.base.BaseVendorCentre');
        return BaseVendorCentre::model()->with('cityRef')->findAll([
            'select'=>'t.city_ref_id',
            'condition' => "cityRef.city_id > 0",
            'order' => 'cityRef.city_name ASC',
            'group'=>'t.city_ref_id',
        ]);
    }
}

?>