(function ($, window) {

    window.milestoneProgress = {
        sectionUpdates: {
            countrysection: {
                elem: $("#countrySection"),
                url: ibase_url + "milestoneprogress/default/CountryPreferences?uid=" + milestoneStudentID,
            },
            majorsection: {
                elem: $("#majorSection"),
                url: ibase_url + "milestoneprogress/default/MajorPreferences?uid=" + milestoneStudentID,
            },
            testsection: {
                elem: $("#testSection"),
                url: ibase_url + "milestoneprogress/default/TestPreferences?uid=" + milestoneStudentID,
            },
            institutesection: {
                elem: $("#instituteSection"),
                url: ibase_url + "milestoneprogress/default/InstitutePreferences?uid=" + milestoneStudentID,
            },
            collegesection: {
                elem: $("#collegeSection"),
                url: ibase_url + "milestoneprogress/default/CollegePreferences?uid=" + milestoneStudentID,
            },
            admissionsection: {
                elem: $("#admissionSection"),
                url: ibase_url + "milestoneprogress/default/AdmissionPreferences?uid=" + milestoneStudentID,
            },
        },
        updateSection: function (selector, cb) {
            if (selector in this.sectionUpdates) {
                var cb = cb || function () {};
                var elem = this.sectionUpdates[selector].elem;
                $(elem).load(this.sectionUpdates[selector].url, function(){
                    cb();
                    $('.sliderMP', elem).slides({
                        preload: true,
                        generateNextPrev: true,
                    });
                });
                return true;
            }
            console.error('Sorry, the ' + selector + ' does not exist');
        },
        isCollegeNameValid: function (name) {
            var name = $.trim(name);
            if (name.length < 3) {
                $.notification({
                    class: 'error_notify',
                    notification: 'notification_geniric',
                    replaceKeys: {MESSAGE: 'College name must be at least 3 characters long'}
                });
                return false;
            }
            var regx = /^(?![`~,.*<>;':"/[\]|{}()=_+-])(?=^.{3,})/i;
            if (!regx.test(name)) {
                $.notification({
                    class: 'error_notify',
                    notification: 'notification_geniric',
                    replaceKeys: {MESSAGE: 'College name appears to be invalid (Should not start with number or special character)'}
                });
                return false;
            }
            return true;
        },

        init: function () {
            this.bindUIActions();
        },

        dom: {
            body: $('body'),
            countryEditCls: ".countryEditLink",
            countryEdit: function(){ return $('.countryEditDiv') },
            majorEditCls: ".majorEditLink",
            majorEdit: function() { return $('.majorEditDiv') },
            majorInterestCls: 'select.majorInterest',
            countryInterestCls: 'select.countryInterest',
            viewInviteCls: 'a.viewInvites',
            inviteLinkCls: 'a.inviteLink',
            deleteTestCls: 'a.deleteTest',
            updateImpDatesCls: '.updateImpDates',
            addDeadlinesCls: '.AddDeadlines',
            deleteInstituteCls: 'a.deleteInstitute',
            deleteCollegeCls: 'a.deleteCollege',
            deleteAdmissionCls: 'a.deleteAdmission',
            testSearchCls: 'input.test_search',
            collegeSearchCls: 'input.college_search',
            findInstitutesCls: '.findInstitutes',
            updateCenterStatusCls: '.updateCenterStatus',
            shortlistCollegeCls: '.shortlistCollege',
            shortlistStatusCls: '.shortlist_status',
            admissionStatusCls: '.admission_status',
            emailToListCls: '.toList',
            emailListCls: '.emailList',
            arrowExpandCls: '.arrowExpand',
            shareDiscussionCls: '.shareDiscussion',
        },
        bindUIActions: function () {
            this.dom.body.on('click', this.dom.countryEditCls, this.countryEdit);
            this.dom.body.on('click', this.dom.majorEditCls, this.majorEdit);
            this.dom.body.on('change', this.dom.countryInterestCls, this.countryChange);
            this.dom.body.on('change', this.dom.majorInterestCls, this.majorChange);
            this.dom.body.on('click', this.dom.viewInviteCls, this.viewInvite);
            this.dom.body.on('click', this.dom.inviteLinkCls, this.invite);
            this.dom.body.on('click', this.dom.deleteTestCls, this.deleteTest);
            this.dom.body.on('click', this.dom.updateImpDatesCls, this.updateImpDates);
            this.dom.body.on('click', this.dom.addDeadlinesCls, this.addDeadLines);
            this.dom.body.on('click', this.dom.deleteInstituteCls, this.deleteInstitute);
            this.dom.body.on('click', this.dom.deleteCollegeCls, this.deleteCollege);
            this.dom.body.on('click', this.dom.deleteAdmissionCls, this.deleteAdmission);
            this.dom.body.on('click', this.dom.findInstitutesCls, this.findInstitutes);
            this.dom.body.on('click', this.dom.updateCenterStatusCls, this.updateCenterStatus);
            this.dom.body.on('keydown.autocomplete', this.dom.testSearchCls, this.testSearch);
            this.dom.body.on('keydown.autocomplete', this.dom.collegeSearchCls, this.collegeSearch);
            this.dom.body.on('click', this.dom.shortlistCollegeCls, this.collegeShortlist);
            this.dom.body.on('change', this.dom.shortlistStatusCls, this.shortlistStatus);
            this.dom.body.on('change', this.dom.admissionStatusCls, this.admissionStatus);
            this.dom.body.on('click', this.dom.emailToListCls, this.updateEmailList);
            this.dom.body.on('click', this.dom.arrowExpandCls, this.toggleArrow);
            this.dom.body.on('click', this.dom.shareDiscussionCls, this.shareDiscussion);
        },
        shareDiscussion: function (e) {
            $.fancybox.open({
                href: ibase_url + 'milestoneprogress/default/shareDiscussion?uid='+milestoneStudentID,
                type: 'ajax', width: 800, autoHeight: 500,
                helpers: {overlay: {closeClick: false}},
                keys : { close: null }
            });
        },
        toggleArrow: function (e) {
            e.preventDefault();
            var _self = $(this);
            _self.toggleClass('fa-angle-double-right fa-angle-double-left');
            _self.closest('div.listingRow').find(".subContent").toggle();
            _self.closest('div.listingRow').find(".shortContent").toggle();
        },
        updateEmailList: function (e) {
            var _self = $(this);
            var emailListElem = $(milestoneProgress.dom.emailListCls);
            var emailList = emailListElem.val().split(',').filter(Boolean);
            if (this.checked) {
                emailList.unshift(_self.val());
            } else {
                var pos = emailList.indexOf(_self.val());
                pos > -1 && emailList.splice(pos, 1);
            }
            emailListElem.val(emailList.join());
        },
        admissionStatus: function (e) {

            var self = $(this);
            var collegeRow = self.closest('div.admissionRow');
            var collegeID = collegeRow.data('college-id');
            var collegeName = collegeRow.data('college-name');
            var collegeInfo = {id: collegeID, status: self.val(), uid:milestoneStudentID};
            $.post(ibase_url + 'student/careerplan/updateadmissionstatus', collegeInfo, function () {
                if (collegeInfo.status != '0') {
                    $.notification({
                        class: 'success_notify',
                        notification: 'notification_geniric',
                        replaceKeys: {MESSAGE: 'Your admission status for ' + collegeName + ' changed successfully.'}
                    });
                }
                milestoneProgress.updateSection('admissionsection');
            });
        },
        shortlistStatus: function (e) {
            var self = $(this);
            var collegeRow = self.closest('div.collegeRow');
            var collegeID = collegeRow.data('college-id');
            var collegeName = collegeRow.data('college-name');

            var collegeInfo = {id: collegeID, status: self.val(), uid:milestoneStudentID};
            $.post(ibase_url + 'student/careerplan/updateapplicationstatus', collegeInfo, function (resp) {
                $.notification({
                    class: 'success_notify',
                    notification: 'notification_geniric',
                    replaceKeys: {MESSAGE: 'Your application status for ' + collegeName + ' changed successfully.'}
                });
                milestoneProgress.updateSection('admissionsection');
            }, 'json');
        },
        collegeShortlist: function (e) {
            e.preventDefault();
            var self = $(this);
            var collegeInput = $('.college_search').data('college');
            var collegeID = collegeInput ? collegeInput.collegeID : 0;
            var collegeName = collegeInput ? collegeInput.collegeName : '';

            if (!milestoneProgress.isCollegeNameValid(collegeName)) return;

            if (($('div.collegeRow').map(function (i, v) {
                    return $(v).data('college-id')
                }).get().indexOf(+collegeID)) > -1) {
                $.notification({
                    class: 'error_notify',
                    notification: 'already_exist_shortlist',
                    replaceKeys: {UNI_NAME: collegeName}
                });
                event.target.value = '';
                return false;
            }

            $.post(ibase_url + 'student/careerplan/addcollegetoshortlist', {
                collegeID: collegeID,
                uid:milestoneStudentID,
                collegeName: collegeName
            }, function () {
                $.notification({
                    class: 'success_notify',
                    notification: 'addedto_shortlist',
                    replaceKeys: {UNI_NAME: collegeName}
                });
                milestoneProgress.updateSection('collegesection');
            });

        },
        collegeSearch: function () {
            $(this).autocomplete({
                minLength: 2,
                source: ibase_url + 'student/careerplan/searchcollegesbyterm',
                select: function (event, ui) {
                    var elem = this, $elem = $(elem);
                    var collegeID = ui.item.id;
                    var collegeName = ui.item.value;
                    $(event.target).data('college', {collegeID: collegeID, collegeName: collegeName});
                },
                change: function (event, ui) {
                    if (!ui.item) {
                        $(event.target).data('college', {collegeID: null, collegeName: event.target.value});
                    }
                }
            })
        },
        updateCenterStatus: function (e) {

            var self = $(this);
            var centerID = self.data('center-id');
            var centerName = self.data('center-name');
            var isShortlisted = self.hasClass('addedtag');
            $.post(ibase_url + 'student/careerplan/' +
                (isShortlisted ? 'removecenterfromshortlist' : 'addcentertoshortlist'), {centerID: centerID, uid: milestoneStudentID}, function () {
                $.notification({
                    class: 'success_notify',
                    notification: isShortlisted ? 'removefrom_shortlist' : 'addedto_shortlist',
                    replaceKeys: {UNI_NAME: centerName}
                });
                isShortlisted ? self.toggleClass('addedtag addtag') : self.toggleClass('addtag addedtag');
                milestoneProgress.updateSection('institutesection');
            });

        },
        findInstitutes: function (e) {
            $.fancybox.open({
                href: ibase_url + 'milestoneprogress/default/findInstitutes',
                type: 'ajax', width: 800, autoSize: true, autoHeight: true,
                helpers: {overlay: {closeClick: false}}
            });
        },
        testSearch: function (e) {
            $(this).autocomplete({
                minLength: 2,
                source: ibase_url + 'student/careerplan/SearchTestsByTerm',
                select: function (event, ui) {
                    var elem = this, $elem = $(elem);
                    var testID = ui.item.id;
                    var testName = ui.item.value;

                    if (($('div.testRow').map(function (i, v) {
                            return $(v).data('test-id')
                        }).get().indexOf(+testID)) > -1) {
                        $.notification({
                            class: 'error_notify',
                            notification: 'already_exist_shortlist',
                            replaceKeys: {UNI_NAME: testName}
                        });
                        event.target.value = '';
                        return false;
                    }

                    $.post(ibase_url + 'student/careerplan/AddTestToShortlist',{testID: testID, uid: milestoneStudentID}, function () {
                        $.notification({
                            class: 'success_notify',
                            notification: 'addedto_shortlist',
                            replaceKeys: {UNI_NAME: testName}
                        });
                        milestoneProgress.updateSection('testsection');
                    });
                }
            })
        },
        deleteAdmission: function (e) {
            e.preventDefault();
            var self = $(this);
            var parentRow = self.closest('div.admissionRow');
            var collegeID = parentRow.data('college-id');
            var collegeName = parentRow.data('college-name');
            if (confirm('Are sure, you want to delete "' + collegeName + '" ?')) {
                var collegeInfo = {id: collegeID, status: 'MightApply', uid:milestoneStudentID};
                $.post(ibase_url + 'student/careerplan/updateapplicationstatus', collegeInfo, function () {
                    $.notification({
                        class: 'success_notify',
                        notification: 'removefrom_shortlist',
                        replaceKeys: {UNI_NAME: collegeName}
                    });
                    parentRow.fadeOut(200, function () {
                        milestoneProgress.updateSection('admissionsection');
                        milestoneProgress.updateSection('collegesection');
                    })
                });
            }
        },
        deleteCollege: function (e) {
            e.preventDefault();
            var self = $(this);
            var parentRow = self.closest('div.collegeRow');
            var collegeID = parentRow.data('college-id');
            var collegeName = parentRow.data('college-name');
            if (confirm('Are sure, you want to delete "' + collegeName + '" ?')) {
                $.post(ibase_url + 'student/careerplan/removecollegefromshortlist', {collegeID: collegeID, uid:milestoneStudentID}, function () {
                    $.notification({
                        class: 'success_notify',
                        notification: 'removefrom_shortlist',
                        replaceKeys: {UNI_NAME: collegeName}
                    });
                    parentRow.fadeOut(200, function () {
                        milestoneProgress.updateSection('collegesection');
                        milestoneProgress.updateSection('admissionsection');
                    })
                });
            }
        },
        deleteInstitute: function (e) {
            e.preventDefault();
            var self = $(this);
            var parentRow = self.closest('div.instituteRow');
            var instituteID = parentRow.data('institute-id');
            var instituteName = parentRow.data('institute-name');
            if (confirm('Are sure, you want to delete "' + instituteName + '" ?')) {
                $.post(ibase_url + 'student/careerplan/removecenterfromshortlist', {centerID: instituteID, uid: milestoneStudentID}, function () {
                    $.notification({
                        class: 'success_notify',
                        notification: 'removefrom_shortlist',
                        replaceKeys: {UNI_NAME: instituteName}
                    });
                    parentRow.fadeOut(200, function () {
                        $(this).remove();
                        $('div.instituteRow').length == 0 && milestoneProgress.updateSection('institutesection');
                    })
                });
            }
        },
        addDeadLines: function (e) {
            var testID = $(this).closest('div.container').data('test-id');
            var chosenIDs = [].map.call($('.deadline:checked'), function (v) {
                return $(v).val();
            });
            if (!chosenIDs.length) {
                $.notification({
                    class: 'error_notify',
                    notification: 'notification_geniric',
                    replaceKeys: {MESSAGE: 'Please choose at least one date.'}
                });
                return;
            }
            $.post(ibase_url + 'milestoneprogress/default/UpdateDeadLines', {
                    testID: testID,
                    uid: milestoneStudentID,
                    chosenids: chosenIDs.join()
                },
                function () {
                    $.fancybox.close();
                    milestoneProgress.updateSection('testsection');
                });
        },
        updateImpDates: function (e) {
            e.preventDefault();
            var parentRow = $(this).closest('div.testRow');
            var testID = parentRow.data('test-id');
            $.fancybox.open({
                href: ibase_url + 'milestoneprogress/default/updateImportantDates?testid=' + testID+'&uid='+milestoneStudentID,
                type: 'ajax', width: 800, autoSize: true, autoHeight: true,
                helpers: {overlay: {closeClick: false}}
            });
        },
        deleteTest: function (e) {
            e.preventDefault();
            var self = $(this);
            var parentRow = self.closest('div.testRow');
            var testID = parentRow.data('test-id');
            var testName = parentRow.data('test-name');
            if (confirm('Are sure, you want to delete "' + testName + '" ?')) {
                $.post(ibase_url + 'student/careerplan/removetestfromshortlist', {testID: testID, uid : milestoneStudentID}, function () {
                    $.notification({
                        class: 'success_notify',
                        notification: 'removefrom_shortlist',
                        replaceKeys: {UNI_NAME: testName}
                    });
                    parentRow.fadeOut(200, function () {
                        $(this).remove();
                        $('div.testRow').length == 0 && milestoneProgress.updateSection('testsection');
                    })
                });
            }
        },
        invite: function (e) {
            e.preventDefault();
            var self = $(this);
            var queryVars = {
                collegeID: self.closest('div.collegeRow').data('college-id'),
                uid:milestoneStudentID,
                inviteType: self.data('invite-type')
            };
            milestoneProgress.dom.body.data('invitedCollege', queryVars.collegeID);
            if (self.data('invite-type') == 2 || self.data('invite-type') == 4) {
                $.fancybox.open({
                    href: ibase_url + 'milestoneprogress/lor/invite?' + $.param(queryVars),
                    type: 'ajax', width: 700, autoSize: false, autoHeight: true
                });
            } else {
                $.post(ibase_url + 'milestoneprogress/lor/inviteCounsellor', queryVars, function () {
                    $.notification({
                        class: 'success_notify',
                        notification: 'notification_geniric',
                        replaceKeys: {MESSAGE: 'Invited successfully.'}
                    });
                    milestoneProgress.updateSection('collegesection', function () {
                        var collegeID = $('body').data('invitedCollege');
                        $('.collegeRow[data-college-id="' + collegeID + '"]').find('.viewInvites').trigger('click');
                    });
                });
            }
        },
        viewInvite: function (e) {
            e.preventDefault();
            var _self = $(this);
            var parent = _self.closest('div.collegeRow');
            if (_self.text() == 'View Invites') {
                _self.text('Hide Invites');
            } else if (_self.text() == 'Hide Invites') {
                _self.text('View Invites');
            }
            $('div.lorInfo', parent).fadeToggle();
        },
        countryEdit: function (e) {
            e.preventDefault();
            var self = $(this);
            self.hasClass('cancel') && self.closest('form')[0].reset();
            milestoneProgress.dom.countryEdit().fadeToggle();
            initTokenInput();
        },
        countryChange: function () {
            var $self = $(this), selectedVal = $self.val();
            var parent = $self.closest('div.mainSection');
            parent.find('.pref_location').tokenInput('clear');
            setTimeout(function () {
                $('.pref_location').blur();
            }, 51);
        },
        majorEdit: function (e) {
            e.preventDefault();
            var self = $(this);
            self.hasClass('cancel') && self.closest('form')[0].reset();
            milestoneProgress.dom.majorEdit().fadeToggle();
        },
        majorChange: function () {
            var self = $(this), mainDeptID = self.val(),
                subDeptElem = self.closest('div.mainSection').find('select.sub_department_drpdwn'),
                sub_dept_div = self.closest('div.mainSection').find('div.dependent_div');

            sub_dept_div.find('select').children('option:not(:first)').remove();
            sub_dept_div.find('div.errorMessage').hide();

            if (mainDeptID) {
                $.post(ibase_url + 'myProfile/getSubDept', {id: mainDeptID}, function (data) {
                    $.each(data, function (key, value) {
                        subDeptElem.append($('<option>').text(value).attr('value', key.replace('key', '')));
                    });
                    sub_dept_div.fadeIn();

                }, 'json');
            } else {
                sub_dept_div.fadeOut();
            }
        }
    };

    milestoneProgress.init();

})(jQuery, this);

