<?php
    $this->renderPartial('//_pms_left_menu',array('active' => 'webinar'));
?>

<div class="content">
    <ul class="breadcrumb">
        <li>
            <?php echo CHtml::link('Manage Webinars',$this->createUrl('index',array('event_type' => $event_type))); ?>
        </li>
        <li><span class="divider"> > </span></li>
        <li>
            <?php echo 'View '.$event->event_title; ?>
        </li>
    </ul>
    <?php
        foreach(Yii::app()->user->getFlashes() as $key => $message) {
            echo '<div style="padding:10px;margin-bottom:5px;" class="'. $key . '">' . $message . "</div>\n";
        }
    ?>

    <div class="header border-bottom overflow">
        <h1 class="page-title pull-left">Preview Event</h1>
        <a href="<?php echo $this->createUrl('edit',array('id' => $event->event_id,'event_type' => $event_type)); ?>" class="btn pull-right" style="margin: 1em 0;">Edit</a>
    </div>
    
    <ul class="nav nav-tabs">
        <li class="<?php echo $event_type?'':'active'; ?>"><a href="<?php echo $this->createUrl('index'); ?>">UPCOMING WEBINARS</a></li>
        <li class="<?php echo $event_type?'active':''; ?>"><a href="<?php echo $this->createUrl('index',array('event_type' => 1)); ?>">PAST WEBINARS</a></li>
    </ul>        

    <div class="block-body no-left-margin overflow">

        <div class="row-fluid">
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Event Title</label>
                    <?php echo $event->event_title; ?>
                </div>
            </div>
            <div style="clear:both;"></div>

            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Event Type</label>
                    <?php echo $event->event_type; ?>
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Event Start Time</label>
                    <div>
                        <?php 
                            $start_time = DateTime::createFromFormat('Y-m-d H:i:s', $event->event_start_time, new DateTimeZone('UTC'));
                            $start_time->setTimeZone(new DateTimeZone($event->timezone));
                            echo $start_time->format('l h:ia, jS M, Y');
                        ?>
                    </div>
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Event End Time</label>
                    <div>
                        <?php 
                            $end_time = DateTime::createFromFormat('Y-m-d H:i:s', $event->event_end_time, new DateTimeZone('UTC'));
                            $end_time->setTimeZone(new DateTimeZone($event->timezone));
                            echo $end_time->format('l h:ia, jS M, Y');
                        ?>
                    </div>
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Event Time Zone</label>
                    <?php
                        echo $event->timezone;
                    ?>
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Event Description</label>
                    <?php 
                        echo $event->event_desc;
                    ?>
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Video Link</label>
                    <div>
                        <?php 
                            if($event->event_video_url) echo CHtml::link($event->event_video_url,$event->event_video_url,array('target' => '_blank'));
                        ?>
                        &nbsp;
                    </div>
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Speaker Name</label>
                    <div>&nbsp;
                        <?php echo $event->speaker_name; ?>
                        <?php if($event->speaker_name): ?>
                            <span class="divider"><?php echo ($event->speaker_name_visible == 'Y')?'(':'(Not '; ?>Visible to Student)</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Speaker Designation</label>
                    <div>&nbsp;
                        <?php echo $event->speaker_designation; ?>
                        <?php if($event->speaker_designation): ?>
                            <span class="divider"><?php echo ($event->speaker_desig_visible == 'Y')?'(':'(Not '; ?>Visible to Student)</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Speaker Organization</label>
                    <div>&nbsp;
                        <?php echo $event->speaker_org; ?>
                        <?php if($event->speaker_org): ?>
                            <span class="divider"><?php echo ($event->speaker_org_visible == 'Y')?'(':'(Not '; ?>Visible to Student)</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Speaker Sign</label>
                    <div>&nbsp;
                        <img src="<?php echo '/app/images/webinar/speakers/'.$event->speaker_sign;?>" alt="no sign" />
                    </div>
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Applicable Countries</label>
                    <?php
                        $countries = WebinarEvent::get_event_countries($event->event_id);
                    ?>
                    
                    <?php if(count($countries) > 5): ?>
                        <span>Total <?php echo count($countries); ?> countries selected</span>
                    <?php else: ?>
                        <div>
                            <?php foreach($countries as $id => $name): ?>
                            <span id="country_<?php echo $id; ?>" style="margin-right:10px;">
                                <?php 
                                    echo $name.'&nbsp;';
                                    echo CHtml::ajaxlink(
                                        '<span title="delete this country" class="icon-remove-circle icon-large" style="color: red"></span>',
                                        $this->createUrl('delete_country'),
                                        array('type' => 'POST','data' => array('country' => $id),'success' => '$("span#country_'.$id.'").remove()'),
                                        array('confirm' => 'delete this country?')
                                    );
                                ?>
                            </span>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    
                </div>
            </div>
            <div style="clear:both;"></div>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Applicable Majors</label>
                    <?php
                        $majors = WebinarEvent::get_event_majors($event->event_id);
                    ?>
                    
                    <?php if(count($majors) > 5): ?>
                        <span>Total <?php echo count($majors); ?> Department(s) selected</span>
                    <?php else: ?>
                        <div>
                            <?php foreach($majors as $id => $name): ?>
                            <span id="major_<?php echo $id; ?>" style="margin-right:10px;">
                                <?php 
                                    echo $name.'&nbsp;';
                                    echo CHtml::ajaxlink(
                                        '<span title="delete this Department" class="icon-remove-circle icon-large" style="color: red"></span>',
                                        $this->createUrl('delete_major'),
                                        array('type' => 'POST','data' => array('major' => $id),'success' => '$("span#major_'.$id.'").remove()'),
                                        array('confirm' => 'delete this Department?')
                                    );
                                ?>
                            </span>
                            <?php endforeach; ?>

                        </div>
                    <?php endif; ?>
                </div>
                
            </div>
            <div style="clear:both;"></div>
            
            <?php if($db_product): ?>
            
            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Associated Di account</label>
                    <div>
                        <?php echo $db_product['uni_name']; ?>
                    </div>
                </div>
                
            </div>
            <div style="clear:both;"></div>

            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Di Product</label>
                    <div>
                        <?php echo $db_product['product_name']; ?>
                    </div>
                </div>
                
            </div>
            <div style="clear:both;"></div>
            
            <?php endif; ?>
            

            <div class="block-body border-bottom">
                <div class="form-row">
                    <label class="pull-left span3">Webinar Active</label>
                    <div>
                        <?php echo ($event->is_active == 'Y')?'Yes':'No'; ?>
                    </div>
                </div>
                
            </div>
            <div style="clear:both;"></div>
            
            <?php echo CHtml::button('Save & Continue', array('class' => "btn btn-primary", 'style' => 'margin: 1em 0;', "onclick"=>"window.location.href='". $this->createUrl('index',array('event_type' => $event_type))."';")); ?>
        </div>

    </div>
</div>
</div>