<?php

class ListModel extends CFormModel {

    public $inst_id;
    public $board_id;
    public $passout_year;
    public $student_name;

    public $gender;
    public $full_name;
    public $email;
    public $present_class;
    public $school_name;
    public $school_id;

    public function rules() {
        return [
            ['gender, full_name, present_class, school_name', 'required', 'on'=>'create_profile'],
            ['email', 'checkEmailValid', 'on'=>'create_profile'],
            ['inst_id, board_id, passout_year, student_name, school_id', 'safe'],
        ];
    }

    public function getClassLevels(){

        return array(
            '9p' => '9th',
            '10p' => '10th',
            '11p' => '11th',
            '12p' => '12th',
            '12c' => '12th Completed',
        );
    }

    public function attributeLabels(){

        return array(
            'full_name' => 'Name',
            'present_class' => 'Class',
        );
    }

    public function checkEmailValid($attribute, $params) {

        if(!$this->email){
            $ev = CValidator::createValidator('required', $this, 'email');
            $ev->validate($this);
        }elseif(!filter_var(trim($this->email), FILTER_VALIDATE_EMAIL)){
            $this->addError($attribute, 'Enter a valid email.');
        }else{
            if(LoginMaster::model()->exists('username=:email',array('email'=>$this->email)))
                $this->addError($attribute, 'Email already registered');
        }
    }

    public function createProfile(){

        $transaction = Yii::app()->db->beginTransaction();
        try {

            $loginMasterModel = new LoginMaster;
            $password = DiHelper::genPassword(6);

            $loginMasterData = array(
                'username' => $this->email, 'pass_word' => md5($password),
                'user_type_ref_id' => 1, 'is_active' => 1, 'is_valid'=>'0', 'added_on' => date('Y-m-d H:i:s'));
            $loginMasterModel->setAttributes($loginMasterData, false);
            if(!$loginMasterModel->save(false)){
                throw new CDbException('login saving failed');
            }
            // send login info email
            $registerModel = new StudentRegistration;
            $registerModel->_send_login_details_mail($this->full_name, $loginMasterModel->username, $password);

            $studentSignupModel = new StudentSignup('firstPage');
            $userUNO = $studentSignupModel->generateUserUNO('IN');
            $studentSignupModel->setRbacAssignment('Student', $loginMasterModel->login_id);

            $schoolID = $this->school_id;
            $schoolName = $this->school_name;
            $instituteID = 0;
            if($schoolName && !$schoolID){
                $schoolModel = new LookupSchool;
                $schoolModel->setAttributes(array('school_name'=> $schoolName, 'user_entered' => 1), false);
                $schoolModel->save(false);
                $schoolID = $schoolModel->school_id;
            }
            if(($siModel = TblSiDi::model()->find(sprintf('school_ref_id="%d"', $schoolID))) != null){
                $instituteID = $siModel->inst_id;
            }

            Yii::import('application.modules.student.controllers.CreateProfileController');
            $ProfileController = new CreateProfileController(0);
            $ProfileController->current_class = $this->present_class;
            $class_data = $ProfileController->DynamicPassoutYearAndMonth();
            $userMembershipRefId = $studentSignupModel->getMembershipId($instituteID ? 'SI Student' : 'Guest');
            $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,'label' => 'dashboard',), 1);

            $userMasterModel = new TblUserMaster;
            $userMasterData = array(
                'login_ref_id' => $loginMasterModel->login_id,
                'uno' => $userUNO,
                'first_name'=> $this->full_name,
                'gender'=> $this->gender,
                'membership_ref_id' => $userMembershipRefId['membership_id'],
                'present_class' => $class_data['present_class'],
                'class_status' => $class_data['class_status'],
                'passout_year' => $class_data['passout_year'] ?: date('Y') ,
                'passout_month' => $class_data['passout_month'],
                'profile_status_ref_id' => '3',
                'school_ref_id' => $schoolID ? $schoolID : new CDbExpression('NULL'),
                'redirect_url_ref_id'=> $urlDetails[0]['url_id'],
                'signup_source_ref_id' => '148', // offline profile creation
                'added_on' => date('Y-m-d H:i:s'),
            );
            $userMasterModel->setAttributes($userMasterData, FALSE);
            $userMasterModel->save(false);
            $userModel = TblUserMaster::model()->findByPk($userMasterModel->user_id);
            $userModel->signup_source_ref_id = 148;
            $userModel->save(false);
            StudentPreferredStudyLevel::addStudentPreferences($userMasterModel->user_id, array(5));
            if($instituteID){
                $studentSignupModel->setSiStudents($userMasterModel->user_id, $instituteID);
            }

            $transaction->commit();
        }catch (Exception $e){
            echo $e->getMessage();
            $transaction->rollback();
            exit;
        }
        return $userMasterModel->user_id;

    }

    public function _ce($error){
        return '<div class="holder"><p>'.$error.'</p></div>';
    }

    public function addError($attribute,$error) {
        parent::addError($attribute, $this->_ce($error));
    }

    public function getSchoolList($rowsOnly = false){

        $criteria = new CDbCriteria();
        $criteria->with = [
            'instRef' => ['select' => 'inst_name'],
            'instRef.schoolRef' => ['select' => 'schoolRef.school_name'],
        ];
        $criteria->addCondition("t.f2f_counsellor = '".Yii::app()->user->sub_id."' AND t.is_active='Y'");
        $criteria->addCondition("'".date('Y-m-d')."' BETWEEN t.start_date AND t.end_date");

        if($rowsOnly)
            return OfflineF2fCounsellor::model()->findAll($criteria);

        return new CActiveDataProvider('OfflineF2fCounsellor', [
            'criteria' => $criteria,
            'pagination' => [
                'pageSize' => Yii::app()->getModule('fcfcounsellor')->recordsPerPage,
            ]
        ]);
    }

    public function getStudentsList(){

        $criteria = new CDbCriteria();
        $criteria->select = 't.*';
        $criteria->with = [
            'loginRef' => ['select' => 'username']
        ];
        $criteria->join = " JOIN tbl_si_students tss ON tss.user_ref_id = t.user_id";
        $criteria->join .= " JOIN offline_f2f_counsellor offc ON offc.inst_ref_id = tss.inst_ref_id";

        if($this->inst_id)
            $criteria->addCondition("tss.inst_ref_id = '".$this->inst_id."'");

        if($this->board_id)
            $criteria->addCondition("t.present_board_ref_id = '".$this->board_id."'");

        if($this->passout_year)
            $criteria->addCondition("t.passout_year = '".$this->passout_year."'");

        if($this->student_name){
            //$criteria->compare("t.first_name", $this->student_name, true);
            $criteria->addCondition("(t.first_name LIKE '%".$this->student_name."%' OR t.last_name LIKE '%".$this->student_name."%' OR loginRef.username LIKE '%".$this->student_name."%') ");
        }

        $criteria->addCondition("offc.f2f_counsellor = '".Yii::app()->user->sub_id."' AND offc.is_active='Y'");
        $criteria->addCondition("'".date('Y-m-d')."' BETWEEN offc.start_date AND offc.end_date");
        $criteria->order = "t.first_name, t.last_name";
        $criteria->group = "t.user_id";
        return new CActiveDataProvider('TblUserMaster', [
            'criteria' => $criteria,
            'pagination' => [
                'pageSize' => Yii::app()->getModule('fcfcounsellor')->recordsPerPage,
            ]
        ]);
    }

    public function getBoardsList(){

        $criteria = new CDbCriteria();
        $criteria->select = 't.*';
        $criteria->with = [
            'boardRef' => ['select' => 'board_name']
        ];
        $criteria->join = " JOIN offline_f2f_counsellor offc ON offc.inst_ref_id = t.si_ref_id";
        $criteria->addCondition("offc.f2f_counsellor = '".Yii::app()->user->sub_id."' AND offc.is_active='Y'");
        $criteria->addCondition("'".date('Y-m-d')."' BETWEEN offc.start_date AND offc.end_date");
        $criteria->order = "boardRef.board_name ASC";

        return TblSiBoard::model()->findAll($criteria);
    }

    public function getYearsList(){

        $criteria = new CDbCriteria();
        $criteria->select = 't.passout_year';
        $criteria->join = " JOIN tbl_si_students tss ON tss.user_ref_id = t.user_id";
        $criteria->join .= " JOIN offline_f2f_counsellor offc ON offc.inst_ref_id = tss.inst_ref_id";
        $criteria->addCondition("offc.f2f_counsellor = '".Yii::app()->user->sub_id."' AND offc.is_active='Y' AND passout_year>0");
        //$criteria->addCondition("'".date('Y-m-d')."' BETWEEN offc.start_date AND offc.end_date");
        $criteria->order = "t.passout_year ASC";

        return TblUserMaster::model()->findAll($criteria);
    }

}