<?php

class BaseController extends Controller {

    public $activeLink;
    public $layout = "//layouts/new_grid_inner";

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function accessRules() {
        return array(
            array('allow',
               'expression'=> function(){
                   return Yii::app()->session->get('admin_role_type_id') &&
                   Yii::app()->session->get('admin_role_type_id') == '19';
               }
            ),
            array('deny',  // deny all users
                'users'=>array('*'),
            ),
        );
    }

    public function init(){
        parent::init();
		Yii::app()->theme = 'new_grid_theme';
    }

    public function beforeRender(){

        $cs=Yii::app()->clientScript;
        $cs->registerScriptFile(Yii::app()->baseUrl.'/js/fancybox/latest/jquery.mousewheel-3.0.6.pack.js', CClientScript::POS_END);
        $cs->registerScriptFile(Yii::app()->baseUrl.'/js/fancybox/latest/jquery.fancybox.pack.js', CClientScript::POS_END);
        $cs->registerCssFile(Yii::app()->baseUrl.'/js/fancybox/latest/jquery.fancybox.css');
        return true;
    }
    
}