<?php 
$this->breadcrumbs=array(
    'Di Users'=>array('/diadmin/di/admin'),
    'Manage Pricing'=>array('/diadmin/di/managepricing','id'=>$di_id),
    'Manage Products'=>array('/diadmin/diProduct/admin/di_id/'.$di_id),
    'Manage School Visit Products',
);
?>
<?php if(Yii::app()->user->hasFlash('updated')):?>
<div class="flash-success">
    <?php echo Yii::app()->user->getFlash('updated'); ?>
</div>
<?php endif;?>
<!-- Di Navigation -->
<table width="100%" cellspacing="0" cellpadding="0" border="0">
    <tbody>
    <tr>
        <td width="50%" align="left">
            <h1>Manage School Visit Products</h1>
        </td>
        <td width="50%" align="right">
            <input type="button" onclick="JavaScript:window.location.href='<?php echo Yii::app()->createUrl('/diadmin/diProduct/schoolvisitproduct',array('di_id'=>$di_id)); ?>'" class="button" value="Add New">
        </td>
    </tr>
    </tbody>
</table>
<!--// Di Navigation -->

<a href="<?php echo Yii::app()->createUrl('diadmin/diProduct/admin/di_id/'.$di_id); ?>">Generic Products</a> |
<a href="<?php echo Yii::app()->createUrl('diadmin/diProduct/listBannerProducts/di_id/'.$di_id); ?>">Banner Products</a> |
<strong> &#9660; School Visit Products</strong> |
<a href="<?php echo Yii::app()->createUrl('diadmin/diProduct/listwebinars/di_id/'.$di_id); ?>">Webinar Products</a>

<?php
$Di = Di::model()->with('currencyRef')->findByPk($di_id);
$currency = $Di->currencyRef->currency_code;

$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'di-product-grid',
	'dataProvider'=>$model->search(),
	'columns'=>array(
        array(
            'name'=>'product_name',
        ),
		array(
            'header'=>'Amount Paid',
            'value' => function($data){
                return ($data->amount_paid + 0);
            }
        ),
        array(
            'header'=>'Currency',
            'value' => function($data) use($currency){
                return $currency;
            }
        ),
        array(
            'header'=>'Free Profiles',
            'value' => function($data){
                return $data->free_profile_count;
            }
        ),
        array(
            'header'=>'Discounted <br> Profile Price',
            'value' => function($data){
                return $data->discounted_profile_price;
            }
        ),
        array(
            'header'=>'Start Date',
            'value' => '$data->duration_start_date ? $data->duration_start_date : "N/A"',
        ),
        array(
            'header'=>'End Date',
            'value' => '$data->duration_end_date ? $data->duration_end_date : "N/A"',
        ),
        array(
            'header'=>'Is Active',
            'value'=> function($data){
                return ($data->is_active=="Y") ? "Yes" : "No";
            }
        ),
		array(
			'class'=>'CButtonColumn',
            'template'=>'{update}',//{delete}
            'buttons'=>array(
                'update' => array
                (
                    'url'=>'Yii::app()->createUrl("diadmin/diProduct/schoolvisitproduct/", array("di_id" => $data->di_ref_id, "id"=>$data->di_school_visit_id))',
                ),
            ),
		),
	),
    'htmlOptions'=>array('style'=>'text-align:center'),
)); ?>
