<?php 
$this->breadcrumbs=array(
    'Di Users'=>array('/diadmin/di/admin'),
    'Manage Pricing'=>array('/diadmin/di/managepricing','id'=>$di_id),
    'Manage Products'=>array('/diadmin/diProduct/admin/di_id/'.$di_id),
    'Manage Banner Products',
);
?>
<?php if(Yii::app()->user->hasFlash('updated')):?>
<div class="flash-success">
    <?php echo Yii::app()->user->getFlash('updated'); ?>
</div>
<?php endif;?>
<!-- Di Navigation -->
<table width="100%" cellspacing="0" cellpadding="0" border="0">
    <tbody>
    <tr>
        <td width="50%" align="left">
            <h1>Manage Banner Products</h1>
        </td>
        <td width="50%" align="right">
            <input type="button" onclick="JavaScript:window.location.href='<?php echo Yii::app()->createUrl('/diadmin/diProduct/createbanner',array('di_id'=>$di_id)); ?>'" class="button" value="Add Banner Product">
        </td>
    </tr>
    </tbody>
</table>
<!--// Di Navigation -->

<a href="<?php echo Yii::app()->createUrl('diadmin/diProduct/admin/di_id/'.$di_id); ?>">Generic Products</a> |
<strong> &#9660; Banner Products</strong> |
<a href="<?php echo Yii::app()->createUrl('diadmin/diProduct/listschoolvisits/di_id/'.$di_id); ?>">School Visit Products</a> |
<a href="<?php echo Yii::app()->createUrl('diadmin/diProduct/listwebinars/di_id/'.$di_id); ?>">Webinar Products</a>
<?php
$Di = Di::model()->with('currencyRef')->findByPk($di_id);
$currency = $Di->currencyRef->currency_code;
$campaignAdTypes = $this->campaignAdTypes;

$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'di-product-grid',
	'dataProvider'=>$model->listBannerProducts($di_id),
	'columns'=>array(
		array(
            'name'=>'campaign_name',
            'header'=>'Campaign Name',
        ),
        array(
            'name'=>'campaign_type',
            'header'=>'Campaign Mode',
        ),
        array(
            'name'=>'campaign_ad_type',
            'header'=>'Campaign Mode',
            'value' => function($data) use($campaignAdTypes){
                return $campaignAdTypes[$data->campaign_ad_type];
            }
        ),
        array(
            'header'=>'Price <br> (per Click / Impression)',
            'value' => function($data){
                if($data->campaign_type == 'Impressions'){
                    return $data->price_per_impression;
                }elseif($data->campaign_type == 'Clicks'){
                    return $data->price_per_click;
                }else{
                    return 'N/A';
                }
            }
        ),
        array(
            'header'=>'Quantity <br> (total Clicks / Impressions)',
            'value' => function($data){
                if($data->campaign_type == 'Impressions'){
                    return $data->impressions_limit;
                }elseif($data->campaign_type == 'Clicks'){
                    return $data->clicks_limit;
                }else{
                    return 'N/A';
                }
            }
        ),
        array(
            'name'=>'duration_cost',
            'header'=>'Total Cost',
            'value' => function($data) use($currency){
                $cost = 0;
                if($data->campaign_type == 'Duration'){
                    $cost = $data->duration_cost;
                }elseif($data->campaign_type == 'Impressions'){
                    $cost = $data->price_per_impression * $data->impressions_limit;
                }elseif($data->campaign_type == 'Clicks'){
                    $cost = $data->price_per_click * $data->clicks_limit;
                }
                return $currency .' '.$cost;
            }
        ),
        array(
            'name'=>'duration_start_date',
            'value' => '$data->duration_start_date ? $data->duration_start_date : "N/A"',
        ),
        array(
            'name'=>'duration_end_date',
            'value' => '$data->duration_end_date ? $data->duration_end_date : "N/A"',
        ),
        array(
            'header'=>'Is Active',
            'value'=> function($data){

                if($data->is_active == 'N')
                    return 'No';

                return !DiHelper::isBannerCampaignExpired($data->di_banner_campaign_id, true) ? "Yes" : "No";
            }//'($data->is_active=="Y") ? "Yes" : "No"',
            //'filter'=>false,
        ),
		array(
			'class'=>'CButtonColumn',
            'template'=>'{update}',//{delete}
            'buttons'=>array(
                'update' => array
                (
                    'url'=>'Yii::app()->createUrl("diadmin/diProduct/createbanner/", array("di_id" => $data->di_ref_id, "banner_id"=>$data->di_banner_campaign_id))',
                ),
            ),
		),
	),
    'htmlOptions'=>array('style'=>'text-align:center'),
)); ?>
