<?php 
$this->breadcrumbs=array(
    'Di Accounts'=>array('/diadmin/di/admin'),
    'Manage Pricing'=>array('/diadmin/di/managepricing/','id'=>$di_id),
    'Manage Banner Products'=>array('/diadmin/diProduct/listBannerProducts/di_id/'.$di_id),
    $editMode ? 'Edit Banner Product' : 'Add Banner Product',
);


Yii::import("application.modules.di.models.Searchfilter");
$searchFilter = new Searchfilter;
$departmentList = $searchFilter->getMainDepartmentOptions();
$countryList    = $searchFilter->getCountryOptions();
$scholarshipList = Scholarship::model()->findAll(array('distinct'=>true,'condition' => "is_active = '1'"));
$examList = EntranceExam::model()->findAll(array('distinct'=>true,'condition' => "is_active = '1'"));
$Di = Di::model()->with('currencyRef')->findByPk($di_id);
$currency = $Di->currencyRef->currency_code;


Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/css/token-input-facebook.css");
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/js/jquery.tokeninput.js");
?>
<style>
    div.row{ margin-bottom: 5px !important;}
    div.row label, .LBLradio { width: 225px !important;}
    div.errorMessage { padding-left: 225px !important;}
    ul.token-input-list-facebook { clear: none; !important}
    div.hidden { display: none }
</style>
<h1><?php echo $editMode ? 'Edit Banner Product' : 'Add Banner Product'; ?></h1>
<div class="di_form">
    <div class="form">

        <?php $form=$this->beginWidget('CActiveForm', array(
        'id'=>'settings-form',
        'enableClientValidation'=>true,
        'enableAjaxValidation'=>true,
        'clientOptions'=>array(
			'validateOnSubmit' => true,
		),
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
        )); ?>

        <p class="note">Fields with <span class="required">*</span> are required.
            <span class="green">( <?php echo 'Available cash balance : '.number_format($model->getAvailableCash(), 2).' '.$currency; ?> )</span>
        </p>

        <div class="row">&nbsp;</div>
        <div class="row">
            <?php echo $form->labelEx($model,'campaign_name'); ?>
            <?php echo $form->textField($model,'campaign_name'); ?>
            <?php echo $form->error($model,'campaign_name'); ?>
        </div>

        <div class="row">&nbsp;</div>

        <div class="row">
            <?php
            echo $form->labelEx($model,'campaign_ad_type');
            echo $form->dropDownList($model,'campaign_ad_type', $this->campaignAdTypes, array('empty' => 'Choose Type', 'class' => 'select grid_3 campaignAdType'));
            echo $form->error($model,'campaign_ad_type');
            ?>
        </div>

        <div class="row">&nbsp;</div>

        <div class="row">
            <?php
            echo $form->labelEx($model,'campaign_type');
            echo $form->dropDownList($model,'campaign_type', $campaign_modes, array('empty' => 'Choose Mode', 'class' => 'select grid_3 campaignMode','disabled'=>($editMode)? true : false));
            echo $form->error($model,'campaign_type');
            ?>
        </div>

        <div class="dynamicFields Duration <?php echo $model->campaign_type == 'Duration' ? '' : 'hidden' ?>">

            <div class="row">&nbsp;</div>
            <div class="row">
                <?php echo CHtml::label($model->getAttributeLabel('duration_cost'),'duration_cost', array('required' => true)); ?>
                <?php echo $form->textField($model,'duration_cost', array('disabled'=>($editMode)? true : false, 'autocomplete' => 'off')); ?>
                <?php echo $currency; ?>
                <?php echo $form->error($model,'duration_cost'); ?>
            </div>

            <div class="row">&nbsp;</div>
            <div class="row">
                <?php echo CHtml::label($model->getAttributeLabel('duration_start_date'),'duration_start_date', array('required' => true)); ?>
                <?php $this->widget('zii.widgets.jui.CJuiDatePicker', array(
                'attribute'=>'duration_start_date',
                'model'=>$model,
                'value'=>$model->duration_start_date,
                'options'=>array('dateFormat'=>'yy-mm-dd'),
                'htmlOptions'=>array('style'=>'height:20px;', 'disabled'=>($editMode)? true : false,),
                )); ?>
                <?php echo $form->error($model,'duration_start_date'); ?>
            </div>

            <div class="row">&nbsp;</div>
            <div class="row">
                <?php echo CHtml::label($model->getAttributeLabel('duration_end_date'),'duration_end_date', array('required' => true)); ?>
                <?php $this->widget('zii.widgets.jui.CJuiDatePicker', array(
                'attribute'=>'duration_end_date',
                'model'=>$model,
                'value'=>$model->duration_end_date,
                'options'=>array('dateFormat'=>'yy-mm-dd'),
                'htmlOptions'=>array('style'=>'height:20px;', 'disabled'=>($editMode)? true : false,),
                )); ?>

                <?php echo $form->error($model,'duration_end_date'); ?>
            </div>

        </div>

        <div class="dynamicFields Impressions <?php echo $model->campaign_type == 'Impressions' ? '' : 'hidden' ?>">

            <div class="row">&nbsp;</div>
            <div class="row">
                <?php echo CHtml::label($model->getAttributeLabel('price_per_impression'),'price_per_impression', array('required' => true)); ?>
                <?php echo $form->textField($model,'price_per_impression', array('disabled'=>($editMode)? true : false, 'autocomplete' => 'off')); ?> <?php echo $currency; ?> <span class="totalCost" style="color: #0000ff"></span>
                <?php echo $form->error($model,'price_per_impression'); ?>
            </div>

            <div class="row">&nbsp;</div>
            <div class="row">
                <?php echo CHtml::label($model->getAttributeLabel('impressions_limit'),'impressions_limit', array('required' => true)); ?>
                <?php echo $form->textField($model,'impressions_limit', array('disabled'=>($editMode)? true : false, 'autocomplete' => 'off')); ?>
                <?php echo $form->error($model,'impressions_limit'); ?>
            </div>

        </div>

        <div class="dynamicFields Clicks <?php echo $model->campaign_type == 'Clicks' ? '' : 'hidden' ?>">

            <div class="row">&nbsp;</div>
            <div class="row">
                <?php echo CHtml::label($model->getAttributeLabel('price_per_click'),'price_per_click', array('required' => true)); ?>
                <?php echo $form->textField($model,'price_per_click', array('disabled'=>($editMode)? true : false, 'autocomplete' => 'off')); ?> <?php echo $currency; ?> <span class="totalCost" style="color: #0000ff"></span>
                <?php echo $form->error($model,'price_per_click'); ?>
            </div>

            <div class="row">&nbsp;</div>
            <div class="row">
                <?php echo CHtml::label($model->getAttributeLabel('clicks_limit'),'clicks_limit', array('required' => true)); ?>
                <?php echo $form->textField($model,'clicks_limit', array('disabled'=>($editMode)? true : false, 'autocomplete' => 'off')); ?>
                <?php echo $form->error($model,'clicks_limit'); ?>
            </div>

        </div>

        <div class="row">&nbsp;</div>
        <div class="row-radio">
            <?php echo $form->labelEx($model,'is_active',array('class'=>'LBLradio')); ?>
            <?php $model->is_active	=	(!isset($model->is_active)) ? 'Y' : $model->is_active;
            echo $form->radiobuttonList($model,'is_active',array('Y'=>'Yes','N'=>'No'),array('separator'=>' ')); ?>
            <?php echo $form->error($model,'is_active'); ?>
        </div>

        <div class="forBannerAd <?php echo $model->campaign_ad_type == '2' ? 'hidden' : '' ?>">
            <div class="row">&nbsp;</div>
            <div class="row">
                <?php
                echo $form->labelEx($model,'banner_img_dashboard');
                echo $form->fileField($model,'banner_img_dashboard');
                if($editMode && $model->banner_img_dashboard){ ?>
                    <a class="pimg" href="<?php echo Yii::app()->baseUrl.'/uploads/di_baner_image/'.$model->banner_img_dashboard; ?>" target="_blank"><img style="float:left;" src="<?php echo Yii::app()->baseUrl.'/uploads/di_baner_image/'.$model->banner_img_dashboard; ?>" width="100" height="75"/></a>
                <?php }
                echo $form->error($model,'banner_img_dashboard'); ?>
            </div>

            <div class="row">&nbsp;</div>
            <div class="row">
                <?php
                echo $form->labelEx($model,'banner_img_generic');
                echo $form->fileField($model,'banner_img_generic');
                if($editMode && $model->banner_img_generic){ ?>
                    <a class="pimg" href="<?php echo Yii::app()->baseUrl.'/uploads/di_baner_image/'.$model->banner_img_generic; ?>" target="_blank"><img style="float:left;" src="<?php echo Yii::app()->baseUrl.'/uploads/di_baner_image/'.$model->banner_img_generic; ?>" width="100" height="75"/></a>
                <?php }
                echo $form->error($model,'banner_img_generic'); ?>
            </div>
        </div>

        <div class="row">&nbsp;</div>
        <fieldset style="width: 700px;">
        <legend>Target Criteria</legend><p></p>

        <div class="row">
            <?php
            echo $form->labelEx($model,'target_countries');
            echo $form->textField($model,'target_countries', array('class' => 'target_countries'));
            echo $form->error($model,'target_countries');
            ?>
        </div>

        <div class="row">&nbsp;</div>
        <div class="row">
            <?php
            echo $form->labelEx($model,'target_departments');
            echo $form->textField($model,'target_departments', array('class' => 'target_departments'));
            echo $form->error($model,'target_departments');
            ?>
        </div>

        <div class="forBannerAd <?php echo $model->campaign_ad_type == '2' ? 'hidden' : '' ?>">
            <div class="row">&nbsp;</div>
            <div class="row">
                <?php
                echo $form->labelEx($model,'target_tests');
                echo $form->textField($model,'target_tests', array('class' => 'target_tests'));
                echo $form->error($model,'target_tests');
                ?>
            </div>

            <div class="row">&nbsp;</div>
            <div class="row">
                <?php
                echo $form->labelEx($model,'target_scholarships');
                echo $form->textField($model,'target_scholarships', array('class' => 'target_scholarships'));
                echo $form->error($model,'target_scholarships');
                ?>
            </div>
        </div>

        <div class="row">&nbsp;</div>
        <div class="row forTextAd <?php echo $model->campaign_ad_type != '1' ? '' : 'hidden' ?>">
            <?php
            echo $form->labelEx($model,'target_keywords');
            if($editMode && ($targetKeywords = $model->diBannerCampaignTargetKeywords) != null) {
                $options = array(); foreach($targetKeywords as $targetKeyword){ $options[] = $targetKeyword->keyword; }
                $model->target_keywords = implode(',', $options);
            }
            echo $form->textArea($model,'target_keywords', array('rows'=>5, 'cols'=>55));
            echo $form->error($model,'target_keywords');
            ?>
        </div>
        </fieldset>

        <div class="row">&nbsp;</div>
        <div class="row buttons">
            <label>&nbsp;</label>
            <input type="submit" class="button" value="Save" />
        </div>

        <?php $this->endWidget(); ?>

    </div><!-- form -->
</div>
<script>
    $(function(){

        $('body').on('focus', 'input, select, file', function(evt){
            $(this).next('div.errorMessage').hide();
            var target = $(evt.target);
            if (target.parents('div.dynamicFields').length)
                $('#DiBannerCampaign_campaign_type_em_').hide();
        });

        $('#DiBannerCampaign_price_per_impression, #DiBannerCampaign_impressions_limit').on('keyup', function(){
            var per_impression_cost = $('#DiBannerCampaign_price_per_impression').val() || 0;
            var total_impressions   = $('#DiBannerCampaign_impressions_limit').val() || 0;
            var sHtml = ' (Total Cost : '+per_impression_cost+' X '+total_impressions+' = '+(per_impression_cost * total_impressions);
            $(this).closest('div.dynamicFields').find('span.totalCost').html(sHtml + ' <?php echo $currency; ?>)');
        });

        $('#DiBannerCampaign_price_per_click, #DiBannerCampaign_clicks_limit').on('keyup', function(){
            var per_click_cost = $('#DiBannerCampaign_price_per_click').val() || 0;
            var total_clicks   = $('#DiBannerCampaign_clicks_limit').val() || 0;
            var sHtml = ' (Total Cost : '+per_click_cost+' X '+total_clicks+' = '+(per_click_cost * total_clicks);
            $(this).closest('div.dynamicFields').find('span.totalCost').html(sHtml + ' <?php echo $currency; ?>)');
        });

        $('body').on('change', '.campaignMode', function(){
            var mode = $(this).val() || 0;
            $('div.dynamicFields').not("."+mode).hide();
            $('div.'+mode).show();
        });

        $('body').on('change', '.campaignAdType', function(){
            var type = $(this).val() || 3;
            if( type == 2){
                $('div.forBannerAd').hide();
                $('div.forTextAd').show();
            }else if( type == 3){
                $('div.forBannerAd, div.forTextAd').show();
            }else{
                $('div.forBannerAd').show();
                $('div.forTextAd').hide();
            }
        });

        $(".target_countries").tokenInput([
        <?php if($countryList) {
            foreach($countryList as $countryId => $countryName){
                echo "{id: ".$countryId.", name: '".$countryName."'},";
            }
        } ?>
        ], {
            theme: "facebook",
            placeholder: 'COUNTRIES TO TARGET',
            preventDuplicates: true,
            hintText: "Type countries to target",
            prePopulate: [
            <?php
            if($editMode && ($targetCountries = $model->diBannerCampaignTargetCountries) != null) {
                foreach($targetCountries as $targetCountry){
                    echo "{id: ".$targetCountry->country_ref_id.", name: '".$countryList[$targetCountry->country_ref_id]."'},";
                }
            } ?>
            ]

        });

        $(".target_departments").tokenInput([
        <?php if($departmentList) {
            foreach($departmentList as $depId => $deptName){
                echo "{id: ".$depId.", name: '".$deptName."'},";
            }
        } ?>
        ], {
            theme: "facebook",
            placeholder: 'DEPARTMENTS TO TARGET',
            preventDuplicates: true,
            hintText: "Type majors to target",
            prePopulate: [
            <?php
            if($editMode && ($targetDepts = $model->diBannerCampaignTargetDepartments) != null) {
                foreach($targetDepts as $targetDept){
                    echo "{id: ".$targetDept->dept_ref_id.", name: '".$departmentList[$targetDept->dept_ref_id]."'},";
                }
            } ?>
            ]
        });

        $(".target_scholarships").tokenInput([
        <?php if($scholarshipList) { $tempScholarshipList = array();
            foreach($scholarshipList as $scholarship){
                $tempScholarshipList[$scholarship->scholarship_id] = addslashes($scholarship->scholarship_name);
                echo "{id: ".$scholarship->scholarship_id.", name: '".addslashes($scholarship->scholarship_name)."'},";
            }
        } ?>
        ], {
            theme: "facebook",
            placeholder: 'SCHOLARSHIPS TO TARGET',
            preventDuplicates: true,
            hintText: "Type scholarships to target",
            prePopulate: [
            <?php
            if($editMode && ($targetScholarships = $model->diBannerCampaignTargetScholorships) != null) {
                foreach($targetScholarships as $targetScholarship){
                    echo "{id: ".$targetScholarship->scholorship_ref_id.", name: '".$tempScholarshipList[$targetScholarship->scholorship_ref_id]."'},";
                }
            } ?>
            ]
        });

        $(".target_tests").tokenInput([
        <?php if($examList) { $tempExamList = array();
            foreach($examList as $exam){
                $tempExamList[$exam->entrance_id] = addslashes($exam->entrance_short_name);
                echo "{id: ".$exam->entrance_id.", name: '".addslashes($exam->entrance_short_name)."'},";
            }
        } ?>
        ], {
            theme: "facebook",
            placeholder: 'TESTS TO TARGET',
            preventDuplicates: true,
            hintText: "Type tests to target",
            prePopulate: [
            <?php
            if($editMode && ($targetExams = $model->diBannerCampaignTargetExams) != null) {
                foreach($targetExams as $targetExam){
                    echo "{id: ".$targetExam->exam_ref_id.", name: '".$tempExamList[$targetExam->exam_ref_id]."'},";
                }
            } ?>
            ]
        });
    })
</script>