<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiCashDebit is autogenerate by UniModel generator
 *
 * This is the model class for table "di_cash_debit".
 *
 * The followings are the available columns in table 'di_cash_debit':
 * @property string $di_cash_debit_id
 * @property integer $di_ref_id
 * @property string $di_product_ref_id
 * @property string $user_ref_id
 * @property integer $campaign_ref_id
 * @property integer $banner_campaign_ref_id
 * @property integer $school_visit_product_ref_id
 * @property integer $webinar_product_ref_id
 * @property integer $quantity
 * @property string $subtotal
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property DiWebinarProduct $webinarProductRef
 * @property Di $diRef
 * @property DiEmailCampaign $campaignRef
 * @property LoginMaster $addedBy
 * @property DiBannerCampaign $bannerCampaignRef
 * @property DiProduct $diProductRef
 * @property DiSchoolVisitProduct $schoolVisitProductRef
 * @property TblUserMaster $userRef
 */
class BaseDiCashDebit extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiCashDebit the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_cash_debit';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_ref_id, quantity, subtotal, added_on, added_by', 'required'),
			array('di_ref_id, campaign_ref_id, banner_campaign_ref_id, school_visit_product_ref_id, webinar_product_ref_id, quantity', 'numerical', 'integerOnly'=>true),
			array('di_product_ref_id, user_ref_id, subtotal, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_cash_debit_id, di_ref_id, di_product_ref_id, user_ref_id, campaign_ref_id, banner_campaign_ref_id, school_visit_product_ref_id, webinar_product_ref_id, quantity, subtotal, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'webinarProductRef' => array(self::BELONGS_TO, 'DiWebinarProduct', 'webinar_product_ref_id'),
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'campaignRef' => array(self::BELONGS_TO, 'DiEmailCampaign', 'campaign_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'bannerCampaignRef' => array(self::BELONGS_TO, 'DiBannerCampaign', 'banner_campaign_ref_id'),
			'diProductRef' => array(self::BELONGS_TO, 'DiProduct', 'di_product_ref_id'),
			'schoolVisitProductRef' => array(self::BELONGS_TO, 'DiSchoolVisitProduct', 'school_visit_product_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_cash_debit_id' => 'Di Cash Debit',
			'di_ref_id' => 'Di Ref',
			'di_product_ref_id' => 'Di Product Ref',
			'user_ref_id' => 'User Ref',
			'campaign_ref_id' => 'Campaign Ref',
			'banner_campaign_ref_id' => 'Banner Campaign Ref',
			'school_visit_product_ref_id' => 'School Visit Product Ref',
			'webinar_product_ref_id' => 'Webinar Product Ref',
			'quantity' => 'Quantity',
			'subtotal' => 'Subtotal',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_cash_debit_id',$this->di_cash_debit_id,true);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('di_product_ref_id',$this->di_product_ref_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('campaign_ref_id',$this->campaign_ref_id);
		$criteria->compare('banner_campaign_ref_id',$this->banner_campaign_ref_id);
		$criteria->compare('school_visit_product_ref_id',$this->school_visit_product_ref_id);
		$criteria->compare('webinar_product_ref_id',$this->webinar_product_ref_id);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('subtotal',$this->subtotal,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}