<?php 

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiCashCredit is autogenerate by UniModel generator
 *
 * This is the model class for table "di_cash_credit".
 *
 * The followings are the available columns in table 'di_cash_credit':
 * @property string $di_cash_credit_id
 * @property integer $di_ref_id
 * @property integer $currency_ref_id
 * @property string $amount
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property Di $diRef
 * @property LoginMaster $addedBy
 * @property LookupCurrency $currencyRef
 * @property LoginMaster $modifiedBy
 */
class BaseDiCashCredit extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiCashCredit the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_cash_credit';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_ref_id, currency_ref_id, amount, added_on, added_by', 'required'),
			array('di_ref_id, currency_ref_id', 'numerical', 'integerOnly'=>true),
			array('amount, added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_cash_credit_id, di_ref_id, currency_ref_id, amount, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_cash_credit_id' => 'Di Cash Credit',
			'di_ref_id' => 'Di Ref',
			'currency_ref_id' => 'Currency Ref',
			'amount' => 'Amount',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_cash_credit_id',$this->di_cash_credit_id,true);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}