<?php
 
/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.modules.diadmin.models.base.BaseDiUser');

class DiUser extends BaseDiUser
{
	//spublic $TempFirstName,$TempLastName,$TempOfficeNumber,$TempMobileNumber	=	"";
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
  
  
  public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_type', 'required'),
			array('di_ref_id, is_active, is_login_email_sent', 'numerical', 'integerOnly'=>true),
			array('login_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('user_type', 'length', 'max'=>9),
			array('first_name, last_name', 'length', 'max'=>45),
			//array('first_name, last_name', 'match', 'pattern' => '/^[a-zA-Z\s]+$/', 'message' => '{attribute} can only contain word characters'),			
			array('office_number, mobile_number', 'length', 'max'=>20),
			array('office_number, mobile_number', 'length', 'min'=>10,'on'=>'create'),
            //Validate a telephone number: a + at the beginning, then only numbers or spaces
            //array('office_number', 'match', 'pattern'=>'/^([+][0-9 ]+)$/','message'=>'Invalid office number: allowed + at the beginning, then only numbers or spaces' ),
			
			//array('designation,profile_picture,sms_subscribe,email_frequency,signature,timezone_ref_id,title', 'required','on'=>'profileupdate'),
			
			
            //array('mobile_number', 'match', 'pattern'=>'/^([+][0-9 ]+)$/','message'=>'Invalid mobile number: allowed + at the beginning, then only numbers or spaces' ),

			array('modified_on,timezone_ref_id', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_id, login_ref_id, di_ref_id, user_type, first_name, last_name, office_number, mobile_number, is_active, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}
	
    public function searchModerator()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $di_id = Yii::app()->getRequest()->getQuery('di_id');

        if(isset($di_id) && (Yii::app()->controller->module->id=="diadmin") ){
            $di_ref_id = $di_id;
        } else{
            $di_ref_id = Yii::app()->user->di_id;
        }

        $criteria=new CDbCriteria;

        $criteria->compare('di_user_id',$this->di_user_id);
        $criteria->compare('login_ref_id',$this->login_ref_id,true);

        $criteria->compare('di_ref_id',$di_ref_id);
        //$criteria->compare('di_ref_id',$this->di_ref_id);

        $criteria->compare('user_type','Moderator',true);
        //$criteria->compare('user_type',$this->user_type,true);

        $criteria->compare('first_name',$this->first_name,true);
        $criteria->compare('last_name',$this->last_name,true);
        $criteria->compare('office_number',$this->office_number,true);
        $criteria->compare('mobile_number',$this->mobile_number,true);
        $criteria->compare('is_active',$this->is_active);
        $criteria->compare('added_on',$this->added_on,true);

        //$criteria->compare('added_by',Yii::app()->user->id);

        $criteria->compare('modified_on',$this->modified_on,true);
        $criteria->compare('modified_by',$this->modified_by,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }	

    /*
     *  magic function calling n DiHelperAnil.php file to concatenate two fields used in CHtml::listData
     *
     */

    public function getConcatened()
    {
        return $this->first_name.' '.$this->last_name;
    }
    
    public static function getDiRefIdByLoginId($loginId)
    {
        $criteria = new CDbCriteria;
        $criteria->select = 'di_ref_id';
        $criteria->addCondition("login_ref_id = '".$loginId."'", "AND");
        $res = self::model()->find($criteria);
        return $res['di_ref_id'];	
    }

    public static function getDiuserName($diUserId)
    {
        $criteria = new CDbCriteria;
        $criteria->select = 'first_name,last_name';
        $criteria->addCondition("di_user_id = '".$diUserId."'", "AND");
        $res = self::model()->find($criteria);
        return $res['first_name']. ' '.$res['last_name'];
    }

    public function attributeLabels() {

        return CMap::mergeArray(parent::attributeLabels(), array(
            'email_frequency_weekly' => 'Weekly Summary Email',
            'email_frequency_daily' => 'Daily Student Email',
        ));
    }
}