<?php
 
class DiProductController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/admin';
    public $campaignAdTypes = array('2' => 'Featured AD', '1' => 'Banner AD', '3' => 'Banner & Featured AD');

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'rights', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','admin','delete'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

    public function init(){
        parent::init();
        $cs = Yii::app()->clientScript;
        $cs->scriptMap['main.js'] = false;
    }

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
        $di_id = Yii::app()->getRequest()->getQuery('di_id');

		$this->render('view',array(
			'model'=>$this->loadModel($id),
            'di_id'=>$di_id,
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
        $di_id = Yii::app()->getRequest()->getQuery('di_id');

        // Load Di data
        $Di = Di::model()->with('currencyRef')->findByPk($di_id);

		$model=new DiProduct;

        // For Display Currency in Text box
        $model->currency_ref_id = $Di->currencyRef->currency_code;

        // Set default  starting date
        $model->start_date 	= date("Y-m-d");
		$model->end_date 	= strtotime(date("Y-m-d", strtotime($model->start_date)) . "+30 day");
		$model->end_date 	= date("Y-m-d",$model->end_date);

        if(Yii::app()->request->isAjaxRequest){
            $model->currency_ref_id = $Di->currencyRef->currency_id;
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

		if(isset($_POST['DiProduct']))
		{
			$model->attributes  = $_POST['DiProduct'];
            $model->di_ref_id   = $Di->di_id;
            $model->added_on    = new CDbExpression('NOW()');
            $model->added_by    = Yii::app()->user->id;
            // For Storing Currency in Text box
            $model->currency_ref_id = $Di->currencyRef->currency_id;

            if($model->validate()){
                $model->save();
                Yii::app()->user->setFlash('updated',"Data Created successfully.");

                // After save show admin page of products for specific Di
				$this->redirect(array('admin','di_id'=>$di_id));
            } else{
                // For Display Currency in Text box
                $model->currency_ref_id = $Di->currencyRef->currency_code;
            }
		}

		$this->render('create',array(
			'model'=>$model,
            'di_id'=> $di_id,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{

		$model  = $this->loadModel($id);

        // For Display Currency in Text box
        $model->currency_ref_id = $model->currencyRef->currency_code;

        if(Yii::app()->request->isAjaxRequest){
            $model->currency_ref_id = $model->currencyRef->currency_id;
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if(isset($_POST['DiProduct']))
		{
			$model->attributes=$_POST['DiProduct'];
            // For Storing Currency in Text box
            $model->currency_ref_id = $model->currencyRef->currency_id;

            if($model->validate()){
                $model->save();
                Yii::app()->user->setFlash('updated',"Data updated successfully.");
                // After save show admin page of products for specific Di
                $this->redirect(array('admin','di_id'=>$model->di_ref_id));
            } else{
                // For Display Currency in Text box
                $model->currency_ref_id = $model->currencyRef->currency_code;
            }

		}

		$this->render('update',array(
			'model'=>$model,
            'di_id'=>$model->di_ref_id,
		));
	}

	/*
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
        $di_id = Yii::app()->getRequest()->getQuery('di_id');

		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin','di_id'=>$di_id));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('DiProduct');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
        $di_id = Yii::app()->getRequest()->getQuery('di_id');

		$model=new DiProduct('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['DiProduct']))
			$model->attributes=$_GET['DiProduct'];

		$this->render('admin',array(
			'model'=>$model,
            'di_id'=>$di_id,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=DiProduct::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='di-product-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

    public function actionCreateBanner() {

        $campaignModes = array('Duration' => 'Duration', 'Impressions' => 'Impressions', 'Clicks' => 'Clicks');
        $diID = Yii::app()->request->getParam('di_id', false);
        $bannerID = Yii::app()->request->getParam('banner_id', false);

        $editMode = false;
        $model = DiBannerCampaign::model()->find("di_banner_campaign_id='".$bannerID."' AND di_ref_id ='".$diID."'");
        if(!$model){
            $model = new DiBannerCampaign;
            $model->di_ref_id = $diID;
            // Set default  start and end dates
            $model->duration_start_date = date("Y-m-d");
            $model->duration_end_date 	= strtotime(date("Y-m-d", strtotime($model->duration_start_date)) . "+90 day");
            $model->duration_end_date 	= date("Y-m-d",$model->duration_end_date);

            $model->added_by  = Yii::app()->user->id;
            $model->added_on  = date('Y-m-d H:i:s');
            $model->clicks_count = $model->impressions_count = 0;
        }else{
            $editMode = true;
            $model->modified_by  = Yii::app()->user->id;
            $model->modified_on  = date('Y-m-d H:i:s');
        }

        if($_POST['DiBannerCampaign']['campaign_ad_type'] != 2){
            if(!$model->banner_img_dashboard || !$model->banner_img_generic)
                $model->setScenario('BannerNTextAd');
        }


        if(Yii::app()->request->isAjaxRequest){
            $rAttributes = $model->getRequiredAttributes();
            // validate all except file fields in ajax
            echo CActiveForm::validate($model, array_diff($rAttributes, array('banner_img_dashboard', 'banner_img_generic')));
            Yii::app()->end();
        }

        if(isset($_POST['DiBannerCampaign'])){

            $model->attributes = $_POST['DiBannerCampaign'];
            $uploadPath = Yii::app()->basePath.'/../uploads/di_baner_image/';

            if(($dashboardImage = CUploadedFile::getInstance($model,'banner_img_dashboard')) != null){
                $model->banner_img_dashboard = str_replace(' ', '', rand(0,9999) . '-'. $dashboardImage);
                $dashboardImage->saveAs($uploadPath . $model->banner_img_dashboard);
            }
            if(($genericBanner = CUploadedFile::getInstance($model,'banner_img_generic')) != null){
                $model->banner_img_generic = str_replace(' ', '', rand(0,9999) . '-'. $genericBanner);
                $genericBanner->saveAs($uploadPath . $model->banner_img_generic);
            }

            if($model->validate() && $model->hasCashForCampaign() && $model->save()){

                $bCampaignID = $model->di_banner_campaign_id;

                if(!$editMode)
                    $model->deductAmountForCampaign($bCampaignID, $model->getAmountToDeduct());

                $model->SaveTargetCriteriaInfo($bCampaignID);
                Yii::app()->user->setFlash('updated',"Banner Product ".($editMode ? 'Updated' : 'Created')." successfully.");
                $this->redirect(array('listBannerProducts','di_id'=>$diID));

            }
        }

        $this->render('create_banner',array(
            'model'=>$model,
            'campaign_modes' => $campaignModes,
            'di_id'=> $diID,
            'editMode' => $editMode,
        ));
    }

    public function actionListBannerProducts(){

        $diID = Yii::app()->getRequest()->getParam('di_id', 0);

        $model=new DiBannerCampaign;
        $this->render('list_banner_products',array(
            'model'=>$model,
            'di_id'=>$diID,
        ));
    }


    public function actionListSchoolVisits(){

        $diID = Yii::app()->getRequest()->getParam('di_id', 0);

        $model=new DiSchoolVisitProduct('search');
        $model->di_ref_id = $diID;
        if(isset($_GET['DiSchoolVisitProduct']))
            $model->attributes = $_GET['DiSchoolVisitProduct'];

        $this->render('list_school_visit_products',array(
            'model'=>$model,
            'di_id'=>$diID,
        ));
    }

    public function actionSchoolVisitProduct() {

        $ID = Yii::app()->request->getParam('id', false);
        $diID = Yii::app()->request->getParam('di_id', false);
        $editMode = false;
        $model = DiSchoolVisitProduct::model()->find("di_school_visit_id='".$ID."' AND di_ref_id ='".$diID."'");
        if(!$model){
            $model = new DiSchoolVisitProduct;
            $model->di_ref_id = $diID;
            $model->added_by  = Yii::app()->user->id;
            $model->added_on  = date('Y-m-d H:i:s');
        }else{
            $editMode = true;
            $model->modified_by  = Yii::app()->user->id;
            $model->modified_on  = date('Y-m-d H:i:s');
        }

        if(Yii::app()->request->isAjaxRequest){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if(isset($_POST['DiSchoolVisitProduct'])){

            $model->attributes = $_POST['DiSchoolVisitProduct'];
            if($model->validate() && $model->save()){
                Yii::app()->user->setFlash('updated',"School Visit Product ".($editMode ? 'Updated' : 'Created')." successfully.");
                $this->redirect(array('ListSchoolVisits','di_id'=>$diID));

            }
        }

        $this->render('school_visit_product',array(
            'model'=>$model,
            'di_id'=> $diID,
            'editMode' => $editMode,
        ));
    }


    public function actionListWebinars(){

        $diID = Yii::app()->getRequest()->getParam('di_id', 0);

        $model=new DiWebinarProduct('search');
        $model->di_ref_id = $diID;
        if(isset($_GET['DiWebinarProduct']))
            $model->attributes = $_GET['DiWebinarProduct'];

        $this->render('list_webinar_products',array(
            'model'=>$model,
            'di_id'=>$diID,
        ));
    }

    public function actionWebinarProduct() {

        $ID = Yii::app()->request->getParam('id', false);
        $diID = Yii::app()->request->getParam('di_id', false);
        $editMode = false;
        $model = DiWebinarProduct::model()->find("di_webinar_product_id='".$ID."' AND di_ref_id ='".$diID."'");
        if(!$model){
            $model = new DiWebinarProduct;
            $model->di_ref_id = $diID;
            $model->added_by  = Yii::app()->user->id;
            $model->added_on  = date('Y-m-d H:i:s');
        }else{
            $editMode = true;
            $model->modified_by  = Yii::app()->user->id;
            $model->modified_on  = date('Y-m-d H:i:s');
        }

        if(Yii::app()->request->isAjaxRequest){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if(isset($_POST['DiWebinarProduct'])){

            $model->attributes = $_POST['DiWebinarProduct'];
            if($model->validate() && $model->save()){
                Yii::app()->user->setFlash('updated',"Webinar Product ".($editMode ? 'Updated' : 'Created')." successfully.");
                $this->redirect(array('ListWebinars','di_id'=>$diID));

            }
        }

        $this->render('webinar_product',array(
            'model'=>$model,
            'di_id'=> $diID,
            'editMode' => $editMode,
        ));
    }
}
