<?php 

class DiCashCreditController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/admin';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'rights', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','admin','delete'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
        $model  =   new DiCashCredit;
        $di_id  =   Yii::app()->getRequest()->getQuery('di_id');
        $Di     =   Di::model()->with('currencyRef')->findByPk($di_id);

		// Uncomment the following line if AJAX validation is needed
		$this->performAjaxValidation($model);
        $model->currency_ref_id = $Di->currencyRef->currency_code;

        if(isset($_POST['DiCashCredit']))
		{
			$model->attributes          =   $_POST['DiCashCredit'];
            $model->currency_ref_id     =   $Di->currencyRef->currency_id;
            $model->added_on            =   new CDbExpression('NOW()');
            if($model->save())

            $diName     =   $Di->diUsers[0]->first_name." ".$Di->diUsers[0]->last_name;
            $data     =   array(
                                'name'=>$diName,
                                'currency'=>$Di->currencyRef->currency_code,
                                'amount'=>$model->amount,
                            );
            $msg        =   $this->renderPartial('/mailformat/CashCredit', array('data'=>$data),true,false);
            $params = array();
            $params['EmailMessage']['subject']      =   'Congratulations! Amount credited to your account';
            $params['EmailMessage']['body']         =   $msg;
            $params['EmailMessage']['type']         =   'DIRegistration';
            $params['EmailMessage']['siteUrl']      =   '';
            $params['EmailMessage']['cc']           =   '';
            $params['EmailMessage']['toName']       =   $diName;
            $params['EmailMessage']['toEmail']      =   $Di->diUsers[0]->loginRef->username;
            $params['EmailMessage']['apiKey']       =   Yii::app()->params['emailCron']['curlKey'];

            $_POST = $params;
            Yii::app()->user->setState('$_POST', $this->createUrl('sms/email/addMessage'));
            //$status = Yii::app()->runController("sms/email/addMessage");
            Yii::app()->user->setFlash('updated','Success! Cash credits added to DI account');
            $this->redirect(array('admin','di_id'=>$model->di_ref_id));
        }

		$this->render('create',array(
			'model'=>$model,
			'di_id'=>$di_id,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		$this->performAjaxValidation($model);

		if(isset($_POST['DiCashCredit']))
		{

			$model->attributes  =   $_POST['DiCashCredit'];
			$model->modified_on =   new CDbExpression('NOW()');
			$model->modified_by =   Yii::app()->user->id;
            if($model->save())
                Yii::app()->user->setFlash('updated','Success! Cash credits added to DI account');
				$this->redirect(array('admin','di_id'=>$model->di_ref_id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/*
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('DiCashCredit');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
        $di_id  =   Yii::app()->getRequest()->getQuery('di_id');
		$model  =   new DiCashCredit('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['DiCashCredit']))
			$model->attributes=$_GET['DiCashCredit'];

		$this->render('admin',array(
			'model'=>$model,
			'di_id'=>$di_id,
		));
	}

	/*
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=DiCashCredit::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='di-cash-credit-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
