<?php
class SendOfferWidget extends CWidget{

	public $isBought = 0; // check if related student profile bought or not
	
	public $heading = "";
	public $type = ""; // it will be (hotlead|alertmatch|hotleadShortlist|alertmatchShortlist)
	public $listId = ""; // It will be related to above type;
	public $studentId = "";
	
	public $diUserLoginId = "";
	public $diUserId = "";
	public $diUserName = "";
	public $diId = "";
	public $diCurrencyId = "";
	public $universityId = "";
	public $universityCountryId = "";
	
	public $scholarshipArr = array();
	
	public $eoiType = '';
	public $diUserEoiScholarshipId = 0;
	
	// model for validations
	public $model;
	
	public $error = false;
    public $attachmentExtensions = array();
    public $errorMessage = '';
    public $eoiLogRefId = '';

    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }
	
    public function init(){
        parent::init();
		
		$this->checkIsDiProductActive();
		
		$this->diUserLoginId 		= Yii::app()->user->id;
		$this->diUserId 			= Yii::app()->user->sub_id;
		$this->diId 				= Yii::app()->user->di_id;
		
		$diData   					= DiHelper::GetDiDetails($this->diId);
		$diUserData					= DiHelper::getDiUserDetails($this->diUserId);
		
		$this->diUserName			= $diUserData->first_name.' '.$diUserData->last_name;
		$this->universityId 		= $diData->uni_ref_id;
		$this->universityCountryId 	= $diData->uniRef->country_ref_id;
		$this->diCurrencyId 		= $diData->currency_ref_id;
		
		$this->scholarshipArr		= $this->getScholarshipArr();
		//$this->scholarshipArr 		= array('1'=>'Test');
		
		$model = new SendOffer;
		$this->model = $model;
		
		$eoiDetail = array();
//die($this->type);
		switch($this->type){
			case 'alertmatch':
                /*
				$res= DiUserCriteriaMatch::model()->findByPk($this->listId);
				DiUserCriteriaMatch::model()->updateByPk($listId,array('status'=>'EOI'));
				$this->studentId = $res->user_ref_id;
				$model->eoiDepartmentId = $res->diUserCriteriaRef->main_department_ref_id;
				$this->eoiType = 'Criteria';
				$eoiDetail= DiUserEoi::model()->findByAttributes(array(
				'di_user_ref_id'			=>	$this->diUserId,
				'user_ref_id'				=>	$this->studentId,
				'main_department_ref_id'	=>	$model->eoiDepartmentId
				));*/
			break;
			case 'alertmatchShortlist':
				// #revise eoi offfer , get Data from Previous sent offer and fill all the forms by default
				$res= DiUserCriteriaShortlist::model()->findByPk($this->listId);
				if($res->status=="Buy"){ $this->isBought = 1; }
				$this->studentId = $res->user_ref_id;
				$model->eoiDepartmentId = $res->main_department_ref_id;
				$this->eoiType = 'Criteria';
				$eoiDetail= DiUserEoi::model()->findByAttributes(array(
				'di_user_ref_id'			=>	$this->diUserId,
				'user_ref_id'				=>	$this->studentId,
				'main_department_ref_id'	=>	$model->eoiDepartmentId
				));
			break;
			case 'hotlead':
				$this->isBought = 1; //No need to charge or eoi sent limitations
				$res = DiUserHotlead::model()->findByPk($this->listId);	
				$this->studentId = $res->studentHotleadRef->user_ref_id;
				$this->eoiType = 'Hotlead';
				
				$depId = Yii::app()->request->getQuery('depId');
				if( ($depId=="") || ($depId==0)){ $depId = $_POST['SendOffer']['eoiDepartmentId']; }
				if((isset($depId)) && ($depId!="") && (is_numeric($depId)) && ($depId>0)){
					$model->eoiDepartmentId = $depId;
					$eoiDetail= DiUserEoi::model()->findByAttributes(array(
					'di_user_ref_id'			=>	$this->diUserId,
					'user_ref_id'				=>	$this->studentId,
					'main_department_ref_id'	=>	$model->eoiDepartmentId
					));
				}
				
			break;
			case 'hotleadShortlist':
				$this->isBought = 1; //No need to charge or eoi sent limitations
				$res = DiUserHotlead::model()->findByPk($this->listId);	
				$this->studentId = $res->studentHotleadRef->user_ref_id;
				$this->eoiType = 'Hotlead';// this will remain same as hotlead
				
				$depId = Yii::app()->request->getQuery('depId');
				if( ($depId=="") || ($depId==0)){ $depId = $_POST['SendOffer']['eoiDepartmentId']; }
				
				if((isset($depId)) && ($depId!="") && (is_numeric($depId)) && ($depId>0)){
					$model->eoiDepartmentId = $depId;
					$eoiDetail= DiUserEoi::model()->findByAttributes(array(
					'di_user_ref_id'			=>	$this->diUserId,
					'user_ref_id'				=>	$this->studentId,
					'main_department_ref_id'	=>	$model->eoiDepartmentId
					));
				}
			break;
			case 'counselorSuggested':
				$res	=   DiUserCounsellorSuggested::model()->findByPk($this->listId);
				$this->studentId = $res->user_ref_id;
				$model->eoiDepartmentId = $res->department_ref_id;
				$this->eoiType = 'Counselor';
				$eoiDetail= DiUserEoi::model()->findByAttributes(array(
				'di_user_ref_id'			=>	$this->diUserId,
				'user_ref_id'				=>	$this->studentId,
				'main_department_ref_id'	=>	$model->eoiDepartmentId
				));
			break;			
			case 'counselorShortlist':
				$res	=   DiUserCounsellorShortlist::model()->findByPk($this->listId);
				if($res->status=="Buy"){ $this->isBought = 1; }
				$this->studentId = $res->user_ref_id;
				$model->eoiDepartmentId = $res->department_ref_id;
				$this->eoiType = 'Counselor';
				$eoiDetail= DiUserEoi::model()->findByAttributes(array(
				'di_user_ref_id'			=>	$this->diUserId,
				'user_ref_id'				=>	$this->studentId,
				'main_department_ref_id'	=>	$model->eoiDepartmentId
				));
			break;			
		}
		
		if(!empty($eoiDetail)){
		
			// ONE Eoi == ONE Scholarship
			$model->admissionChances = $eoiDetail->admission_chance;
			$sql = "SELECT * FROM di_user_eoi_scholarship WHERE di_user_eoi_ref_id=".$eoiDetail->di_user_eoi_id." 
			ORDER BY di_user_eoi_scholarship_id DESC
			LIMIT 1";
			$connection  = Yii::app()->db;
			$command     = $connection->createCommand($sql);
			$rowCount    = $command->execute(); // execute the non-query SQL
			if($rowCount>0){
				$eoiScholarshipData 	= $command->query()->read();
				$this->diUserEoiScholarshipId = $eoiScholarshipData['di_user_eoi_scholarship_id'];
				
				if($eoiScholarshipData['scholarship_ref_id']>0){
                    $model->scholarshipId       = $eoiScholarshipData['scholarship_ref_id'];
                    $model->scholarshipChances 	= $eoiScholarshipData['scholarship_chance'];
				} else{
                    $model->scholarshipId       = null;
                    $model->scholarshipName 	= $eoiScholarshipData['scholarship_name'];
                    $model->scholarshipPrice 	= $eoiScholarshipData['amount'];
                    $model->scholarshipDescription 	= $eoiScholarshipData['scholarship_description'];
                    $model->scholarshipChances 	= $eoiScholarshipData['scholarship_chance'];
				}
				
				/*
				EOI Popup in Hotlead, When di user will select department, we will return data via json
				and will autofill admission chances and scholarship form acording to jso return
				*/	
				if(Yii::app()->request->getQuery('do')=='json'){
					$response = CJSON::encode($model->attributes);
					echo $response;
					Yii::app()->end();
				}					

			}
		}	
		
		$this->model = $model;
		
		// No limit to send Offer if student profile bought
		if($this->isBought!=1){
			if($this->isOfferAlreadySent($times=3)){
				echo "<script>
				parent.eval('$.colorbox.close();');
				parent.eval('$.notification({class:\'error_notify\', notification:\'offer_sent_limit_exceeded\'})');
				</script>";
			}
		}
		
		if(isset($_POST) && count($_POST)>0)
		{

            $model = $this->model;
			$model->attributes = $_POST['SendOffer'];

			$this->model = $model;
			$this->applyScenario();

			$model = $this->model;
            //$this->performAjaxValidation($model);
			$isValid = $model->validate();
            //$isValid = $this->validateOfferDetails();
			
			if($isValid){
                
				/*
				$isUploadValid 	= false;
				$uploadingFile 	= false;
				
				if(
					isset($_FILES['SendOffer']['name']['attachment']) &&  
					($_FILES['SendOffer']['name']['attachment']!="")
				){
					$model->setScenario('ATTACHMENT_UPLOAD');
					if($model->validate()){
						echo "OK";
						$isUploadValid = true;
						$uploadingFile = true;
					}
				} else{
					// if user not selected any file to upload then, allow him to send message without attachment
					$isUploadValid = true;
				}
				*/

                $listIds = explode(',', $this->listId);
				foreach($listIds as $listId){
                    $this->listId = $listId;

                    if($this->type == 'alertmatch'){
                        $res= DiUserCriteriaMatch::model()->findByPk($this->listId);
                        DiUserCriteriaMatch::model()->updateByPk($listId,array('status'=>'EOI'));
                        $this->studentId = $res->user_ref_id;
                        $model->eoiDepartmentId = $res->diUserCriteriaRef->main_department_ref_id;
                        $this->eoiType = 'Criteria';
                        $eoiDetail= DiUserEoi::model()->findByAttributes(array(
                                                                              'di_user_ref_id'			=>	$this->diUserId,
                                                                              'user_ref_id'				=>	$this->studentId,
                                                                              'main_department_ref_id'	=>	$model->eoiDepartmentId
                                                                         ));

                        if(!empty($eoiDetail)){

                            // ONE Eoi == ONE Scholarship
                            $model->admissionChances = $eoiDetail->admission_chance;
                            $sql = "SELECT * FROM di_user_eoi_scholarship WHERE di_user_eoi_ref_id=".$eoiDetail->di_user_eoi_id."
			ORDER BY di_user_eoi_scholarship_id DESC
			LIMIT 1";
                            $connection  = Yii::app()->db;
                            $command     = $connection->createCommand($sql);
                            $rowCount    = $command->execute(); // execute the non-query SQL
                            if($rowCount>0){
                                $eoiScholarshipData 	= $command->query()->read();
                                $this->diUserEoiScholarshipId = $eoiScholarshipData['di_user_eoi_scholarship_id'];

                                if($eoiScholarshipData['scholarship_ref_id']>0){
                                    $model->scholarshipId       = $eoiScholarshipData['scholarship_ref_id'];
                                    $model->scholarshipChances 	= $eoiScholarshipData['scholarship_chance'];
                                } else{
                                    $model->scholarshipId       = null;
                                    $model->scholarshipName 	= $eoiScholarshipData['scholarship_name'];
                                    $model->scholarshipPrice 	= $eoiScholarshipData['amount'];
                                    $model->scholarshipDescription 	= $eoiScholarshipData['scholarship_description'];
                                    $model->scholarshipChances 	= $eoiScholarshipData['scholarship_chance'];
                                }
                            }
                        }

                    }


                    $isUploadValid = true;
                    if($isUploadValid)
                    {
                        $eoiId = $this->sendOffer();
                        // My be eoi sending fail due to low balance in account, so  show related fail message here
                        if(!$eoiId){
                            echo "<script>
						//parent.eval('$.prettyPhoto.close()');
						parent.eval('parent.$.fn.colorbox.close()');
						parent.eval('$.notification({class:\'error_notify\', notification:\'di_account_balance_message\',  replaceKeys:{\'MESSAGE\': \'".$this->error."\'}})');
						</script>";
                        }

                        //===== UPDATE RELATED TABLES ======//
                        if($eoiId>0){
                            $eoiDetail= DiUserEoi::model()->findByPk($eoiId);
                            switch($this->type){
                                case 'alertmatch':
                                    DiUserCriteriaMatch::model()->updateByPk($this->listId,array('status'=>'EOI'));
                                    // create shortlist entery
                                    $modelCriteriaShortlist  = new DiUserCriteriaShortlist();
                                    $modelCriteriaShortlist->di_user_ref_id          =   $this->diUserId;
                                    $modelCriteriaShortlist->di_user_eoi_ref_id      =   $eoiId;
                                    $modelCriteriaShortlist->user_ref_id             =   $this->studentId;
                                    $modelCriteriaShortlist->main_department_ref_id  =   $eoiDetail->main_department_ref_id;
                                    $modelCriteriaShortlist->added_on             	 =   new CDbExpression('NOW()');
                                    $modelCriteriaShortlist->added_by                =   $this->diUserLoginId;
                                    $modelCriteriaShortlist->save();
                                    break;
                                case 'alertmatchShortlist':
                                    // do nothing
                                    break;
                                case 'hotlead':
                                    // do nothing
                                    break;
                                case 'hotleadShortlist':
                                    // do nothing
                                    break;
                                case 'counselorSuggested':
                                    DiUserCounsellorSuggested::model()->updateByPk($this->listId,array('status'=>'EOI'));
                                    // create or update shortlist entery
                                    $modelCounselorShortlist = DiUserCounsellorShortlist::model()->findByAttributes(array(
                                                                                                                         'di_user_ref_id'	=> $this->diUserId,
                                                                                                                         'user_ref_id'		=> $this->studentId,
                                                                                                                         'department_ref_id'	=> $eoiDetail->main_department_ref_id
                                                                                                                    ));
                                    if($modelCounselorShortlist===null){
                                        $modelCounselorShortlist  = new DiUserCounsellorShortlist();
                                    }
                                    $modelCounselorShortlist->di_user_ref_id          =   $this->diUserId;
                                    $modelCounselorShortlist->di_user_eoi_ref_id      =   $eoiId;
                                    $modelCounselorShortlist->user_ref_id             =   $this->studentId;
                                    $modelCounselorShortlist->department_ref_id  	  =   $eoiDetail->main_department_ref_id;
                                    $modelCounselorShortlist->added_on             	  =   new CDbExpression('NOW()');
                                    $modelCounselorShortlist->added_by                =   $this->diUserLoginId;
                                    $modelCounselorShortlist->save();
                                    break;
                                case 'counselorShortlist':
                                    $modelCounselorShortlist = DiUserCounsellorShortlist::model()->findByPk($this->listId);
                                    $modelCounselorShortlist->di_user_ref_id          =   $this->diUserId;
                                    $modelCounselorShortlist->di_user_eoi_ref_id      =   $eoiId;
                                    $modelCounselorShortlist->user_ref_id             =   $this->studentId;
                                    $modelCounselorShortlist->department_ref_id  	  =   $eoiDetail->main_department_ref_id;
                                    $modelCounselorShortlist->added_on             	  =   new CDbExpression('NOW()');
                                    $modelCounselorShortlist->added_by                =   $this->diUserLoginId;
                                    $modelCounselorShortlist->save();
                                    break;
                            }
                        }
                        //===== /UPDATE RELATED TABLES ======//


                        //===== Sending mail======//
                        if($eoiId){
                            $message = (isset($model->message)) ? $model->message : "";

                            $attachments = array();
                            // include files that selected from dropdown

                            if(isset($model->attachmentId) && ($model->attachmentId>0)){
                                $attachments[] = $this->getAttachmentdetail($model->attachmentId);
                            }

                            //This is array of mutiple files which are selected by multi file upload
                            $filesArr = CUploadedFile::getInstancesByName('attachment');
                            if(count($filesArr)>0){
                                foreach($filesArr as $model->attachment)
                                {
                                    //$model->attachment = CUploadedFile::getInstance($model,'attachment');
                                    $ext = $model->attachment->getExtensionName();
                                    $name = $model->attachment->getName();
                                    $filePath = 'di_offer_attachments/';
                                    $fileName = "dioff-".Yii::app()->user->id."-".$this->studentId."-".$this->generateRandomString(5).".".$ext;
                                    if($model->attachment->saveAs(Yii::app()->getBasePath().'/../../uploads/'.$filePath.$fileName)){
                                        $attachments[] = array('name'=>$name,'path'=>$filePath.$fileName);
                                    }
                                }
                            }

                            // Offer sent show success messages and apply filters
                            Yii::import('application.modules.shortlist.components.EoiStudentResponseHandler');
                            switch($this->type){
                                case 'alertmatch':
                                    EoiStudentResponseHandler::sendEoiMailToStudent($eoiId,'alertmatch',$message,$attachments);
                                    $successMessage = "You have expressed interest in this profile successfully";
                                    break;
                                case 'alertmatchShortlist':
                                    EoiStudentResponseHandler::sendEoiMailToStudent($eoiId,'alertmatch',$message,$attachments);
                                    //$successMessage = "Congratulations! You have revised interest in this profile successfully";
                                    $successMessage = "You have revised your expression of interest successfully";
                                    echo "<script>parent.eval('refreshListView()');</script>";//alertMatchShortlistFilterApply();
                                    break;
                                case 'hotlead':
                                    EoiStudentResponseHandler::sendEoiMailToStudent($eoiId,'hotlead',$message,$attachments);
                                    //$successMessage = "Congratulations! Your interest to make an offer sent successfully";
                                    $successMessage = "Your offer was sent successfully";
                                    if(Yii::app()->controller->module->id == 'shortlist'){
                                        $refreshFunction = 'refreshListView()';
                                    }else{
                                        $refreshFunction = 'hotleadFilterApply()';
                                    }
                                    echo "<script>parent.eval('".$refreshFunction."');</script>";
                                    break;
                                case 'hotleadShortlist':
                                    EoiStudentResponseHandler::sendEoiMailToStudent($eoiId,'hotlead',$message,$attachments);
                                    if($this->isRevisedOffer()){
                                        //$successMessage = "Congratulations! Your interest to make an offer revised successfully";
                                        $successMessage = "Your offer was revised successfully";
                                    } else{
                                        //$successMessage = "Congratulations! Your interest to make an offer sent successfully";
                                        $successMessage = "Your offer was sent successfully";
                                    }
                                    if(Yii::app()->controller->module->id == 'shortlist'){
                                        $refreshFunction = 'refreshListView()';
                                    }else{
                                        $refreshFunction = 'hotleadFilterApply()';
                                    }
                                    echo "<script>parent.eval('".$refreshFunction."');</script>";
                                    break;
                                case 'counselorSuggested':
                                    EoiStudentResponseHandler::sendEoiMailToStudent($eoiId,'alertmatch',$message,$attachments);
                                    if($this->isRevisedOffer()){
                                        //$successMessage = "Congratulations! Your interest to make an offer revised successfully";
                                        $successMessage = "Your offer was revised successfully";
                                    } else{
                                        //$successMessage = "Congratulations! Your interest to make an offer sent successfully";
                                        $successMessage = "Your offer was sent successfully";
                                    }
                                    echo "<script>parent.eval('refreshListView()');								</script>";
                                    break;
                                case 'counselorShortlist':
                                    EoiStudentResponseHandler::sendEoiMailToStudent($eoiId,'alertmatch',$message,$attachments);
                                    if($this->isRevisedOffer()){
                                        //$successMessage = "Congratulations! Your interest to make an offer revised successfully";
                                        $successMessage = "Your offer was revised successfully";
                                    } else{
                                        $successMessage = "Your offer was sent successfully";
                                    }
                                    echo "<script>parent.eval('$.fn.yiiListView.update(\"ajax-list-view\")');								</script>";
                                    break;
                            }//switch



                        }
                        //===== /Sending mail======//

                    } // isUploadValid


                    echo "<script>
                    parent.eval('$.colorbox.close();');
                    parent.eval('$.notification({class:\'success_notify\', notification:\'offer_sent_successfully\',  replaceKeys:{\'MESSAGE\': \'".$successMessage."\'}})');
                    </script>";

                    if($this->type=="alertmatch"){
                        $DiUserCriteriaMatch= DiUserCriteriaMatch::model()->findByPk($this->listId);
                        echo "<script> window.top.location.href = '".Yii::app()->createAbsoluteUrl('/alertmatch/diUserCriteriaMatch/index/criteria_id/'.$DiUserCriteriaMatch->di_user_criteria_ref_id)."';</script>";
                    }
                }

			}// isValid

		}//if count($_POST)>0
    }

    public function run(){
        //Nothing to do here
    }
	
	
	
	public function sendOffer(){
		$model = $this->model;
		$listId = $this->listId;
		if($this->isBought!=1){ // If profile already bought then no need to apply charges
		#====== Deduct Balance for sending EOI ====== #
			switch($this->type){
				case 'alertmatch':
					$listing_type = 'DiUserCriteriaMatch';
				break;
				case 'alertmatchShortlist':
					$listing_type = 'DiUserCriteriaShortlist';
				break;
				case 'hotlead':
					$listing_type = 'DiUserHotlead';
				break;
				case 'hotleadShortlist':
					$listing_type = 'DiUserHotlead';
				break;
				case 'counselorSuggested':
					$listing_type = 'DiUserCounsellorSuggested';
				break;
				case 'counselorShortlist':
					$listing_type = 'DiUserCounsellorShortlist';
				break;
				
			}
			$array = array(
				'product_name'	=> 'Eoi',// Eoi | Buy
				'listing_type'	=> $listing_type,// DiUserHotlead | DiUserCriteriaMatch | DiUserCriteriaShortlist
				'listing_id'	=> $listId // any primary key of above 3 tables
			);
			$res = DiHelper::setProductDebits($array);
			if($res['msg_type']=='error'){

				$this->error = $res['msg_code'];

				return false;
			}
		}
		#====== /// Deduct Balance for sending EOI ====== #
		
		$eoiId = 0;

		if( ($this->eoiType!="") && ($model->eoiDepartmentId>0)){
			$eoiId = $this->addUserEoi();
		} else{
			$this->error = "AddUserEoi : Sorry! Department no longer exists for this Expression of Interest";
			return false;
		}
		
		# This Part is Common for All Offers
		# eoiId must be exist to save scholarship
		if($eoiId>0){
			$scholarshipId 	= 0;
			
			// if DiUser wants to send Scholarship
			if( ($this->isCustomeScholarship()) || ($model->scholarshipId>0))
			{
				//if scholarshipId from FORM
				//AND if diUser wants to publish it
				if($this->isCustomeScholarship()){
					if($model->publishScholarship==1){
						$scholarshipId = $this->addPublicScholarship();
					}
				}
				
				//if scholarshipId from dropdown
				if( ($scholarshipId==0) && ($model->scholarshipId>0) ){
					$scholarshipId = $model->scholarshipId;
				}
				
				// Save / Update Scholarship Chances
				$this->savePrivateScholarship($eoiId,$scholarshipId);
				
			}// check if diUser wants to send scholarship

			return $eoiId;	
		}//if eoi enteries successfull
		else{
			return false;
		}

	
	}
	
	
	
	
	/**
	* 	Helper Functions
	*/
	
	public function getScholarshipArr(){
		$data  					= DiHelper::getDiScholarship($this->universityId);
		$scholarshipArr 		= CHtml::listData($data,'scholarship_id','scholarship_name');
		return $scholarshipArr;
	}
	
	public function applyScenario(){
		$model = $this->model;
		if( is_numeric($model->scholarshipId) && ($model->scholarshipId>0) ){
			$model->setScenario('DROPDOWN_SCHOLARSHIP');
		} else{
			if($this->isCustomeScholarship()){
				$model->setScenario('CUSTOME_SCHOLARSHIP');
			}
		}
		$this->model = $model;
	}
	
	public function isCustomeScholarship(){
		$model = $this->model;
		if( 
			(trim($model->scholarshipName)!="") || 
			(trim($model->scholarshipPrice)!="") || 
			(trim($model->scholarshipDescription)!="")
		) {
			return true;
		} else{
			return false;
		}

	}
	
	public function addPublicScholarship(){
		$model = $this->model;
		/*added new scholarship*/
		$arrayScholarshipData   =   array(
			'scholarshipName'           =>  $model->scholarshipName,
			'scholarshipDesc'           =>  $model->scholarshipDescription,
			'scholarshipPrice'          =>  $model->scholarshipPrice,
			'login_id'                  =>  $this->diUserLoginId,
			'di_user_id'                =>  $this->diUserId,
			'scholarship_provider_name' =>  $this->diUserName,
			'university_id'             =>  $this->universityId,
			'country_ref_id'            =>  $this->universityCountryId,
			'currency_ref_id'           =>  $this->diCurrencyId,
		);
		
		$scholarship_id =    DiHelper::addScholarshipPackage($arrayScholarshipData);    #Add new scholarship
		return $scholarship_id;
	}
	
	public function savePrivateScholarship($eoi_id=0,$scholarship_id=0){
		$model = $this->model;
		
		// If is set di_user_eoi_scholarship_id means Di revising that offer
		if($this->isRevisedOffer()){
			$modelScholarship  = DiUserEoiScholarship::model()->findByPk($this->diUserEoiScholarshipId);
		} else{
			// IF Scholarship is from Drop Down, so no need to these details
			// Because these details already asign with $scholarship_id
			if($scholarship_id>0){
				$model->scholarshipName			=	'';
				$model->scholarshipPrice		=	'';
				$model->scholarshipDescription	=	'';
				$modelScholarship      			=   DiUserEoiScholarship::model()->findByAttributes(array(
				'di_user_eoi_ref_id' 			=>	$eoi_id,
				'scholarship_ref_id'			=>	$scholarship_id
				));
				
				if($modelScholarship===null){
					$modelScholarship = new DiUserEoiScholarship;
				}
				
			} else{
				$scholarship_id   = 0;
				$modelScholarship = new DiUserEoiScholarship;
			}
		}	
		
        $modelScholarship->di_user_eoi_ref_id      =   $eoi_id;
        $modelScholarship->scholarship_ref_id      =   ($scholarship_id==0) ? NULL : $scholarship_id;
        $modelScholarship->scholarship_chance      =   $model->scholarshipChances;
        $modelScholarship->scholarship_description =   $model->scholarshipDescription;
        $modelScholarship->scholarship_name        =   $model->scholarshipName;
        $modelScholarship->amount                  =   $model->scholarshipPrice;
        $modelScholarship->added_on                =   new CDbExpression('NOW()');
        $modelScholarship->added_by                =   $this->diUserLoginId;
		
        if($modelScholarship->save()){

            $DiUserEoiLogModel = DiUserEoiLog::model()->find("di_user_eoi_ref_id = {$eoi_id} ORDER BY di_user_eoi_log_id DESC");
			$logModel   =   new DiUserEoiScholarshipLog();
            $logModel->di_user_eoi_log_ref_id   =   $DiUserEoiLogModel->di_user_eoi_log_id;
            $logModel->scholarship_ref_id       =   ($scholarship_id==0) ? NULL : $scholarship_id;
            $logModel->scholarship_chance       =   $model->scholarshipChances;
            $logModel->scholarship_description  =   $model->scholarshipDescription;
            $logModel->scholarship_name         =   $model->scholarshipName;
            $logModel->amount                   =   $model->scholarshipPrice;
            $logModel->added_on                 =   new CDbExpression('NOW()');
            $logModel->added_by                 =   $this->diUserLoginId;

            if($logModel->save()):
                return $modelScholarship->di_user_eoi_scholarship_id;
            else:
                return false;
            endif;
        }else{
            return false;
        }
		
	}	
	
	public function isOfferAlreadySent($times=3){
	
		switch($this->type){
			case 'alertmatch':
				$listId						=	$this->listId;
				$di_id  					= 	$this->diId;
				$DiUserCriteriaMatch        =   DiUserCriteriaMatch::model()->findByPk($listId);
				$student_id                 =   $DiUserCriteriaMatch->user_ref_id;
				
				$main_department_ref_id = $DiUserCriteriaMatch->diUserCriteriaRef->main_department_ref_id;
				$diUsers = DiHelper::getAllDiUsersOfSameUniversity($di_id);
				
				$criteria = new CDbCriteria();
				$criteria->condition = 'user_ref_id=:user_ref_id AND main_department_ref_id=:main_department_ref_id';
				$criteria->params = array(
				'user_ref_id'				=> $student_id,
				'main_department_ref_id'	=> $main_department_ref_id,
				);
				$criteria->addInCondition('di_user_ref_id', $diUsers);		
				$eoiLogEnteries = DiUserEoiLog::model()->findAll($criteria);
				
				if(count($eoiLogEnteries)>=$times){
					return true;
				} else{
					return false;
				}			
			break;
			case 'alertmatchShortlist':
				$listId		=	$this->listId;
				$di_id  	= 	$this->diId;
				
				$shortListDetail = DiUserCriteriaShortlist::model()->findByPk($listId);
				$diUserEoi	=	DiUserEoi::model()->findByPk($shortListDetail->di_user_eoi_ref_id);
				$student_id = $diUserEoi->user_ref_id;
				$main_department_ref_id = $diUserEoi->main_department_ref_id;
				$diUsers = DiHelper::getAllDiUsersOfSameUniversity($di_id);
				$criteria = new CDbCriteria();
				$criteria->condition = 'user_ref_id=:user_ref_id AND main_department_ref_id=:main_department_ref_id';
				$criteria->params = array(
				'user_ref_id'				=> $student_id,
				'main_department_ref_id'	=> $main_department_ref_id,
				);
				$criteria->addInCondition('di_user_ref_id', $diUsers);
				$eoiLogEnteries = DiUserEoiLog::model()->findAll($criteria);
				
				if(count($eoiLogEnteries)>=$times){
					return true;
				} else{
					return false;
				}			
			break;
			case 'counselorShortlist':
				$listId		=	$this->listId;
				$di_id  	= 	$this->diId;
				$shortListDetail = DiUserCounsellorShortlist::model()->findByPk($listId);
				$diUserEoi	=	DiUserEoi::model()->findByPk($shortListDetail->di_user_eoi_ref_id);
				$student_id = $diUserEoi->user_ref_id;
				$main_department_ref_id = $diUserEoi->main_department_ref_id;
				$diUsers = DiHelper::getAllDiUsersOfSameUniversity($di_id);
				$criteria = new CDbCriteria();
				$criteria->condition = 'user_ref_id=:user_ref_id AND main_department_ref_id=:main_department_ref_id';
				$criteria->params = array(
				'user_ref_id'				=> $student_id,
				'main_department_ref_id'	=> $main_department_ref_id,
				);
				$criteria->addInCondition('di_user_ref_id', $diUsers);
				$eoiLogEnteries = DiUserEoiLog::model()->findAll($criteria);
				/*
				echo "<pre>";
				print_r(count($eoiLogEnteries));
				echo "</pre>";
				die();
				*/
				if(count($eoiLogEnteries)>=$times){
					return true;
				} else{
					return false;
				}			
			break;
		}
	
	}
	
	
   public function addUserEoi(){
		$model = $this->model;
		
		$eoi_type 		= $this->eoiType;
		$department_id 	= $model->eoiDepartmentId;
   
		$array  =   array(
			'di_user_ref_id'          =>   $this->diUserId,
			'user_ref_id'             =>   $this->studentId,
			'main_department_ref_id'  =>   $department_id,
			'intake'                  =>   '',
			'admission_chance'        =>   $model->admissionChances,
			'offer_message'         =>   $model->message,
			'user_acceptance_status'  =>   '',
			'user_viewed_on'          =>   '',
			'eoi_status'              =>   'Pending',
			'eoi_type'                =>   $eoi_type,
			'added_by'                =>   $this->diUserLoginId,
		);
		
		// IF EOI is from hotlead or hotlead shortlist set eoi_status="Hotlead"
		switch($this->type){
			case 'hotlead':
			$array['eoi_status'] = "Hotlead";
			break;
			case 'hotleadShortlist':
			$array['eoi_status'] = "Hotlead";
			break;
		}
		
        $eoiModel      =   new DiUserEoi();
        $logModel   =   new DiUserEoiLog();
		
		/*
		EOI entery should only one for same university, same department, same student
		First find entery in di_user_eoi table if exist then open it to save updates
		*/
		$di_id = $this->diId;
		$diUsers = DiHelper::getAllDiUsersOfSameUniversity($di_id);
		
		$criteria = new CDbCriteria();
		$criteria->condition = 'user_ref_id=:user_ref_id AND main_department_ref_id=:main_department_ref_id';
		$criteria->params = array(
		'user_ref_id'				=> $array['user_ref_id'],
		'main_department_ref_id'	=> $array['main_department_ref_id']
		);
		$criteria->addInCondition('di_user_ref_id', $diUsers);
		
		$DiUserEoi = DiUserEoi::model()->find($criteria);
		
		if(!empty($DiUserEoi)){ // this is Offer revise case
			$di_user_eoi_id = $DiUserEoi->di_user_eoi_id;
			$eoiModel = DiUserEoi::model()->findByPk($di_user_eoi_id);
			$model->publishScholarship=0; // No need to publish Scholarship in revise case 
		}
		
        $eoiModel->di_user_ref_id          =   $array['di_user_ref_id'];
        $eoiModel->user_ref_id             =   $array['user_ref_id'];
        $eoiModel->main_department_ref_id  =   $array['main_department_ref_id'];
        $eoiModel->intake                  =   $array['intake'];
        $eoiModel->admission_chance        =   $array['admission_chance'];
        $eoiModel->offer_message    =   $array['offer_message'];
        $eoiModel->user_acceptance_status  =   $array['user_acceptance_status'];
        $eoiModel->user_viewed_on          =   $array['user_viewed_on'];
        $eoiModel->eoi_status              =   $array['eoi_status'];
        $eoiModel->eoi_type                =   $array['eoi_type'];
        $eoiModel->added_on                =   date('Y-m-d H:i:s');
        $eoiModel->added_by                =   $array['added_by'];

        if($eoiModel->save()){
		
			// Generate unique key and update in di_user_eoi table every time when we send new or revise offer
			$unique_key = DiHelper::keygen();
			$unique_key = md5($eoiModel->di_user_ref_id.$eoiModel->user_ref_id.$eoiModel->di_user_eoi_id.$unique_key);
			DiUserEoi::model()->updateByPk($eoiModel->di_user_eoi_id,array(
				'unique_key' 	=> $unique_key,
				'modified_on'	=> date('Y-m-d H:i:s'),
			));


            $logModel->di_user_eoi_ref_id       =   $eoiModel->di_user_eoi_id;
            $logModel->di_user_ref_id           =   $array['di_user_ref_id'];
            $logModel->user_ref_id              =   $array['user_ref_id'];
            $logModel->main_department_ref_id   =   $array['main_department_ref_id'];
            $logModel->intake                   =   $array['intake'];
            $logModel->admission_chance         =   $array['admission_chance'];
            $logModel->offer_message     =   $array['offer_message'];
            $logModel->user_acceptance_status   =   $array['user_acceptance_status'];
            $logModel->user_viewed_on           =   $array['user_viewed_on'];
            $logModel->eoi_status               =   $array['eoi_status'];
            $logModel->added_on                 =   date('Y-m-d H:i:s');
            $logModel->added_by                 =   $array['added_by'];

            if($logModel->save()){
                $this->eoiLogRefId = $logModel->di_user_eoi_log_id;
                return $eoiModel->di_user_eoi_id;
            }else{
               return false;
               //print_r($logModel->getErrors());
            }
        }else{
            return false;
            //print_r($eoiModel->getErrors());
        }
    }
	
	public function isRevisedOffer(){
		return ($this->diUserEoiScholarshipId > 0) ? true: false;
	}
	
	public function generateRandomString($length = 10) {
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, strlen($characters) - 1)];
		}
		return $randomString;
	}
	
	public function getAttachments(){
		
		$sql = "SELECT * FROM email_attachment WHERE added_by=".$this->diUserLoginId." GROUP BY file_name";
		$connection  = Yii::app()->db;
		$command     = $connection->createCommand($sql);
		$rowCount    = $command->execute(); // execute the non-query SQL
		$dataList = array();
		if($rowCount>0){
			$data 	= $command->query()->readAll();
			foreach($data as $data){
				$dataList[$data['email_attachment_id']] = $data['file_name'];
			}
			return $dataList;
		} else{
			return array();
		}		
	}
	
	public function getAttachmentDetail($id){
		
		$sql = "SELECT * FROM email_attachment WHERE email_attachment_id=".$id."";
		$connection  = Yii::app()->db;
		$command     = $connection->createCommand($sql);
		$rowCount    = $command->execute(); // execute the non-query SQL
		$dataList = array();
		if($rowCount>0){
			$data 	= $command->query()->read();
			$arr = array(
			'name'=>$data['file_name'],
			'path'=>$data['file_path']
			);
			return $arr;
		}
	}
	
	
	public function checkIsDiProductActive(){
		$LookupProduct = LookupProduct::model()->findByAttributes(array('product_shortcode'=>'EOI'));
        $di_id  	= Yii::app()->user->di_id;
		$product_id = $LookupProduct->product_id;
		$isActiveProduct    =   DiHelper::DiProductPriceIsActive($di_id,$product_id);
		if(!$isActiveProduct){
			$this->error = "Sorry, this feature is not yet available for you.";
			echo "<script>
			//parent.eval('$.prettyPhoto.close()');
			parent.eval('parent.$.fn.colorbox.close()');
			parent.eval('$.notification({class:\'error_notify\', notification:\'di_account_balance_message\',  replaceKeys:{\'MESSAGE\': \'".$this->error."\'}})');
			</script>";
		}
	}

    public function validateOfferDetails(){
        $post = $_POST['SendOffer'];
        $flagMessageValidation = true;
        $flagAttachmentsValidation = true;
        $flagAdmissionChancesValidation = true;
        $flagAdmissionChanceDeptValidation = true;
        $flagAdmissionChanceValidation = true;
        $flagScholarshipChanceDropDownValidation = true;
        $flagNewScholarshipValidation = true;
        $flagScholarshipChancesValidation = true;
        $flagScholarshipValidation = true;
        $eoiMessageErrorMessage = '';
        $admissionChancesErrorMessagesArray = array();
        $scholarshipChancesErrorMessagesArray = array();

        //Attachments extension validation
        $this->getAttachmentExtensionsFromModel();
        $filesArr = CUploadedFile::getInstancesByName('attachment');
        if(count($filesArr)>0){
            foreach($filesArr as $attachments){
                $extension = $attachments->getExtensionName();
                if(!in_array($extension, $this->attachmentExtensions)){
                    $flagAttachmentsValidation = false;
                }
            }
        }
        if(!$flagAttachmentsValidation){
            $this->errorMessage = '<li>Please check attachments. Attachments should be '.strtoupper(implode(', ', $this->attachmentExtensions)).'</li>';
            //Attachments extension validation_END
        }else{
            //Message Validation
            if(trim($post['message']) == ''){
                $flagMessageValidation = false;
                $eoiMessageErrorMessage = '<li>Please select EOI messsage</li>';
            }
            //Message Validation_END

            //Admission Chance Department Validation
            if(isset($post['eoiDepartmentId']) && $post['eoiDepartmentId'] == ''){
                $flagAdmissionChanceDeptValidation = false;
                $admissionChancesErrorMessagesArray[] = '<li>Please select a department</li>';
            }
            //Admission Chance Department Validation_END

            //Admission Chance Validation
            if($post['admissionChances'] == ''){
                $flagAdmissionChanceValidation = false;
                $admissionChancesErrorMessagesArray[] = '<li>Please select admission chances</li>';
            }
            //Admission Chance Validation_END
            if(!$flagAdmissionChanceDeptValidation || !$flagAdmissionChanceValidation){
                $flagAdmissionChancesValidation = false;
            }

            //Scholarship Dropdown Validation
            if(isset($post['scholarshipId']) && $post['scholarshipId'] == ''){
                $flagScholarshipChanceDropDownValidation = false;
                $scholarshipChancesErrorMessagesArray[] = '<li>Please select a scholarship</li>';
                //Scholarship Dropdown Validation_END
            }else{
                //New Scholarship Validation
                if(trim($post['scholarshipName']) == '' || trim($post['scholarshipPrice']) == ''){
                    $flagNewScholarshipValidation = false;
                    if(trim($post['scholarshipName']) == ''){
                        $scholarshipChancesErrorMessagesArray[] = '<li>Please enter scholarship name</li>';
                    }

                    //Scholarship Price Validation
                    if(trim($post['scholarshipPrice']) == ''){
                        $scholarshipChancesErrorMessagesArray[] = '<li>Please enter scholarship amount</li>';
                    }else{
                        if($post['scholarshipPrice'] < 0){
                            $scholarshipChancesErrorMessagesArray[] = '<li>Scholarship amount should not contain any special characters</li>';
                        }
                        if(!is_int($post['scholarshipPrice'])){
                            $scholarshipChancesErrorMessagesArray[] = '<li>Scholarship amount should not contain any special characters</li>';
                        }
                        //Scholarship Price Validation_END
                    }
                }
                //New Scholarship Validation_END
            }
            if($post['scholarshipChances'] == ''){
                $flagScholarshipChancesValidation = false;
                $scholarshipChancesErrorMessagesArray[] = '<li>Please enter scholarship admission chances</li>';
            }
            if((!$flagScholarshipChanceDropDownValidation || !$flagNewScholarshipValidation) || !$flagScholarshipChancesValidation){
                $flagScholarshipValidation = false;
            }

            if(!$flagMessageValidation && !$flagAdmissionChancesValidation && !$flagScholarshipChancesValidation){
                $this->errorMessage = '<li>Please enter message or select admission chances or scholarship chances</li>';
            }else{
                if(!$flagMessageValidation){
                    $this->errorMessage = $eoiMessageErrorMessage;
                }
                if(!$flagAdmissionChancesValidation){
                    $this->errorMessage = implode('', $admissionChancesErrorMessagesArray);
                }
                if(!$flagScholarshipChancesValidation){
                    $this->errorMessage = implode('', $scholarshipChancesErrorMessagesArray);
                }
            }
        }
        if($this->errorMessage != ''){
            return false;
        }else{
            return true;
        }/*
        //$this->printr($this->attachmentExtensions);
        $this->printr($post);
        //if($post)
        return false;*/
    }

    public function getAttachmentExtensionsFromModel(){
        $modelRules = SendOffer::rules();
        $attachmentExtensions = array();
        foreach($modelRules as $modelRule){
            if($modelRule[0] == 'attachment' && $modelRule[1] == 'file'){
                echo 'Hi';
                $attachmentExtensions = explode(',', $modelRule['types']);
            }
        }
        //$this->printr($attachmentExtensions);
        foreach($attachmentExtensions as $attachment){
            $this->attachmentExtensions[] = trim($attachment);
        }
    }

    public function printr($array = array()){
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }
	
	
}
?>