<?php
/**
 * Helper clas for di_user Hot leades Fetching from student_hotlead ( Destination Institutes )
 *
Example how to run

DiHotLeadFetcher::$uni_ref_id       = 603; // id of di university
DiHotLeadFetcher::$di_user_ref_id   = 36;  // id of di_user
DiHotLeadFetcher::$added_by         = 2270; // login_master id
DiHotLeadFetcher::getHotLeads();

 *
 */

class DiHotLeadFetcher{

    public static  $uni_ref_id         = 0;
    public static  $di_user_ref_id     = 0;
    public static  $added_by           = 0;
    public static  $di_last_student_hotlead_id = 0;
    public static  $hotlLeads = array();
    public static  $hasHotLeads = false;
    public static  $error = "";


    public static function getHotLeads(){

        self::fetchNewHotLeads();

        if(self::saveNewHotLeads()){
            // echo "Di Moderator Hot Leads Updated Successfully";
        } else{
            // echo self::$error;
        }

        //die("<br  />executed<br />");

    }


    public static function fetchNewHotLeads(){

        // Input security
        self::checkParams();

        self::setDiLastStudentHotLeadId();
//            SPD.main_dept_ref_id,


        $sql         = "
        SELECT
            DISTINCT
            SH.student_hotlead_id,
            SH.user_ref_id,
            SH.uni_ref_id,
			SH.status,
            DUD.di_user_ref_id
        FROM
            student_hotlead AS SH, student_preferred_department AS SPD, di_user_department AS DUD
        WHERE
            SH.user_ref_id = SPD.user_ref_id
        AND
            SPD.main_dept_ref_id = DUD.main_department_ref_id
        AND
            SH.uni_ref_id = ".self::$uni_ref_id."
        AND
            DUD.di_user_ref_id = ".self::$di_user_ref_id."
        ";
        //die();

        $connection  = Yii::app()->db;
        $command     = $connection->createCommand($sql);
        $rowCount    = $command->execute(); // execute the non-query SQL

        if($rowCount>0){
            self::$hasHotLeads = true;
            if($data = $command->query()){ // execute a query SQL
                self::$hotlLeads = $data;
            }else{
                self::$error = "something wrong with hotlead data fetch query";
                return false;
            }
        } else{
            self::$hasHotLeads = false;
            return false;
        }
    }

    public static function saveNewHotLeads(){

        // Input security
        self::checkParams();

        if(!self::$hasHotLeads){
            self::$error = "No hot lead Found to save";
            return false;
        }

        $newStudentHotleadsToInsert = 0;
        $sql = "INSERT INTO di_user_hotlead(di_user_ref_id,student_hotlead_ref_id,added_on)  VALUES";


        foreach(self::$hotlLeads as $data){

            // INSERT only if this lead will not create any duplicacy with Alertmatch
            // Duplicay handle will also check preference and validation flag
            $isDuplicacy = false; //HotleadAlermatchDuplicacyHandler::ifAlreadyExistInAlertMatch($user_id=$data['user_ref_id'],$uni_ref_id=$data['uni_ref_id'], $applyStatus = $data['status']);
            if(!$isDuplicacy){

                $sID 	= $data['user_ref_id'];
                $uniID	= $data['uni_ref_id'];

                $EligibilityEngineObj = new StudentEligibilityUpdatesHandlerEngine();
                $EligibilityEngineObj->type 		= "hotlead";
                $EligibilityEngineObj->studentId 	= $sID;
                $EligibilityEngineObj->universityId = $uniID;

                // Save only if Eligible
                if($EligibilityEngineObj->isValidationFlagsEligible() && $EligibilityEngineObj->isPereferenceEligible())
                {


                    if(self::isDiUserHotleadAlreadyExist($data['student_hotlead_id'],$data['di_user_ref_id']))
                    {

                        // Check if hotlead already exist but again check DI department = student department
                        // check di_user department instead of university department
                        $EligibilityEngineObj->diUserId = $data['di_user_ref_id'];
                        if($EligibilityEngineObj->isCourcePreferenceEligible()){
                            // Do nothing
                        } else{
                            $EligibilityEngineObj->rejectHotlead($student_hotlead_id);
                        }

                    } else{
                        $newStudentHotleadsToInsert++;
                        $sql .= "(";
                        $sql .= $data['di_user_ref_id'].",";
                        $sql .= $data['student_hotlead_id'].",";
                        $sql .= "'".date('Y-m-d H:i:s')."'";
                        $sql .= "), ";
                    }
                }

            }

        }

        $sql = rtrim($sql,', ');

        if($newStudentHotleadsToInsert>0){
            $connection  = Yii::app()->db;
            $command     = $connection->createCommand($sql);
            if($command->query()){ // execute a query SQL
                return true;
            } else{
                self::$error = "Sorry unable to save new Hot leads, something wrong with insert query";
                return false;
            }
        } else{
            self::$error = "No new student hotlead to insert";
            return false;
        }

    }

    public static function setDiLastStudentHotLeadId(){

        $sql = "SELECT student_hotlead_ref_id
        FROM di_user_hotlead
        WHERE di_user_ref_id=".self::$di_user_ref_id."
        ORDER BY student_hotlead_ref_id DESC
        LIMIT 1
        ";
        $connection  = Yii::app()->db;
        $command     = $connection->createCommand($sql);
        $rowCount    = $command->execute(); // execute the non-query SQL

        if($rowCount>0)
        {
            if($data = $command->query()){
                foreach($data as $data){
                    self::$di_last_student_hotlead_id = $data['student_hotlead_ref_id'];
                    return true;
                }
            }
        } else{
            self::$di_last_student_hotlead_id = 0;
            return false;
        }
    }

    public static function checkParams(){

        if( (self::$uni_ref_id>0) && (self::$di_user_ref_id>0) && (self::$added_by>0) ){
            return true;
        } else{
            echo "Please Fill the Params:<br />";
            echo "uni_ref_id.<br />";
            echo "di_user_ref_id.<br />";
            echo "added_by.<br />";
            die();
        }


    }

    public static function isDiUserHotleadAlreadyExist($student_hotlead_id,$di_user_ref_id){

        $model = DiUserHotlead::model()->findByAttributes(array(
            'student_hotlead_ref_id'	=> $student_hotlead_id,
            'di_user_ref_id'			=> $di_user_ref_id
        ));
        if($model===null){
            return false;
        } else{
            return true;
        }

    }

}
?>
