<?php

class  CollegesController extends Controller {
    public function init() {
        parent::init();
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_signup";
    }

	public function actionIndex()
	{
		$this->render('index');
	}

    public function actionTopColleges() {
        $this->setPageTitle(Yii::app()->name ." -  Top Colleges for You");

        $_SESSION['topColl'] = (!$_SESSION['topColl'] || ($_SESSION['topColl'] == 1)) ? 1 : 2;

        if (Yii::app()->session->itemAt('sUserUnivariety') == '') {
            $this->redirect('/app/student/createProfile');
        }
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);
        $url_det = LookupUrl::model()->findByPK($user->redirect_url_ref_id);
        if ($url_det) {
            if ($url_det->url == '/app/dashboard') {
                $this->redirect($url_det->url);
            }
        }

        $selected_country = $selected_dept = '';
        $prefCountries = $user->getPreferredCountries();
        $prefCourses = $user->getPreferredCourses();

        if (!empty($_POST)) {
            $selected_country = $_POST['country'];
            $selected_dept = $_POST['dept'];
            $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
            if ($_POST['marks'] == 'marks') {
                if ($edu_det->student_education_id) {
                    $criteria = new CDbCriteria;
                    $criteria->condition = "student_education_ref_id = '".$edu_det->student_education_id."'";
                    StudentGradeCount::model()->deleteAll($criteria);

                    $edu_obj = StudentEducation::model()->findByPk($edu_det->student_education_id);
                } else {
                    $edu_obj = new StudentEducation();
                    $edu_obj->user_ref_id = $userId;
                    $edu_obj->class_level = 12;
                    $edu_obj->added_on = date('Y-m-d H:i:s');
                }
                $edu_obj->board_ref_id = $_POST['board'];

                switch($_POST['overall_type']) {
                    case 'grades':
                        $edu_obj->overall_marks = NULL;
                        break;
                    case 'marks':
                        $edu_obj->overall_marks = $_POST['overall_marks'];
                        break;
                    case 'points':
                        $edu_obj->overall_marks = $_POST['overall_points'];
                        break;
                    case 'marks-gpa':
                        $edu_obj->overall_marks = $_POST['overall_marks'];
                        break;
                }
                $edu_obj->save(false);

                if ($_POST['overall_type'] == 'grades') {
                    $edu_det_new = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
                    if ($edu_det_new->student_education_id) {
                        if ($_POST['overall_aa']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 1;$grade_model->grade_count = $_POST['overall_aa'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }
                        if ($_POST['overall_a']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 2;$grade_model->grade_count = $_POST['overall_a'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($_POST['overall_b']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 3;$grade_model->grade_count = $_POST['overall_b'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($_POST['overall_c']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 4;$grade_model->grade_count = $_POST['overall_c'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }if ($_POST['overall_d']) {
                            $grade_model = new StudentGradeCount();$grade_model->student_education_ref_id = $edu_det_new->student_education_id;
                            $grade_model->grade_ref_id = 5;$grade_model->grade_count = $_POST['overall_d'];
                            $grade_model->added_on = date('Y-m-d H:i:s');
                            $grade_model->save(false);
                        }
                    }
                }
            }

            $criticalFields['board'] = 1;
            $criticalFields['overall_marks'] = 1;
            TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);

            $selected_dept_det = LookupDepartment::model()->findByPk($selected_dept);
            $topColleges = ($selected_dept_det->parent_dept_id == 0) ? DiHelper::getTopCollege(0, 10, $selected_dept, $selected_country, $user->gender) : DiHelper::getTopCollegeBySubDept(0, 10, $selected_dept_det->parent_dept_id, $selected_country, $selected_dept, $user->gender);
        } else {
            foreach($prefCountries as $id=>$country) {
                $country = $id;
                foreach($prefCourses as $id=>$dept) {
                    $depts = $dept['main_dept_ref_id'];

                    $topColleges = DiHelper::getTopCollege(0, 10, $depts, $country, $user->gender);
                    if (count($topColleges) > 0) {
                        $selected_country = $country;
                        $selected_dept = $depts;
                        $selected_dept_det = LookupDepartment::model()->findByPk($selected_dept);break;
                    }
                }
                if (count($topColleges) > 0) {
                    break;
                }
            }
        }

        $parent_dept = ($selected_dept_det->parent_dept_id == 0) ? $selected_dept : $selected_dept_det->parent_dept_id;

        $shortListData = $shortListedColleges = array();
        $shortList = new ShortListEngine();
        $shortListData = $shortList->getShortList();

        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject'){
                $shortListedColleges[$key] = $key;
            }
        }

        $edu_det = StudentEducation::model()->findByAttributes(array('user_ref_id'=>$userId, 'class_level'=>'12'));
        $this->render('top_colleges', array('user'=>$user, 'prefCountries'=>$prefCountries, 'topColleges'=>$topColleges, 'shortListedColleges'=>$shortListedColleges,
            'selected_country'=>$selected_country, 'selected_dept'=>$selected_dept, 'prefCourses'=>$prefCourses, 'edu_det'=>$edu_det, 'parent_dept'=>$parent_dept
        ));
    }

    public function actionGetOverallAndSubjects() {
        $classLevel = 12;
        $boardId = Yii::app()->request->getQuery('boardId');
        $boardDetails = LookupBoardEquivalent::GetBoardDetails($classLevel, $boardId);

        $overallMax = $boardDetails['overall_max'];
        $overallType = strtolower($boardDetails['overall_type']);


        $content = '<input type="hidden" id="overall_type" name="overall_type" value="'. $overallType.'" rel="'.$classLevel.'"><input type="hidden" id="overall_max" name="overall_max" value="'.$boardDetails['overall_max'].'" rel="'.$classLevel.'">';
        $exp = $classLevel == 12 ? '( Expected )' : '';
        switch ($boardDetails['overall_type']) {
            case 'Marks-GPA':
            {
                $overAll = CHtml::textField('overall_marks', '', array('id' => 'overall_marks', 'maxlength' => 3, 'placeholder' => 'Enter score (max 100)', 'class' => 'grid_4'));
                $overAll .= '<div style="display:none" id="overall_marks_err" class="errorMessage popup"></div>';
                $html = '<div class="left grid_3">Overall Marks</div><div class="relative left grid_6">'.$overAll.'</div>';
                break;
            }
            case 'Grades':
            {
                $gradeList = range(1, $overallMax);
                $gradeList = array_combine($gradeList, $gradeList);
                $gradeList[0] = 'Count';
                ksort($gradeList);

                $overAll = '<div class="left relative">A* '.CHtml::dropDownList('overall_aa', '', $gradeList, array( 'rel' => 'overall_aa', 'id' => 'overall_aa', 'class'=>'grid_1', 'style'=>'width:79px'));
                $overAll .= '<div style="display:none; ;" id="overall_aa_err" class="errorMessage popup"></div>'.'</div>';
                $overAll .= '<div class="left">A '.CHtml::dropDownList('overall_a', '', $gradeList, array( 'rel' => 'overall_a', 'id' => 'overall_a', 'class'=>'grid_1', 'style'=>'width:79px')).'</div>';
                $overAll .= '<div class="left">B '.CHtml::dropDownList('overall_b', '', $gradeList, array( 'rel' => 'overall_b', 'id' => 'overall_b', 'class'=>'grid_1', 'style'=>'width:79px')).'</div>';
                $overAll .= '<div class="left">C '.CHtml::dropDownList('overall_c', '', $gradeList, array( 'rel' => 'overall_c', 'id' => 'overall_c', 'class'=>'grid_1', 'style'=>'width:79px')).'</div>';
                $overAll .= '<div class="left">D '.CHtml::dropDownList('overall_d', '', $gradeList, array( 'rel' => 'overall_d', 'id' => 'overall_d', 'class'=>'grid_1', 'style'=>'width:79px')).'</div>';



                $html = '<div class="left grid_3">Overall Grades</div><div class="relative left grid_">'.$overAll.'</div>';
                break;
            }
            case 'Marks': {
                $overAll = CHtml::textField('overall_marks', '', array('id' => 'overall_marks', 'maxlength' => 3, 'placeholder' => 'Enter score (max 100)', 'class' => 'grid_4'));
                $overAll .= '<div style="display:none" id="overall_marks_err" class="errorMessage popup"></div>';
                $html = '<div class="left grid_3">Overall Marks</div><div class="relative left grid_6">'.$overAll.'</div>';
                break;
            }
            case 'Points':
            {
                $pointsList = range(1, $overallMax);
                $pointsList = array_combine($pointsList, $pointsList);
                arsort($pointsList);

                $overAll = CHtml::dropDownList('overall_points', '', $pointsList, array('empty' => 'Points', 'id' => 'overall_points', 'class' => 'grid_4'));;
                $overAll .= '<div style="display:none" id="overall_points_err" class="errorMessage popup"></div>';

                $html = '<div class="left grid_3">Overall Points</div><div class="relative left grid_6">'.$overAll.'</div>';
                break;
            }
        }
        echo $content.$html;

    }

    public function actionSkipAndEdu() {
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);

        $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_top_colleges_skip',), 1);
        $user->redirect_url_ref_id =$urlDetails[0]['url_id'];
        $user->save(false);
        $this->redirect($urlDetails[0]['url']);
    }

    public function actionIdealList() {
        $this->setPageTitle(Yii::app()->name ." -  Suggested Colleges for You");

        if (Yii::app()->session->itemAt('sUserUnivariety') == '') {
            $this->redirect('/app/student/createProfile');
        }

        $_SESSION['ideal'] = (!$_SESSION['ideal'] || ($_SESSION['ideal'] == 1)) ? 1 : 2;
        $selected_country = $selected_dept = 0;
        if (!empty($_POST)) {
            $selected_country = $_POST['country'];
            $selected_dept = $_POST['dept'];
        }

        $bestFitList = $safeList = $aspirationList = array();
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);
        $url_det = LookupUrl::model()->findByPK($user->redirect_url_ref_id);
        if ($url_det) {
            if ($url_det->url == '/app/dashboard') {
                $this->redirect($url_det->url);
            }
        }

        $idealListObj = new UserIdealList();
        $idealListObj->generateIdealList($userId, true);

        $objShortList = new ShortListEngine();

        $prefCountries = $user->getPreferredCountries();
        $prefCourses = $user->getPreferredCourses();
        if (($selected_country == 0) && ($selected_dept == 0)) {
            foreach($prefCountries as $id=>$country) {
                $country = $id;
                foreach($prefCourses as $id=>$dept) {
                    $idealListId = 0;
                    $depts = $dept['main_dept_ref_id'];

                    $selected_dept_det = LookupDepartment::model()->findByPk($selected_dept);
                    $idealListExist = UserIdealList::isIdealListExist($depts, $country, $userId, 1);
                    $idealListId = $idealListExist->user_ideal_list_id;
                    if ($idealListId != 0) {
                        $selected_country = $country;
                        $selected_dept = $depts;
                        $selected_dept_det = LookupDepartment::model()->findByPk($selected_dept);break;
                    }
                }
                if ($idealListId != 0) {
                    break;
                }
            }
        } else {
            $selected_dept_det = LookupDepartment::model()->findByPk($selected_dept);
            $idealListExist = ($selected_dept_det->parent_dept_id == 0) ? UserIdealList::isIdealListExist($selected_dept, $selected_country, $userId, 1) : UserIdealList::isIdealListExist($selected_dept_det->parent_dept_id, $selected_country, $userId, 1);
            $idealListId = $idealListExist->user_ideal_list_id;
        }




        $idealList = ($selected_dept_det->parent_dept_id == 0) ? UserIdealListUniversity::getIdealList($idealListId, $selected_dept) : UserIdealListUniversity::getIdealListBySubDept($idealListId, $selected_dept_det->parent_dept_id, NULL, $selected_dept);

        $bestFitList = $idealList['bestfit'];
        $safeList = $idealList['safe'];
        $aspirationList = $idealList['aspirational'];

        $shortList = new ShortListEngine();
        $shortListData = $shortList->getShortList();

        $parent_dept = ($selected_dept_det->parent_dept_id == 0) ? $selected_dept : $selected_dept_det->parent_dept_id;

        $this->render('ideal_list', array('bestFitList'=>$bestFitList, 'safeList'=>$safeList, 'aspirationList'=>$aspirationList, 'shortList'=>$shortListData, 'user'=>$user, 'userId'=>$userId, 'selected_country'=>$selected_country, 'selected_dept'=>$selected_dept, 'prefCountries'=>$prefCountries, 'prefCourses'=>$prefCourses, 'parent_dept'=>$parent_dept));
    }

    public function actionGenerateIdealist() {
        $userId = Yii::app()->user->sub_id;
        $idealListObj = new UserIdealList();
        $idealListObj->generateIdealList($userId);
    }


    public function actionSetToAlertPage() {
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);

        $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_alerts',), 1);
        $user->redirect_url_ref_id =$urlDetails[0]['url_id'];
        $user->save(false);
        $this->redirect($urlDetails[0]['url']);
    }

    public function actionNextIdealList() {
        $userId = Yii::app()->user->sub_id;
        $user = TblUserMaster::model()->findByPk($userId);

        $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_ideal_list',), 1);
        $user->redirect_url_ref_id =$urlDetails[0]['url_id'];
        $user->save(false);
        $this->redirect($urlDetails[0]['url']);
    }




}