<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseWorkshopMaster is autogenerate by UniModel generator
 *
 * This is the model class for table "workshop_master".
 *
 * The followings are the available columns in table 'workshop_master':
 * @property integer $workshop_master_id
 * @property string $workshop_name
 * @property string $workshop_type
 * @property integer $is_active
 *
 * The followings are the available model relations:
 * @property LookupEvent[] $lookupEvents
 * @property WorkshopSi[] $workshopSis
 */
class BaseWorkshopMaster extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WorkshopMaster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'workshop_master';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('is_active', 'numerical', 'integerOnly'=>true),
			array('workshop_name', 'length', 'max'=>100),
			array('workshop_type', 'length', 'max'=>18),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('workshop_master_id, workshop_name, workshop_type, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupEvents' => array(self::HAS_MANY, 'LookupEvent', 'workshop_master_ref_id'),
			'workshopSis' => array(self::HAS_MANY, 'WorkshopSi', 'workshop_master_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'workshop_master_id' => 'Workshop Master',
			'workshop_name' => 'Workshop Name',
			'workshop_type' => 'Workshop Type',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('workshop_master_id',$this->workshop_master_id);
		$criteria->compare('workshop_name',$this->workshop_name,true);
		$criteria->compare('workshop_type',$this->workshop_type,true);
		$criteria->compare('is_active',$this->is_active);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}