<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseWebinarEventComments is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_event_comments".
 *
 * The followings are the available columns in table 'tbl_event_comments':
 * @property integer $tbl_event_comments_id
 * @property integer $event_ref_id
 * @property string $login_ref_id
 * @property integer $parent_id
 * @property string $event_comment
 * @property string $added_on
 * @property string $is_active
 *
 * The followings are the available model relations:
 * @property TblEvent $eventRef
 * @property LoginMaster $loginRef
 */
class BaseWebinarEventComments extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WebinarEventComments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_event_comments';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id, parent_id', 'numerical', 'integerOnly'=>true),
			array('login_ref_id', 'length', 'max'=>10),
			array('is_active', 'length', 'max'=>1),
			array('event_comment, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tbl_event_comments_id, event_ref_id, login_ref_id, parent_id, event_comment, added_on, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventRef' => array(self::BELONGS_TO, 'WebinarEvent', 'event_ref_id'),
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tbl_event_comments_id' => 'Tbl Event Comments',
			'event_ref_id' => 'Event Ref',
			'login_ref_id' => 'Login Ref',
			'parent_id' => 'Parent',
			'event_comment' => 'Event Comment',
			'added_on' => 'Added On',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tbl_event_comments_id',$this->tbl_event_comments_id);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('parent_id',$this->parent_id);
		$criteria->compare('event_comment',$this->event_comment,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('is_active',$this->is_active,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}