<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorRequestTracker is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_request_tracker".
 *
 * The followings are the available columns in table 'vendor_request_tracker':
 * @property string $vendor_request_tracker_id
 * @property string $reference_key
 * @property string $reference_model
 * @property string $clicked_by
 * @property string $clicked_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $clickedBy
 */
class BaseVendorRequestTracker extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorRequestTracker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_request_tracker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('reference_key, reference_model, clicked_on', 'required'),
			array('reference_key, clicked_by', 'length', 'max'=>10),
			array('reference_model', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_request_tracker_id, reference_key, reference_model, clicked_by, clicked_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'clickedBy' => array(self::BELONGS_TO, 'LoginMaster', 'clicked_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_request_tracker_id' => 'Vendor Request Tracker',
			'reference_key' => 'Reference Key',
			'reference_model' => 'Reference Model',
			'clicked_by' => 'Clicked By',
			'clicked_on' => 'Clicked On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_request_tracker_id',$this->vendor_request_tracker_id,true);
		$criteria->compare('reference_key',$this->reference_key,true);
		$criteria->compare('reference_model',$this->reference_model,true);
		$criteria->compare('clicked_by',$this->clicked_by,true);
		$criteria->compare('clicked_on',$this->clicked_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}