<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorExpertQualification is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_expert_qualification".
 *
 * The followings are the available columns in table 'vendor_expert_qualification':
 * @property string $vendor_expert_qualification_id
 * @property integer $vendor_contact_ref_id
 * @property string $degree_name
 * @property string $degree_status
 * @property string $college_name
 * @property integer $completion_year
 *
 * The followings are the available model relations:
 * @property VendorContact $vendorContactRef
 */
class BaseVendorExpertQualification extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorExpertQualification the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_expert_qualification';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_contact_ref_id, completion_year', 'numerical', 'integerOnly'=>true),
			array('degree_name', 'length', 'max'=>10),
			array('degree_status', 'length', 'max'=>9),
			array('college_name', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_expert_qualification_id, vendor_contact_ref_id, degree_name, degree_status, college_name, completion_year', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorContactRef' => array(self::BELONGS_TO, 'VendorContact', 'vendor_contact_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_expert_qualification_id' => 'Vendor Expert Qualification',
			'vendor_contact_ref_id' => 'Vendor Contact Ref',
			'degree_name' => 'Degree Name',
			'degree_status' => 'Degree Status',
			'college_name' => 'College Name',
			'completion_year' => 'Completion Year',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_expert_qualification_id',$this->vendor_expert_qualification_id,true);
		$criteria->compare('vendor_contact_ref_id',$this->vendor_contact_ref_id);
		$criteria->compare('degree_name',$this->degree_name,true);
		$criteria->compare('degree_status',$this->degree_status,true);
		$criteria->compare('college_name',$this->college_name,true);
		$criteria->compare('completion_year',$this->completion_year);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}