<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorExpertInfo is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_expert_info".
 *
 * The followings are the available columns in table 'vendor_expert_info':
 * @property string $vendor_expert_info_id
 * @property integer $vendor_contact_ref_id
 * @property integer $exp_in_years
 * @property string $experience_info
 * @property integer $fee_per_session
 * @property integer $duration
 * @property string $photo_name
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property VendorContact $vendorContactRef
 */
class BaseVendorExpertInfo extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorExpertInfo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_expert_info';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_contact_ref_id, exp_in_years, fee_per_session, duration', 'numerical', 'integerOnly'=>true),
			array('photo_name', 'length', 'max'=>50),
			array('experience_info,currency_ref_id, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('currency_ref_id,vendor_expert_info_id, vendor_contact_ref_id, exp_in_years, experience_info, fee_per_session, duration, photo_name, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorContactRef' => array(self::BELONGS_TO, 'VendorContact', 'vendor_contact_ref_id'),
                        'lookupCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_expert_info_id' => 'Vendor Expert Info',
			'vendor_contact_ref_id' => 'Vendor Contact Ref',
			'exp_in_years' => 'Exp In Years',
			'experience_info' => 'Experience Info',
			'fee_per_session' => 'Fee Per Session',
			'duration' => 'Duration',
			'photo_name' => 'Photo Name',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_expert_info_id',$this->vendor_expert_info_id,true);
		$criteria->compare('vendor_contact_ref_id',$this->vendor_contact_ref_id);
		$criteria->compare('exp_in_years',$this->exp_in_years);
		$criteria->compare('experience_info',$this->experience_info,true);
		$criteria->compare('fee_per_session',$this->fee_per_session);
		$criteria->compare('duration',$this->duration);
		$criteria->compare('photo_name',$this->photo_name,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}