<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreTimings is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_timings".
 *
 * The followings are the available columns in table 'vendor_centre_timings':
 * @property integer $vendor_centre_timings_id
 * @property string $vendor_centre_ref_id
 * @property string $day_name
 * @property integer $from_hours
 * @property integer $from_mins
 * @property integer $to_hours
 * @property integer $to_mins
 * @property string $is_closed
 * @property string $hour_type
 *
 * The followings are the available model relations:
 * @property VendorCentre $vendorCentreRef
 */
class BaseVendorCentreTimings extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreTimings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_timings';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('from_hours, from_mins, to_hours, to_mins', 'numerical', 'integerOnly'=>true),
			array('vendor_centre_ref_id', 'length', 'max'=>10),
			array('day_name', 'length', 'max'=>9),
			array('is_closed', 'length', 'max'=>1),
			array('hour_type', 'length', 'max'=>7),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_timings_id, vendor_centre_ref_id, day_name, from_hours, from_mins, to_hours, to_mins, is_closed, hour_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreRef' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_centre_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_timings_id' => 'Vendor Centre Timings',
			'vendor_centre_ref_id' => 'Vendor Centre Ref',
			'day_name' => 'Day Name',
			'from_hours' => 'From Hours',
			'from_mins' => 'From Mins',
			'to_hours' => 'To Hours',
			'to_mins' => 'To Mins',
			'is_closed' => 'Is Closed',
			'hour_type' => 'Hour Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_timings_id',$this->vendor_centre_timings_id);
		$criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
		$criteria->compare('day_name',$this->day_name,true);
		$criteria->compare('from_hours',$this->from_hours);
		$criteria->compare('from_mins',$this->from_mins);
		$criteria->compare('to_hours',$this->to_hours);
		$criteria->compare('to_mins',$this->to_mins);
		$criteria->compare('is_closed',$this->is_closed,true);
		$criteria->compare('hour_type',$this->hour_type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}