<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreFacultyCourses is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_faculty_courses".
 *
 * The followings are the available columns in table 'vendor_centre_faculty_courses':
 * @property integer $vendor_centre_faculty_courses_id
 * @property integer $vendor_centre_faculty_ref_id
 * @property string $vendor_centre_course_ref_id
 *
 * The followings are the available model relations:
 * @property VendorCentreFaculty $vendorCentreFacultyRef
 * @property VendorCentreCourse $vendorCentreCourseRef
 */
class BaseVendorCentreFacultyCourses extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreFacultyCourses the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_faculty_courses';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_centre_faculty_ref_id', 'numerical', 'integerOnly'=>true),
			array('vendor_centre_course_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_faculty_courses_id, vendor_centre_faculty_ref_id, vendor_centre_course_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreFacultyRef' => array(self::BELONGS_TO, 'VendorCentreFaculty', 'vendor_centre_faculty_ref_id'),
			'vendorCentreCourseRef' => array(self::BELONGS_TO, 'VendorCentreCourse', 'vendor_centre_course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_faculty_courses_id' => 'Vendor Centre Faculty Courses',
			'vendor_centre_faculty_ref_id' => 'Vendor Centre Faculty Ref',
			'vendor_centre_course_ref_id' => 'Vendor Centre Course Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_faculty_courses_id',$this->vendor_centre_faculty_courses_id);
		$criteria->compare('vendor_centre_faculty_ref_id',$this->vendor_centre_faculty_ref_id);
		$criteria->compare('vendor_centre_course_ref_id',$this->vendor_centre_course_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}