<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCenterContact is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_center_contact".
 *
 * The followings are the available columns in table 'vendor_center_contact':
 * @property integer $vendor_center_contact_id
 * @property integer $vendor_center_ref_id
 * @property string $contact_type
 * @property string $number
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property VendorCenter $vendorCenterRef
 */
class BaseVendorCenterContact extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCenterContact the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_center_contact';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_center_ref_id, contact_type, number, added_by, added_on', 'required'),
			array('vendor_center_ref_id', 'numerical', 'integerOnly'=>true),
			array('contact_type', 'length', 'max'=>8),
			array('number', 'length', 'max'=>50),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_center_contact_id, vendor_center_ref_id, contact_type, number, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'vendorCenterRef' => array(self::BELONGS_TO, 'VendorCenter', 'vendor_center_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_center_contact_id' => 'Vendor Center Contact',
			'vendor_center_ref_id' => 'Vendor Center Ref',
			'contact_type' => 'Contact Type',
			'number' => 'Number',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_center_contact_id',$this->vendor_center_contact_id);
		$criteria->compare('vendor_center_ref_id',$this->vendor_center_ref_id);
		$criteria->compare('contact_type',$this->contact_type,true);
		$criteria->compare('number',$this->number,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}