<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserScholarship is autogenerate by UniModel generator
 *
 * This is the model class for table "user_scholarship".
 *
 * The followings are the available columns in table 'user_scholarship':
 * @property string $user_scholarship_id
 * @property string $user_ref_id
 * @property string $scholarship_ref_id
 * @property string $get_alert
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property Scholarship $scholarshipRef
 * @property TblUserMaster $userRef
 */
class BaseUserScholarship extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserScholarship the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_scholarship';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, scholarship_ref_id, added_on, added_by', 'required'),
			array('user_ref_id, scholarship_ref_id, added_by', 'length', 'max'=>10),
			array('get_alert', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_scholarship_id, user_ref_id, scholarship_ref_id, get_alert, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_scholarship_id' => 'User Scholarship',
			'user_ref_id' => 'User Ref',
			'scholarship_ref_id' => 'Scholarship Ref',
			'get_alert' => 'Get Alert',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_scholarship_id',$this->user_scholarship_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('get_alert',$this->get_alert,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}