<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserProfileReminder is autogenerate by UniModel generator
 *
 * This is the model class for table "user_profile_reminder".
 *
 * The followings are the available columns in table 'user_profile_reminder':
 * @property string $reminder_id
 * @property string $user_ref_id
 * @property string $assigned_to
 * @property string $reminder_text
 * @property string $remind_date
 * @property string $remind_time
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $assignedTo
 * @property TblUserMaster $userRef
 */
class BaseUserProfileReminder extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserProfileReminder the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_profile_reminder';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, assigned_to, remind_date, added_on, added_by', 'required'),
			array('user_ref_id, assigned_to, added_by', 'length', 'max'=>10),
			array('reminder_text, remind_time, subject', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('reminder_id, user_ref_id, assigned_to, subject, reminder_text, remind_date, remind_time, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'assignedTo' => array(self::BELONGS_TO, 'LoginMaster', 'assigned_to'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'reminder_id' => 'Reminder',
			'user_ref_id' => 'User Ref',
			'assigned_to' => 'Assigned To',
			'reminder_text' => 'Reminder Text',
			'remind_date' => 'Remind Date',
			'remind_time' => 'Remind Time',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('reminder_id',$this->reminder_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('assigned_to',$this->assigned_to,true);
		$criteria->compare('reminder_text',$this->reminder_text,true);
		$criteria->compare('remind_date',$this->remind_date,true);
		$criteria->compare('remind_time',$this->remind_time,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}