<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserIdealListUniversityLog is autogenerate by UniModel generator
 *
 * This is the model class for table "user_ideal_list_university_log".
 *
 * The followings are the available columns in table 'user_ideal_list_university_log':
 * @property string $user_ideal_list_university_log_id
 * @property string $user_ideal_list_university_ref_id
 * @property string $action_status
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property UserIdealListUniversity $userIdealListUniversityRef
 * @property LoginMaster $addedBy
 */
class BaseUserIdealListUniversityLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserIdealListUniversityLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_ideal_list_university_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ideal_list_university_ref_id, added_on, added_by', 'required'),
			array('user_ideal_list_university_ref_id, added_by', 'length', 'max'=>10),
			array('action_status', 'length', 'max'=>9),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_ideal_list_university_log_id, user_ideal_list_university_ref_id, action_status, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userIdealListUniversityRef' => array(self::BELONGS_TO, 'UserIdealListUniversity', 'user_ideal_list_university_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_ideal_list_university_log_id' => 'User Ideal List University Log',
			'user_ideal_list_university_ref_id' => 'User Ideal List University Ref',
			'action_status' => 'Action Status',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_ideal_list_university_log_id',$this->user_ideal_list_university_log_id,true);
		$criteria->compare('user_ideal_list_university_ref_id',$this->user_ideal_list_university_ref_id,true);
		$criteria->compare('action_status',$this->action_status,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}