<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserIdealListUniversity is autogenerate by UniModel generator
 *
 * This is the model class for table "user_ideal_list_university".
 *
 * The followings are the available columns in table 'user_ideal_list_university':
 * @property string $user_ideal_list_university_id
 * @property string $user_ideal_list_ref_id
 * @property integer $uni_ref_id
 * @property double $score
 * @property string $university_type
 * @property string $suggest_by
 * @property string $suggested_by_ref_id
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property LoginMaster $suggestedByRef
 * @property TblUniversityMaster $uniRef
 * @property UserIdealList $userIdealListRef
 */
class BaseUserIdealListUniversity extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserIdealListUniversity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_ideal_list_university';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ideal_list_ref_id, uni_ref_id, score, suggested_by_ref_id, added_on, added_by', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('score', 'numerical'),
			array('user_ideal_list_ref_id, suggest_by, suggested_by_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('university_type', 'length', 'max'=>12),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_ideal_list_university_id, user_ideal_list_ref_id, uni_ref_id, score, university_type, suggest_by, suggested_by_ref_id, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'suggestedByRef' => array(self::BELONGS_TO, 'LoginMaster', 'suggested_by_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'userIdealListRef' => array(self::BELONGS_TO, 'UserIdealList', 'user_ideal_list_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_ideal_list_university_id' => 'User Ideal List University',
			'user_ideal_list_ref_id' => 'User Ideal List Ref',
			'uni_ref_id' => 'Uni Ref',
			'score' => 'Score',
			'university_type' => 'University Type',
			'suggest_by' => 'Suggest By',
			'suggested_by_ref_id' => 'Suggested By Ref',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_ideal_list_university_id',$this->user_ideal_list_university_id,true);
		$criteria->compare('user_ideal_list_ref_id',$this->user_ideal_list_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('score',$this->score);
		$criteria->compare('university_type',$this->university_type,true);
		$criteria->compare('suggest_by',$this->suggest_by,true);
		$criteria->compare('suggested_by_ref_id',$this->suggested_by_ref_id,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}