<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserEntranceExamModule is autogenerate by UniModel generator
 *
 * This is the model class for table "user_entrance_exam_module".
 *
 * The followings are the available columns in table 'user_entrance_exam_module':
 * @property string $user_entrance_exam_module_id
 * @property string $user_entrance_exam_ref_id
 * @property string $entrance_exam_module_entrance_exam_ref_id
 * @property string $marks
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property UserEntranceExam $userEntranceExamRef
 * @property EntranceExamModuleEntranceExam $entranceExamModuleEntranceExamRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseUserEntranceExamModule extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserEntranceExamModule the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_entrance_exam_module';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_entrance_exam_ref_id, entrance_exam_module_entrance_exam_ref_id, marks, added_on, added_by', 'required'),
			array('user_entrance_exam_ref_id, entrance_exam_module_entrance_exam_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('marks', 'length', 'max'=>8),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_entrance_exam_module_id, user_entrance_exam_ref_id, entrance_exam_module_entrance_exam_ref_id, marks, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userEntranceExamRef' => array(self::BELONGS_TO, 'UserEntranceExam', 'user_entrance_exam_ref_id'),
			'entranceExamModuleEntranceExamRef' => array(self::BELONGS_TO, 'EntranceExamModuleEntranceExam', 'entrance_exam_module_entrance_exam_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_entrance_exam_module_id' => 'User Entrance Exam Module',
			'user_entrance_exam_ref_id' => 'User Entrance Exam Ref',
			'entrance_exam_module_entrance_exam_ref_id' => 'Entrance Exam Module Entrance Exam Ref',
			'marks' => 'Marks',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_entrance_exam_module_id',$this->user_entrance_exam_module_id,true);
		$criteria->compare('user_entrance_exam_ref_id',$this->user_entrance_exam_ref_id,true);
		$criteria->compare('entrance_exam_module_entrance_exam_ref_id',$this->entrance_exam_module_entrance_exam_ref_id,true);
		$criteria->compare('marks',$this->marks,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}