<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserEntranceExam is autogenerate by UniModel generator
 *
 * This is the model class for table "user_entrance_exam".
 *
 * The followings are the available columns in table 'user_entrance_exam':
 * @property string $user_entrance_exam_id
 * @property string $user_ref_id
 * @property integer $entrance_exam_ref_id
 * @property string $exam_status
 * @property integer $exam_day
 * @property integer $exam_month
 * @property integer $exam_year
 * @property string $overall_marks
 * @property string $shortlist_status
 * @property string $user_entered_entrance
 * @property string $get_alert
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 * @property string $joined_coaching_inst
 * @property string $reappear_exam
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property EntranceExam $entranceExamRef
 * @property LoginMaster $modifiedBy
 * @property TblUserMaster $userRef
 * @property UserEntranceExamModule[] $userEntranceExamModules
 */
class BaseUserEntranceExam extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserEntranceExam the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_entrance_exam';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, exam_status, overall_marks, added_on, added_by', 'required'),
			array('entrance_exam_ref_id, exam_day, exam_month, exam_year', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('exam_status', 'length', 'max'=>9),
			array('overall_marks', 'length', 'max'=>8),
			array('shortlist_status, get_alert, joined_coaching_inst, reappear_exam', 'length', 'max'=>1),
			array('user_entered_entrance', 'length', 'max'=>100),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_entrance_exam_id, user_ref_id, entrance_exam_ref_id, exam_status, exam_day, exam_month, exam_year, overall_marks, shortlist_status, user_entered_entrance, get_alert, added_on, added_by, modified_on, modified_by, joined_coaching_inst, reappear_exam', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'userEntranceExamModules' => array(self::HAS_MANY, 'UserEntranceExamModule', 'user_entrance_exam_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_entrance_exam_id' => 'User Entrance Exam',
			'user_ref_id' => 'User Ref',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'exam_status' => 'Exam Status',
			'exam_day' => 'Exam Day',
			'exam_month' => 'Exam Month',
			'exam_year' => 'Exam Year',
			'overall_marks' => 'Overall Marks',
			'shortlist_status' => 'Shortlist Status',
			'user_entered_entrance' => 'User Entered Entrance',
			'get_alert' => 'Get Alert',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'joined_coaching_inst' => 'Joined Coaching Inst',
			'reappear_exam' => 'Reappear Exam',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_entrance_exam_id',$this->user_entrance_exam_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('exam_status',$this->exam_status,true);
		$criteria->compare('exam_day',$this->exam_day);
		$criteria->compare('exam_month',$this->exam_month);
		$criteria->compare('exam_year',$this->exam_year);
		$criteria->compare('overall_marks',$this->overall_marks,true);
		$criteria->compare('shortlist_status',$this->shortlist_status,true);
		$criteria->compare('user_entered_entrance',$this->user_entered_entrance,true);
		$criteria->compare('get_alert',$this->get_alert,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('joined_coaching_inst',$this->joined_coaching_inst,true);
		$criteria->compare('reappear_exam',$this->reappear_exam,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}