<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityPageView is autogenerate by UniModel generator
 *
 * This is the model class for table "university_page_view".
 *
 * The followings are the available columns in table 'university_page_view':
 * @property string $university_page_view_id
 * @property integer $uni_ref_id
 * @property string $view_count
 * @property string $last_viewed_on
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 */
class BaseUniversityPageView extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityPageView the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_page_view';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('view_count', 'length', 'max'=>10),
			array('last_viewed_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_page_view_id, uni_ref_id, view_count, last_viewed_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_page_view_id' => 'University Page View',
			'uni_ref_id' => 'Uni Ref',
			'view_count' => 'View Count',
			'last_viewed_on' => 'Last Viewed On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_page_view_id',$this->university_page_view_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('view_count',$this->view_count,true);
		$criteria->compare('last_viewed_on',$this->last_viewed_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}