<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityDepartmentMasterWeightage is autogenerate by UniModel generator
 *
 * This is the model class for table "university_department_master_weightage".
 *
 * The followings are the available columns in table 'university_department_master_weightage':
 * @property integer $university_department_master_weightage_id
 * @property integer $uni_ref_id
 * @property integer $main_department_ref_id
 * @property integer $academics_weightage
 * @property integer $std_test_weightage
 * @property integer $extra_curricular_weightage
 * @property integer $work_experience_weightage
 *
 * The followings are the available model relations:
 * @property LookupDepartment $mainDepartmentRef
 * @property TblUniversityMaster $uniRef
 */
class BaseUniversityDepartmentMasterWeightage extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityDepartmentMasterWeightage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_department_master_weightage';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, main_department_ref_id, academics_weightage, std_test_weightage, extra_curricular_weightage, work_experience_weightage', 'required'),
			array('uni_ref_id, main_department_ref_id, academics_weightage, std_test_weightage, extra_curricular_weightage, work_experience_weightage', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_department_master_weightage_id, uni_ref_id, main_department_ref_id, academics_weightage, std_test_weightage, extra_curricular_weightage, work_experience_weightage', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mainDepartmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_department_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_department_master_weightage_id' => 'University Department Master Weightage',
			'uni_ref_id' => 'Uni Ref',
			'main_department_ref_id' => 'Main Department Ref',
			'academics_weightage' => 'Academics Weightage',
			'std_test_weightage' => 'Std Test Weightage',
			'extra_curricular_weightage' => 'Extra Curricular Weightage',
			'work_experience_weightage' => 'Work Experience Weightage',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_department_master_weightage_id',$this->university_department_master_weightage_id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('main_department_ref_id',$this->main_department_ref_id);
		$criteria->compare('academics_weightage',$this->academics_weightage);
		$criteria->compare('std_test_weightage',$this->std_test_weightage);
		$criteria->compare('extra_curricular_weightage',$this->extra_curricular_weightage);
		$criteria->compare('work_experience_weightage',$this->work_experience_weightage);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}